/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.dialect;

import net.java.amateras.db.Messages;
import net.java.amateras.db.dialect.AbstractDialect;
import net.java.amateras.db.dialect.ColumnType;
import net.java.amateras.db.dialect.IColumnType;
import net.java.amateras.db.visual.model.ColumnModel;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;

public class DerbyDialect
extends AbstractDialect {
    private static final IColumnType[] COLUMN_TYPES = new IColumnType[]{new ColumnType("BOOLEAN", Messages.getResourceString("type.boolean"), true, 16), new ColumnType("BIGINT", Messages.getResourceString("type.integer"), true, -5), new ColumnType("VARCHAR", Messages.getResourceString("type.string"), true, 12), new ColumnType("LONG VARCHAR", Messages.getResourceString("type.string"), true, 12), new ColumnType("CHAR", Messages.getResourceString("type.char"), true, 1), new ColumnType("CHARACTER", Messages.getResourceString("type.char"), true, 1), new ColumnType("DECIMAL", Messages.getResourceString("type.real"), true, 3), new ColumnType("DEC", Messages.getResourceString("type.real"), true, 3), new ColumnType("NUMERIC", Messages.getResourceString("type.numeric"), true, 2), new ColumnType("NUM", Messages.getResourceString("type.numeric"), true, 2), new ColumnType("INT", Messages.getResourceString("type.integer"), true, 4), new ColumnType("INTEGER", Messages.getResourceString("type.integer"), true, 4), new ColumnType("DOUBLE", Messages.getResourceString("type.real"), true, 8), new ColumnType("FLOAT", Messages.getResourceString("type.real"), true, 6), new ColumnType("DATE", Messages.getResourceString("type.date"), false, 91), new ColumnType("TIME", Messages.getResourceString("type.time"), false, 92), new ColumnType("TIMESTAMP", Messages.getResourceString("type.datetime"), false, 93), new ColumnType("REAL", Messages.getResourceString("type.real"), true, 7), new ColumnType("SMALLINT", Messages.getResourceString("type.integer"), true, 5), new ColumnType("CHARACTER VARYING FOR BIT DATA", Messages.getResourceString("type.binary"), true, -2), new ColumnType("CHAR VARYING FOR BIT DATA", Messages.getResourceString("type.binary"), true, -2), new ColumnType("VARCHAR FOR BIT DATA", Messages.getResourceString("type.binary"), true, -2)};

    public DerbyDialect() {
        super(COLUMN_TYPES);
    }

    protected String createColumnDDL(RootModel root, TableModel tableModel, ColumnModel columnModel, boolean schema, boolean alterTable, StringBuilder additions) {
        String ddl = super.createColumnDDL(root, tableModel, columnModel, schema, alterTable, additions);
        if (columnModel.isAutoIncrement()) {
            ddl = String.valueOf(ddl) + " GENERATED ALWAYS AS IDENTITY";
        }
        return ddl;
    }

    public String getColumnMetadataSQL(String tableName) {
        return String.valueOf(super.getColumnMetadataSQL(tableName)) + "  FETCH FIRST 1 ROW ONLY";
    }

    protected void createDropTableStatement(StringBuilder sb, String tableName) {
        sb.append("DROP TABLE ").append(tableName).append(";");
    }
}

