/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.dialect;

import net.java.amateras.db.Messages;
import net.java.amateras.db.dialect.AbstractDialect;
import net.java.amateras.db.dialect.ColumnType;
import net.java.amateras.db.dialect.IColumnType;
import net.java.amateras.db.dialect.ISchemaLoader;
import net.java.amateras.db.dialect.SybaseSchemaLoader;
import net.java.amateras.db.util.StringUtils;
import net.java.amateras.db.visual.model.ColumnModel;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;

public class SybaseDialect
extends AbstractDialect {
    private static final IColumnType[] COLUMN_TYPES = new IColumnType[]{new ColumnType("BIT", Messages.getResourceString("type.bit"), true, -7), new ColumnType("INT", Messages.getResourceString("type.integer"), true, 4), new ColumnType("BIGINT", Messages.getResourceString("type.integer"), true, -5), new ColumnType("SMALLINT", Messages.getResourceString("type.integer"), true, 5), new ColumnType("TINYINT", Messages.getResourceString("type.integer"), true, -6), new ColumnType("NUMERIC", Messages.getResourceString("type.numeric"), true, 2), new ColumnType("REAL", Messages.getResourceString("type.real"), false, 8), new ColumnType("FLOAT", Messages.getResourceString("type.real"), false, 6), new ColumnType("VARCHAR", Messages.getResourceString("type.string"), true, 12), new ColumnType("VARCHAR", Messages.getResourceString("type.string"), true, 2005), new ColumnType("CHAR", Messages.getResourceString("type.char"), true, 1), new ColumnType("DATETIME", Messages.getResourceString("type.date"), false, 91), new ColumnType("TIMESTAMP", Messages.getResourceString("type.date"), true, 93), new ColumnType("IMAGE", Messages.getResourceString("type.binary"), true, 2004)};

    public SybaseDialect() {
        super(COLUMN_TYPES, "GO");
    }

    public ISchemaLoader getSchemaLoader() {
        return new SybaseSchemaLoader();
    }

    protected String createColumnDDL(RootModel root, TableModel tableModel, ColumnModel columnModel, boolean schema, boolean alterTable, StringBuilder additions) {
        String ddl = super.createColumnDDL(root, tableModel, columnModel, schema, alterTable, additions);
        if (columnModel.isAutoIncrement()) {
            ddl = String.valueOf(ddl) + " IDENTITY ";
        }
        if (StringUtils.isNotEmpty(columnModel.getLogicalName())) {
            ddl = String.valueOf(ddl) + "  /*" + columnModel.getLogicalName() + " */";
        }
        return ddl;
    }

    protected void createDropTableStatement(StringBuilder sb, String tableName) {
        sb.append(" IF EXISTS (").append(this.LS);
        sb.append("     SELECT 1").append(this.LS);
        sb.append("     FROM sysobjects").append(this.LS);
        sb.append("     WHERE name = '").append(tableName).append("' ").append(this.LS);
        sb.append("     AND type = 'U'").append(this.LS);
        sb.append(" )").append(this.LS);
        sb.append(" DROP TABLE ").append(tableName).append(this.LS);
        sb.append(" GO").append(this.LS);
    }

    public String getColumnMetadataSQL(String tableName) {
        return "SELECT TOP 1 * FROM " + tableName;
    }
}

