/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.dialect;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.dialect.DefaultSchemaLoader;
import net.java.amateras.db.dialect.IColumnType;
import net.java.amateras.db.dialect.IDialect;
import net.java.amateras.db.util.StringUtils;
import net.java.amateras.db.visual.model.ColumnModel;
import net.java.amateras.db.visual.model.IndexModel;
import net.java.amateras.db.visual.model.TableModel;

public class SybaseSchemaLoader
extends DefaultSchemaLoader {
    protected TableModel getTableInfo(String tableName, IDialect dialect, Connection conn, String catalog, String schema, boolean autoConvert) throws SQLException {
        boolean hasCommentTable = this.existsCommentTable(conn);
        TableModel table = new TableModel();
        table.setTableName(tableName);
        if (autoConvert || !hasCommentTable) {
            table.setLogicalName(table.getTableName());
        } else {
            table.setLogicalName(this.getTableComment(tableName, conn, catalog, schema));
        }
        DatabaseMetaData meta = conn.getMetaData();
        ArrayList<ColumnModel> list = new ArrayList<ColumnModel>();
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(dialect.getColumnMetadataSQL(this.getTableName(tableName, schema)));
        ResultSetMetaData rm = rs.getMetaData();
        ResultSet columns = meta.getColumns(catalog, schema, tableName, "%");
        while (columns.next()) {
            IColumnType type = dialect.getColumnType(columns.getString("TYPE_NAME"));
            if (type == null && (type = dialect.getColumnType(columns.getInt("DATA_TYPE"))) == null) {
                type = dialect.getDefaultColumnType();
            }
            ColumnModel column = new ColumnModel();
            column.setColumnName(columns.getString("COLUMN_NAME"));
            if (autoConvert || !hasCommentTable) {
                column.setLogicalName(column.getColumnName());
            } else {
                column.setLogicalName(this.getColumnComment(tableName, columns.getString("COLUMN_NAME"), conn, catalog, schema));
            }
            if (hasCommentTable) {
                column.setDescription(this.getColumnDescription(tableName, columns.getString("COLUMN_NAME"), conn, catalog, schema));
            }
            column.setColumnType(type);
            column.setSize(columns.getString("COLUMN_SIZE"));
            column.setNotNull(columns.getString("IS_NULLABLE").equals("NO"));
            int rmIndex = this.getResultSetMetaDataIndex(rm, column.getColumnName());
            if (rmIndex > 0) {
                column.setAutoIncrement(rm.isAutoIncrement(rmIndex));
            }
            list.add(column);
        }
        columns.close();
        ResultSet keys = meta.getPrimaryKeys(catalog, schema, tableName);
        while (keys.next()) {
            String columnName = keys.getString("COLUMN_NAME");
            int i = 0;
            while (i < list.size()) {
                ColumnModel column = (ColumnModel)list.get(i);
                if (column.getColumnName().equals(columnName)) {
                    column.setPrimaryKey(true);
                }
                ++i;
            }
        }
        keys.close();
        rs.close();
        stmt.close();
        table.setColumns(list.toArray(new ColumnModel[list.size()]));
        List<IndexModel> indices = this.loadIndexModels(tableName, dialect, conn, catalog, schema, list);
        table.setIndices(indices.toArray(new IndexModel[indices.size()]));
        return table;
    }

    private String getTableName(String tabName, String schema) {
        if (StringUtils.isNotEmpty(schema)) {
            return String.valueOf(schema) + "." + tabName;
        }
        return tabName;
    }

    private boolean existsCommentTable(Connection conn) throws SQLException {
        boolean exists = false;
        StringBuffer query = new StringBuffer();
        query.append("select name from sysobjects where name = 'all_comments' ");
        PreparedStatement pstmt = conn.prepareStatement(query.toString());
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            exists = true;
        }
        rs.close();
        pstmt.close();
        return exists;
    }

    protected String getTableComment(String tableName, Connection conn, String catalog, String schema) throws SQLException {
        String comment = tableName;
        StringBuffer query = new StringBuffer();
        query.append("select table_name from all_comments where table_id = ? ");
        PreparedStatement pstmt = conn.prepareStatement(query.toString());
        pstmt.setString(1, tableName);
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            comment = rs.getString(1);
        }
        rs.close();
        pstmt.close();
        return StringUtils.isEmpty(comment) ? tableName : comment.trim();
    }

    protected String getColumnComment(String tableName, String columnName, Connection conn, String catalog, String schema) throws SQLException {
        String comment = columnName;
        StringBuffer query = new StringBuffer();
        query.append("select column_name from all_comments where table_id = ? and column_id = ? ");
        PreparedStatement pstmt = conn.prepareStatement(query.toString());
        pstmt.setString(1, tableName);
        pstmt.setString(2, columnName);
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            comment = rs.getString(1);
        }
        rs.close();
        pstmt.close();
        return StringUtils.isEmpty(comment) ? columnName : comment.trim();
    }

    protected String getColumnDescription(String tableName, String columnName, Connection conn, String catalog, String schema) {
        String comment;
        block18: {
            comment = "";
            Statement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    StringBuffer query = new StringBuffer();
                    query.append("select description from all_comments where table_id = ? and column_id = ? ");
                    pstmt = conn.prepareStatement(query.toString());
                    pstmt.setString(1, tableName);
                    pstmt.setString(2, columnName);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        comment = rs.getString(1);
                    }
                }
                catch (SQLException e) {
                    DBPlugin.logException(new Exception("getColumnDescription error"));
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (pstmt != null) {
                            pstmt.close();
                        }
                        break block18;
                    }
                    catch (Exception exception) {}
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                }
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return StringUtils.isEmpty(comment) ? "" : comment.trim();
    }
}

