/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.dialect;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.java.amateras.db.visual.model.AbstractDBConnectionModel;
import net.java.amateras.db.visual.model.ForeignKeyModel;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableDependencyCalculator {
    public static List<TableModel> getSortedTable(RootModel root) {
        ArrayList<TableModel> result = new ArrayList<TableModel>();
        for (TableModel table : root.getTables()) {
            TableDependencyCalculator.addTableModel(result, table, null);
        }
        return result;
    }

    private static void addTableModel(List<TableModel> result, TableModel table, Set<TableModel> dependentModels) {
        if (dependentModels == null) {
            dependentModels = new HashSet<TableModel>();
        }
        if (result.contains(table)) {
            return;
        }
        HashSet<TableModel> innerDependentModels = new HashSet<TableModel>(dependentModels);
        dependentModels.add(table);
        for (AbstractDBConnectionModel conn : table.getModelSourceConnections()) {
            if (!(conn instanceof ForeignKeyModel)) continue;
            ForeignKeyModel fk = (ForeignKeyModel)conn;
            TableModel target = (TableModel)fk.getTarget();
            if (!dependentModels.contains(target)) {
                TableDependencyCalculator.addTableModel(result, target, innerDependentModels);
                continue;
            }
            throw new IllegalStateException("Circular foreign key dependency between tables " + table.getTableName() + " and " + target.getTableName());
        }
        result.add(table);
    }
}

