/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.htmlgen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.java.amateras.db.htmlgen.AbstractDBConnectionModel;
import net.java.amateras.db.htmlgen.ColumnModel;
import net.java.amateras.db.htmlgen.ForeignKeyMapping;
import net.java.amateras.db.htmlgen.TableModel;

public class ForeignKeyModel
extends AbstractDBConnectionModel {
    private String foreignKeyName = "";
    private Map<ColumnModel, ColumnModel> references = new HashMap<ColumnModel, ColumnModel>();
    public static final String P_FOREIGN_KEY_NAME = "p_foreign_key_name";
    public static final String P_FOREIGN_KEY_MAPPING = "p_foreign_key_mapping";

    public void setForeignKeyName(String foreignKeyName) {
        this.foreignKeyName = foreignKeyName;
    }

    public String getForeignKeyName() {
        return this.foreignKeyName;
    }

    public void setMapping(ForeignKeyMapping[] mapping) {
        this.references.clear();
        int i = 0;
        while (i < mapping.length) {
            this.references.put(mapping[i].getTarget(), mapping[i].getRefer());
            ++i;
        }
    }

    public ForeignKeyMapping[] getMapping() {
        ArrayList<ForeignKeyMapping> list = new ArrayList<ForeignKeyMapping>();
        TableModel target = (TableModel)this.getTarget();
        ColumnModel[] targetColumns = target.getColumns();
        int i = 0;
        while (i < targetColumns.length) {
            if (targetColumns[i].isPrimaryKey()) {
                int j;
                ForeignKeyMapping mapping = new ForeignKeyMapping();
                mapping.setTarget(targetColumns[i]);
                ColumnModel referColumn = this.references.get(targetColumns[i]);
                TableModel source = (TableModel)this.getSource();
                ColumnModel[] sourceColumns = source.getColumns();
                if (referColumn != null) {
                    j = 0;
                    while (j < sourceColumns.length) {
                        if (sourceColumns[j] == referColumn) {
                            mapping.setRefer(referColumn);
                            break;
                        }
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < sourceColumns.length) {
                        if (sourceColumns[j].getColumnName().equals(targetColumns[i].getColumnName())) {
                            referColumn = sourceColumns[j];
                            break;
                        }
                        ++j;
                    }
                    if (referColumn != null) {
                        mapping.setRefer(referColumn);
                    }
                }
                list.add(mapping);
            }
            ++i;
        }
        return list.toArray(new ForeignKeyMapping[list.size()]);
    }
}

