/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.htmlgen;

import java.util.ArrayList;
import java.util.List;
import net.java.amateras.db.htmlgen.AbstractDBEntityModel;
import net.java.amateras.db.htmlgen.AbstractDBModel;
import net.java.amateras.db.htmlgen.ColumnModel;
import net.java.amateras.db.htmlgen.DommainModel;
import net.java.amateras.db.htmlgen.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootModel
extends AbstractDBModel {
    private List<AbstractDBEntityModel> children = new ArrayList<AbstractDBEntityModel>();
    private List<DommainModel> dommains = new ArrayList<DommainModel>();
    private String dialectName = "";
    private boolean logicalMode = false;
    private String jarFile = "";
    private String jdbcDriver = "";
    private String jdbcUrl = "";
    private String jdbcUser = "";
    private String jdbcPassword = "";
    private String jdbcSchema = "";
    private String jdbcCatalog = "";
    private boolean includeView = false;
    public static final String P_MODE = "p_mode";
    public static final String P_JDBC_INFO = "p_jdbc_info";
    public static final String P_CHILDREN = "p_children";
    public static final String P_DOMMAINS = "p_dommains";

    public void copyFrom(RootModel model) {
        this.setDialectName(model.getDialectName());
        this.setLogicalMode(model.getLogicalMode());
        this.setJarFile(model.getJarFile());
        this.setJdbcDriver(model.getJdbcDriver());
        this.setJdbcUrl(model.getJdbcUrl());
        this.setJdbcUser(model.getJdbcUser());
        this.setJdbcPassword(model.getJdbcPassword());
        this.setJdbcSchema(model.getJdbcSchema());
        this.setJdbcCatalog(model.getJdbcCatalog());
        this.setIncludeView(model.isIncludeView());
        this.children.clear();
        this.children.addAll(model.getChildren());
        this.dommains.clear();
        this.dommains.addAll(model.getDommains());
    }

    public String getJarFile() {
        return this.jarFile;
    }

    public void setJarFile(String jarFile) {
        this.jarFile = jarFile;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public void setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public String getJdbcUser() {
        return this.jdbcUser;
    }

    public void setJdbcUser(String jdbcUser) {
        this.jdbcUser = jdbcUser;
    }

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public void setJdbcPassword(String jdbcPassword) {
        this.jdbcPassword = jdbcPassword;
    }

    public String getJdbcSchema() {
        return this.jdbcSchema;
    }

    public void setJdbcSchema(String jdbcSchema) {
        this.jdbcSchema = jdbcSchema;
    }

    public String getJdbcCatalog() {
        return this.jdbcCatalog;
    }

    public void setJdbcCatalog(String jdbcCatalog) {
        this.jdbcCatalog = jdbcCatalog;
    }

    public boolean isIncludeView() {
        return this.includeView;
    }

    public void setIncludeView(boolean includeView) {
        this.includeView = includeView;
    }

    public void setLogicalMode(boolean logicalMode) {
        this.logicalMode = logicalMode;
    }

    public boolean getLogicalMode() {
        return this.logicalMode;
    }

    public void addChild(AbstractDBEntityModel model) {
        this.children.add(model);
    }

    public void removeChild(AbstractDBEntityModel model) {
        this.children.remove(model);
    }

    public List<AbstractDBEntityModel> getChildren() {
        return this.children;
    }

    public List<TableModel> getTables() {
        ArrayList<TableModel> result = new ArrayList<TableModel>();
        for (AbstractDBEntityModel model : this.getChildren()) {
            if (!(model instanceof TableModel)) continue;
            result.add((TableModel)model);
        }
        return result;
    }

    public TableModel getTable(String tableName) {
        int i = 0;
        while (i < this.children.size()) {
            TableModel table = (TableModel)this.children.get(i);
            if (table.getTableName().equals(tableName)) {
                return table;
            }
            ++i;
        }
        return null;
    }

    public List<DommainModel> getDommains() {
        if (this.dommains == null) {
            this.dommains = new ArrayList<DommainModel>();
        }
        return this.dommains;
    }

    public void setDommains(List<DommainModel> dommains) {
        this.dommains = dommains;
        for (AbstractDBEntityModel entity : this.getChildren()) {
            if (!(entity instanceof TableModel)) continue;
            TableModel table = (TableModel)entity;
            ColumnModel[] columnModelArray = table.getColumns();
            int n = columnModelArray.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnModel column = columnModelArray[n2];
                if (column.getDommain() != null) {
                    for (DommainModel dommain : dommains) {
                        if (!dommain.getId().equals(column.getDommain().getId())) continue;
                        column.setDommain(dommain);
                        break;
                    }
                }
                ++n2;
            }
        }
    }

    public String getDialectName() {
        return this.dialectName;
    }

    public void setDialectName(String dialectName) {
        this.dialectName = dialectName;
    }
}

