/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.sqleditor;

import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.sqleditor.EditorColorProvider;
import net.java.amateras.db.sqleditor.SQLKeywordPartitionScanner;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class SQLConfiguration
extends SourceViewerConfiguration {
    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__sql_comment", "__sql_string"};
    }

    private RuleBasedScanner getCommentScanner() {
        RuleBasedScanner scanner = new RuleBasedScanner();
        EditorColorProvider colorProvider = DBPlugin.getDefault().getEditorColorProvider();
        scanner.setDefaultReturnToken(colorProvider.getToken("colorComment"));
        return scanner;
    }

    private RuleBasedScanner getStringScanner() {
        RuleBasedScanner scanner = new RuleBasedScanner();
        EditorColorProvider colorProvider = DBPlugin.getDefault().getEditorColorProvider();
        scanner.setDefaultReturnToken(colorProvider.getToken("colorString"));
        return scanner;
    }

    private RuleBasedScanner getDefaultScanner() {
        return new SQLKeywordPartitionScanner();
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer commentDR = new DefaultDamagerRepairer((ITokenScanner)this.getCommentScanner());
        reconciler.setDamager((IPresentationDamager)commentDR, "__sql_comment");
        reconciler.setRepairer((IPresentationRepairer)commentDR, "__sql_comment");
        DefaultDamagerRepairer stringDR = new DefaultDamagerRepairer((ITokenScanner)this.getStringScanner());
        reconciler.setDamager((IPresentationDamager)stringDR, "__sql_string");
        reconciler.setRepairer((IPresentationRepairer)stringDR, "__sql_string");
        DefaultDamagerRepairer keywordDR = new DefaultDamagerRepairer((ITokenScanner)this.getDefaultScanner());
        reconciler.setDamager((IPresentationDamager)keywordDR, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)keywordDR, "__dftl_partition_content_type");
        return reconciler;
    }
}

