/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.util;

import net.java.amateras.db.util.AbstractDialogPropertyDescriptor;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FontDialog;

public class FontPropertyDescriptor
extends AbstractDialogPropertyDescriptor {
    public FontPropertyDescriptor(Object id, String displayName) {
        super(id, displayName);
    }

    protected String getDisplayText(Object value) {
        FontData[] chosenFont = ((FontDataWrapper)value).getFontData();
        if (chosenFont == null || chosenFont.length == 0) {
            return "";
        }
        return String.valueOf(chosenFont[0].getName()) + " " + chosenFont[0].getHeight();
    }

    protected Object openDialogBox(Object value, Control cellEditorWindow) {
        FontData font;
        FontData[] chosenFont = ((FontDataWrapper)value).getFontData();
        FontDialog fontDialog = new FontDialog(cellEditorWindow.getShell());
        if (chosenFont != null) {
            fontDialog.setFontList(chosenFont);
        }
        if ((font = fontDialog.open()) != null) {
            return new FontDataWrapper(new FontData[]{font});
        }
        return null;
    }

    public static class FontDataWrapper {
        private FontData[] fontData;

        public FontDataWrapper(FontData[] fontData) {
            this.fontData = fontData;
        }

        public FontData[] getFontData() {
            return this.fontData;
        }

        public String toString() {
            if (this.fontData == null || this.fontData.length == 0) {
                return "";
            }
            return String.valueOf(this.fontData[0].getName()) + " " + this.fontData[0].getHeight();
        }
    }
}

