/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.java.amateras.db.util.IOUtils;

public class NameConverter {
    public static final List<Name> NAMES = new ArrayList<Name>();

    static {
        NameConverter.loadDefaultDictionary();
    }

    private static void loadDefaultDictionary() {
        String[] lines;
        InputStream in = NameConverter.class.getResourceAsStream("dictionary.txt");
        String str = IOUtils.loadStream(in, "UTF-8");
        str = str.replaceAll("\r\n", "\n");
        str = str.replaceAll("\r", "\n");
        String[] stringArray = lines = str.split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String key = line.substring(0, line.indexOf(61));
            String value = line.substring(line.indexOf(61) + 1);
            NAMES.add(new Name(key, value));
            ++n2;
        }
    }

    public static String logical2physical(String logical) {
        logical = logical.toUpperCase();
        for (Name name : NAMES) {
            logical = logical.replace(name.logical, "_" + name.physical + "_");
        }
        logical = logical.replaceAll("_+", "_");
        logical = logical.replaceAll("^_|_$", "");
        return logical;
    }

    public static String physical2logical(String physical) {
        physical = physical.toUpperCase();
        for (Name name : NAMES) {
            physical = physical.replace(name.physical, name.logical);
        }
        physical = physical.replace("_", "");
        return physical;
    }

    public static class Name {
        public String physical;
        public String logical;

        public Name(String physical, String logical) {
            this.physical = physical;
            this.logical = logical;
        }

        public String toString() {
            return String.valueOf(this.physical) + "=" + this.logical;
        }
    }
}

