/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.validator;

import java.util.HashSet;
import java.util.Set;
import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.dialect.DialectProvider;
import net.java.amateras.db.dialect.IColumnType;
import net.java.amateras.db.dialect.IDialect;
import net.java.amateras.db.validator.DiagramErrors;
import net.java.amateras.db.visual.model.AbstractDBConnectionModel;
import net.java.amateras.db.visual.model.AbstractDBEntityModel;
import net.java.amateras.db.visual.model.ColumnModel;
import net.java.amateras.db.visual.model.ForeignKeyMapping;
import net.java.amateras.db.visual.model.ForeignKeyModel;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;
import org.eclipse.jface.preference.IPreferenceStore;

public class DiagramValidator {
    private RootModel model;
    private Set<String> tableNames = new HashSet<String>();
    private Set<String> logicalNames = new HashSet<String>();

    public DiagramValidator(RootModel model) {
        this.model = model;
    }

    public DiagramErrors doValidate() {
        DiagramErrors errors = new DiagramErrors();
        for (AbstractDBEntityModel entity : this.model.getChildren()) {
            if (!(entity instanceof TableModel)) continue;
            TableModel table = (TableModel)entity;
            table.setError("");
            this.validateTable(errors, this.model, table);
        }
        String dialectName = this.model.getDialectName();
        IDialect dialect = DialectProvider.getDialect(dialectName);
        dialect.validate(errors, this.model);
        return errors;
    }

    private void validateTable(DiagramErrors errors, RootModel root, TableModel table) {
        int n;
        int n2;
        Object[] objectArray;
        IPreferenceStore store = DBPlugin.getDefault().getPreferenceStore();
        String tableName = table.getTableName();
        if (tableName == null || tableName.length() == 0) {
            errors.addError(store.getString("pref_validate_physical_table_name_required"), table, DBPlugin.getResourceString("validation.error.tableName.required"));
        } else if (this.tableNames.contains(tableName)) {
            errors.addError(store.getString("pref_validate_physical_table_name_duplicated"), table, DBPlugin.getResourceString("validation.error.tableName.duplicated"));
        } else {
            this.tableNames.add(tableName);
        }
        String logicalName = table.getLogicalName();
        if (logicalName == null || logicalName.length() == 0) {
            errors.addError(store.getString("pref_validate_on_logical_table_name_required"), table, DBPlugin.getResourceString("validation.error.logicalTableName.required"));
        } else if (this.logicalNames.contains(logicalName)) {
            errors.addError(store.getString("pref_validate_on_logical_table_name_duplicated"), table, DBPlugin.getResourceString("validation.error.logicalTableName.duplicated"));
        } else {
            this.logicalNames.add(logicalName);
        }
        ColumnModel[] columns = table.getColumns();
        if (columns.length == 0) {
            errors.addError(store.getString("pref_validate_on_columns"), table, DBPlugin.getResourceString("validation.error.noColumns"));
        } else {
            HashSet<String> columnNames = new HashSet<String>();
            HashSet<String> logicalColumnNames = new HashSet<String>();
            boolean findPk = false;
            objectArray = columns;
            n2 = columns.length;
            n = 0;
            while (n < n2) {
                String columnName;
                ColumnModel column = objectArray[n];
                if (column.isPrimaryKey()) {
                    findPk = true;
                }
                if ((columnName = column.getColumnName()) == null || columnName.length() == 0) {
                    errors.addError(store.getString("pref_validate_physical_column_name_required"), table, column, DBPlugin.getResourceString("validation.error.columnName.required"));
                } else if (columnNames.contains(columnName)) {
                    errors.addError(store.getString("pref_validate_physical_column_name_duplicatedl"), table, column, DBPlugin.getResourceString("validation.error.columnName.duplicated"));
                } else {
                    columnNames.add(columnName);
                }
                String logicalColumnName = column.getLogicalName();
                if (logicalColumnName == null || logicalColumnName.length() == 0) {
                    errors.addError(store.getString("pref_validate_physical_column_name_required"), table, column, DBPlugin.getResourceString("validation.error.logicalColumnName.required"));
                } else if (logicalColumnNames.contains(logicalColumnName)) {
                    errors.addError(store.getString("pref_validate_physical_column_name_duplicated"), table, column, DBPlugin.getResourceString("validation.error.logicalColumnName.duplicated"));
                } else {
                    logicalColumnNames.add(logicalColumnName);
                }
                ++n;
            }
            if (!findPk) {
                errors.addError(store.getString("pref_validate_primary_key"), table, DBPlugin.getResourceString("validation.error.noPrimaryKey"));
            }
        }
        for (AbstractDBConnectionModel conn : table.getModelSourceConnections()) {
            if (!(conn instanceof ForeignKeyModel)) continue;
            ForeignKeyModel fk = (ForeignKeyModel)conn;
            objectArray = fk.getMapping();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                Object mapping = objectArray[n];
                ColumnModel referer = ((ForeignKeyMapping)mapping).getRefer();
                ColumnModel target = ((ForeignKeyMapping)mapping).getTarget();
                IColumnType refererType = referer.getColumnType();
                IColumnType targetType = target.getColumnType();
                if (!refererType.getName().equals(targetType.getName())) {
                    errors.addError(store.getString("pref_validate_foreign_key_column_type"), table, referer, DBPlugin.getResourceString("validation.error.foreignKey.columnType"));
                } else if (refererType.supportSize() && !referer.getSize().equals(target.getSize())) {
                    errors.addError(store.getString("pref_validate_foreign_key_column_size"), table, referer, DBPlugin.getResourceString("validation.error.foreignKey.columnSize"));
                }
                ++n;
            }
        }
    }
}

