/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.visual.action;

import java.util.List;
import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.visual.action.DommainEditDialog;
import net.java.amateras.db.visual.model.DommainModel;
import net.java.amateras.db.visual.model.RootModel;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.Action;

public class DommainEditAction
extends Action {
    private GraphicalViewer viewer;
    private DommainModel editDommain;

    public DommainEditAction(GraphicalViewer viewer) {
        super(DBPlugin.getResourceString("action.editDommain"));
        this.viewer = viewer;
    }

    public DommainEditAction(GraphicalViewer viewer, DommainModel editDommain) {
        super(DBPlugin.getResourceString("action.editDommain"));
        this.viewer = viewer;
        this.editDommain = editDommain;
    }

    public void run() {
        RootModel root = (RootModel)this.viewer.getContents().getModel();
        DommainEditDialog dialog = new DommainEditDialog(this.viewer.getControl().getShell(), root, this.editDommain);
        if (dialog.open() == 0) {
            this.viewer.getEditDomain().getCommandStack().execute((Command)new DommainEditCommand(root, dialog.getResult(), root.getDommains()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DommainEditCommand
    extends Command {
        private RootModel rootModel;
        private List<DommainModel> newDommains;
        private List<DommainModel> oldDommains;

        public DommainEditCommand(RootModel rootModel, List<DommainModel> newDommains, List<DommainModel> oldDommains) {
            this.rootModel = rootModel;
            this.newDommains = newDommains;
            this.oldDommains = oldDommains;
        }

        public void execute() {
            this.rootModel.setDommains(this.newDommains);
        }

        public void undo() {
            this.rootModel.setDommains(this.oldDommains);
        }
    }
}

