/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.visual.action;

import java.util.ArrayList;
import java.util.List;
import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.util.UIUtils;
import net.java.amateras.db.visual.editor.VisualDBSerializer;
import net.java.amateras.db.visual.model.AbstractDBConnectionModel;
import net.java.amateras.db.visual.model.AbstractDBEntityModel;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.FolderSelectionDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ImportFromDiagramAction
extends Action {
    private GraphicalViewer viewer;

    public ImportFromDiagramAction(GraphicalViewer viewer) {
        super(DBPlugin.getResourceString("action.importFromDiagram"));
        this.viewer = viewer;
    }

    public void run() {
        IFileEditorInput input = (IFileEditorInput)UIUtils.getActiveEditor().getEditorInput();
        IFile file = input.getFile();
        RootModel root = (RootModel)this.viewer.getContents().getModel();
        ImportFromDiagramWizard wizard = new ImportFromDiagramWizard(root, file, this.viewer.getEditDomain().getCommandStack());
        WizardDialog dialog = new WizardDialog(this.viewer.getControl().getShell(), (IWizard)wizard);
        dialog.open();
    }

    private static class ImportFromDiagramWizard
    extends Wizard {
        private ImportFromDiagramWizardPage page;
        private RootModel model;
        private IFile file;
        private CommandStack stack;

        public ImportFromDiagramWizard(RootModel model, IFile file, CommandStack stack) {
            this.setNeedsProgressMonitor(true);
            this.setWindowTitle(DBPlugin.getResourceString("wizard.new.import.title"));
            this.model = model;
            this.file = file;
            this.stack = stack;
        }

        public void addPages() {
            this.page = new ImportFromDiagramWizardPage(this.file, this.model);
            this.addPage((IWizardPage)this.page);
        }

        public boolean performFinish() {
            final TableModel[] tables = this.page.getSelectedTableModel();
            final IFile file = this.page.getSelectedFile();
            this.stack.execute(new Command(){

                public void execute() {
                    TableModel[] tableModelArray = tables;
                    int n = tables.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableModel table = tableModelArray[n2];
                        TableModel oldTable = ImportFromDiagramWizard.this.model.getTable(table.getTableName());
                        this.stripConnections(tables, table.getModelSourceConnections());
                        this.stripConnections(tables, table.getModelTargetConnections());
                        if (oldTable != null) {
                            ImportFromDiagramWizard.this.model.removeChild(oldTable);
                            for (AbstractDBConnectionModel conn : oldTable.getModelTargetConnections()) {
                                conn.setTarget(table);
                                table.addTargetConnection(conn);
                            }
                            table.setConstraint(oldTable.getConstraint());
                        }
                        table.setLinkedPath(file.getFullPath().toString());
                        ImportFromDiagramWizard.this.model.addChild(table);
                        ++n2;
                    }
                }

                private void stripConnections(TableModel[] importModels, List<AbstractDBConnectionModel> conns) {
                    AbstractDBConnectionModel[] abstractDBConnectionModelArray = conns.toArray(new AbstractDBConnectionModel[conns.size()]);
                    int n = abstractDBConnectionModelArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AbstractDBConnectionModel conn = abstractDBConnectionModelArray[n2];
                        conn.getSource().removeSourceConnection(conn);
                        conn.getTarget().removeTargetConnection(conn);
                        ++n2;
                    }
                }

                public boolean canUndo() {
                    return false;
                }
            });
            return true;
        }
    }

    private static class ImportFromDiagramWizardPage
    extends WizardPage {
        private IFile self;
        private RootModel root;
        private RootModel selectedRootModel;
        private Text file;
        private org.eclipse.swt.widgets.List list;

        public ImportFromDiagramWizardPage(IFile self, RootModel root) {
            super(DBPlugin.getResourceString("wizard.importFromDiagram.title"));
            this.setTitle(DBPlugin.getResourceString("wizard.importFromDiagram.title"));
            this.setMessage(DBPlugin.getResourceString("wizard.importFromDiagram.message"));
            this.self = self;
            this.root = root;
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(3, false));
            composite.setLayoutData((Object)new GridData(1808));
            UIUtils.createLabel(composite, DBPlugin.getResourceString("wizard.importFromDiagram.erdFile"));
            this.file = new Text(composite, 2048);
            this.file.setLayoutData((Object)new GridData(768));
            this.file.setEditable(false);
            Button browse = new Button(composite, 8);
            browse.setText(DBPlugin.getResourceString("button.browse"));
            browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ImportFromDiagramWizardPage.this.selectFile();
                }
            });
            UIUtils.createLabel(composite, DBPlugin.getResourceString("wizard.new.import.tables"));
            this.list = new org.eclipse.swt.widgets.List(composite, 2562);
            this.list.setLayoutData((Object)new GridData(1808));
            this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String[] selectedTableNames;
                    String[] stringArray = selectedTableNames = ImportFromDiagramWizardPage.this.list.getSelection();
                    int n = selectedTableNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String tableName = stringArray[n2];
                        TableModel table = ImportFromDiagramWizardPage.this.root.getTable(tableName);
                        if (table != null && !table.isLinkedTable()) {
                            ImportFromDiagramWizardPage.this.setErrorMessage(DBPlugin.getResourceString("wizard.importFromDiagram.error.existTable"));
                            ImportFromDiagramWizardPage.this.setPageComplete(false);
                            return;
                        }
                        ImportFromDiagramWizardPage.this.setErrorMessage(null);
                        ImportFromDiagramWizardPage.this.setPageComplete(true);
                        ++n2;
                    }
                }
            });
            this.setControl((Control)composite);
        }

        private void selectFile() {
            try {
                IFile init = null;
                if (!this.file.getText().equals("")) {
                    init = this.getSelectedFile();
                }
                Class[] acceptedClasses = new Class[]{IFile.class};
                TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false);
                IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
                FolderSelectionDialog dialog = new FolderSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                ViewerFilter filter = new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        if (element instanceof IContainer) {
                            return true;
                        }
                        return element instanceof IFile && !element.equals(ImportFromDiagramWizardPage.this.self) && ((IFile)element).getName().endsWith(".erd");
                    }
                };
                dialog.setTitle(DBPlugin.getResourceString("wizard.generate.browse.title"));
                dialog.setMessage(DBPlugin.getResourceString("wizard.generate.browse.message"));
                dialog.addFilter(filter);
                dialog.setInput((Object)wsroot);
                dialog.setValidator((ISelectionStatusValidator)validator);
                dialog.setInitialSelection((Object)init);
                if (dialog.open() == 0) {
                    IFile selectedFile = (IFile)dialog.getFirstResult();
                    this.file.setText(selectedFile.getFullPath().toString());
                    this.selectedRootModel = VisualDBSerializer.deserialize(selectedFile.getContents());
                    this.list.removeAll();
                    for (AbstractDBEntityModel entity : this.selectedRootModel.getChildren()) {
                        if (!(entity instanceof TableModel)) continue;
                        this.list.add(((TableModel)entity).getTableName());
                    }
                }
            }
            catch (Exception ex) {
                DBPlugin.logException(ex);
            }
        }

        public IFile getSelectedFile() {
            String outputDir = this.file.getText();
            IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
            return (IFile)wsroot.findMember(outputDir);
        }

        public TableModel[] getSelectedTableModel() {
            if (this.selectedRootModel == null) {
                return new TableModel[0];
            }
            ArrayList<TableModel> result = new ArrayList<TableModel>();
            String[] stringArray = this.list.getSelection();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String tableName = stringArray[n2];
                TableModel table = this.selectedRootModel.getTable(tableName);
                table.setSchema(this.selectedRootModel.getJdbcSchema());
                result.add(this.selectedRootModel.getTable(tableName));
                ++n2;
            }
            return result.toArray(new TableModel[result.size()]);
        }
    }
}

