/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.visual.action;

import java.util.List;
import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.util.NameConverter;
import net.java.amateras.db.util.UIUtils;
import net.java.amateras.db.visual.editor.VisualDBEditor;
import net.java.amateras.db.visual.editpart.TableEditPart;
import net.java.amateras.db.visual.model.ColumnModel;
import net.java.amateras.db.visual.model.TableModel;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class Logical2PhysicalAction
extends SelectionAction {
    public Logical2PhysicalAction(VisualDBEditor editor) {
        super((IWorkbenchPart)editor);
        this.setId(Logical2PhysicalAction.class.getName());
        this.setText(DBPlugin.getResourceString("action.logical2physical"));
    }

    public void run() {
        if (!MessageDialog.openConfirm((Shell)this.getWorkbenchPart().getSite().getShell(), (String)DBPlugin.getResourceString("dialog.confirm.title"), (String)DBPlugin.getResourceString("action.logical2physical.confirm"))) {
            return;
        }
        List selection = this.getSelectedObjects();
        int i = 0;
        while (i < selection.size()) {
            EditPart editPart = (EditPart)selection.get(i);
            if (editPart instanceof TableEditPart) {
                TableModel table = (TableModel)editPart.getModel();
                ColumnModel[] columnModelArray = table.getColumns();
                int n = columnModelArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ColumnModel column = columnModelArray[n2];
                    String logical = column.getLogicalName();
                    if (logical != null && logical.length() != 0) {
                        column.setColumnName(NameConverter.logical2physical(logical));
                    }
                    ++n2;
                }
                String logical = table.getTableName();
                if (logical != null && logical.length() != 0) {
                    table.setTableName(NameConverter.logical2physical(logical));
                }
            }
            ++i;
        }
        UIUtils.getActiveEditor().doSave((IProgressMonitor)new NullProgressMonitor());
    }

    protected boolean calculateEnabled() {
        List selection = this.getSelectedObjects();
        int i = 0;
        while (i < selection.size()) {
            Object obj = selection.get(i);
            if (obj instanceof TableEditPart) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

