/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.visual.editor;

import java.util.ArrayList;
import java.util.EventObject;
import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.dialect.DialectProvider;
import net.java.amateras.db.validator.DiagramErrors;
import net.java.amateras.db.validator.DiagramValidator;
import net.java.amateras.db.visual.action.AutoLayoutAction;
import net.java.amateras.db.visual.action.ChangeDBTypeAction;
import net.java.amateras.db.visual.action.CopyAction;
import net.java.amateras.db.visual.action.CopyAsImageAction;
import net.java.amateras.db.visual.action.DeleteMarkerAction;
import net.java.amateras.db.visual.action.DommainEditAction;
import net.java.amateras.db.visual.action.GenerateAction;
import net.java.amateras.db.visual.action.ImportFromDiagramAction;
import net.java.amateras.db.visual.action.ImportFromJDBCAction;
import net.java.amateras.db.visual.action.Logical2PhysicalAction;
import net.java.amateras.db.visual.action.LowercaseAction;
import net.java.amateras.db.visual.action.PasteAction;
import net.java.amateras.db.visual.action.Physical2LogicalAction;
import net.java.amateras.db.visual.action.QuickOutlineAction;
import net.java.amateras.db.visual.action.SelectedTablesDDLAction;
import net.java.amateras.db.visual.action.ToggleModelAction;
import net.java.amateras.db.visual.action.UppercaseAction;
import net.java.amateras.db.visual.action.ValidateAction;
import net.java.amateras.db.visual.editor.VisualDBOutlinePage;
import net.java.amateras.db.visual.editor.VisualDBSerializer;
import net.java.amateras.db.visual.editpart.DBEditPartFactory;
import net.java.amateras.db.visual.editpart.IDoubleClickSupport;
import net.java.amateras.db.visual.generate.GeneratorProvider;
import net.java.amateras.db.visual.generate.IGenerator;
import net.java.amateras.db.visual.model.AnchorModel;
import net.java.amateras.db.visual.model.ForeignKeyModel;
import net.java.amateras.db.visual.model.NoteModel;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.gef.ui.actions.DeleteRetargetAction;
import org.eclipse.gef.ui.actions.PrintAction;
import org.eclipse.gef.ui.actions.RedoRetargetAction;
import org.eclipse.gef.ui.actions.UndoRetargetAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.parts.GraphicalEditorWithPalette;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualDBEditor
extends GraphicalEditorWithPalette
implements IResourceChangeListener,
IPropertyChangeListener {
    private boolean savePreviouslyNeeded = false;
    private VisualDBOutlinePage outlinePage;
    private boolean needViewerRefreshFlag = true;

    public VisualDBEditor() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
        this.getActionRegistry().registerAction((IAction)new UndoRetargetAction());
        this.getActionRegistry().registerAction((IAction)new RedoRetargetAction());
        this.getActionRegistry().registerAction((IAction)new DeleteRetargetAction());
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        DBPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected PaletteRoot getPaletteRoot() {
        PaletteRoot root = new PaletteRoot();
        PaletteGroup tools = new PaletteGroup(DBPlugin.getResourceString("palette.tools"));
        tools.add((PaletteEntry)new SelectionToolEntry());
        tools.add((PaletteEntry)new MarqueeToolEntry());
        PaletteDrawer drawer = new PaletteDrawer(DBPlugin.getResourceString("palette.db"));
        drawer.add(this.createEntityEntry(DBPlugin.getResourceString("palette.db.table"), TableModel.class, "icons/table.gif"));
        drawer.add(this.createConnectionEntry(DBPlugin.getResourceString("palette.db.reference"), ForeignKeyModel.class, "icons/reference.gif"));
        drawer.add(this.createEntityEntry(DBPlugin.getResourceString("palette.db.note"), NoteModel.class, "icons/note.gif"));
        drawer.add(this.createConnectionEntry(DBPlugin.getResourceString("palette.db.anchor"), AnchorModel.class, "icons/anchor.gif"));
        root.add((PaletteEntry)tools);
        root.add((PaletteEntry)drawer);
        return root;
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.setPartName(input.getName());
    }

    protected void initializeGraphicalViewer() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        ScalableRootEditPart rootEditPart = new ScalableRootEditPart();
        viewer.setEditPartFactory((EditPartFactory)new DBEditPartFactory());
        viewer.setRootEditPart((RootEditPart)rootEditPart);
        ZoomManager manager = rootEditPart.getZoomManager();
        double[] zoomLevels = new double[]{0.25, 0.5, 0.75, 1.0, 1.5, 2.0, 2.5, 3.0, 4.0, 5.0, 10.0, 20.0};
        manager.setZoomLevels(zoomLevels);
        ArrayList<String> zoomContributions = new ArrayList<String>();
        zoomContributions.add(ZoomManager.FIT_ALL);
        zoomContributions.add(ZoomManager.FIT_HEIGHT);
        zoomContributions.add(ZoomManager.FIT_WIDTH);
        manager.setZoomLevelContributions(zoomContributions);
        this.getActionRegistry().registerAction((IAction)new ZoomInAction(manager));
        this.getActionRegistry().registerAction((IAction)new ZoomOutAction(manager));
        PrintAction printAction = new PrintAction((IWorkbenchPart)this);
        printAction.setText(DBPlugin.getResourceString("action.print"));
        printAction.setImageDescriptor(DBPlugin.getImageDescriptor("icons/print.gif"));
        this.getActionRegistry().registerAction((IAction)printAction);
        IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
        RootModel root = null;
        try {
            root = VisualDBSerializer.deserialize(file.getContents());
        }
        catch (Exception ex) {
            DBPlugin.logException(ex);
            root = new RootModel();
            root.setDialectName(DialectProvider.getDialectNames()[0]);
        }
        viewer.setContents((Object)root);
        final DeleteAction deleteAction = new DeleteAction((IWorkbenchPart)this);
        deleteAction.setSelectionProvider((ISelectionProvider)this.getGraphicalViewer());
        this.getActionRegistry().registerAction((IAction)deleteAction);
        this.getGraphicalViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                deleteAction.update();
            }
        });
        MenuManager menuMgr = new MenuManager();
        menuMgr.add((IAction)new QuickOutlineAction());
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add(this.getActionRegistry().getAction((Object)ActionFactory.UNDO.getId()));
        menuMgr.add(this.getActionRegistry().getAction((Object)ActionFactory.REDO.getId()));
        menuMgr.add((IContributionItem)new Separator());
        PasteAction pasteAction = new PasteAction(this);
        this.getActionRegistry().registerAction((IAction)pasteAction);
        this.getSelectionActions().add(pasteAction.getId());
        menuMgr.add((IAction)pasteAction);
        CopyAction copyAction = new CopyAction(this, pasteAction);
        this.getActionRegistry().registerAction((IAction)copyAction);
        this.getSelectionActions().add(copyAction.getId());
        menuMgr.add((IAction)copyAction);
        menuMgr.add(this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add((IAction)new AutoLayoutAction(viewer));
        menuMgr.add((IAction)new DommainEditAction(viewer));
        MenuManager convertMenu = new MenuManager(DBPlugin.getResourceString("action.convert"));
        menuMgr.add((IContributionItem)convertMenu);
        UppercaseAction uppercaseAction = new UppercaseAction(this);
        convertMenu.add((IAction)uppercaseAction);
        this.getActionRegistry().registerAction((IAction)uppercaseAction);
        this.getSelectionActions().add(uppercaseAction.getId());
        LowercaseAction lowercaseAction = new LowercaseAction(this);
        convertMenu.add((IAction)lowercaseAction);
        this.getActionRegistry().registerAction((IAction)lowercaseAction);
        this.getSelectionActions().add(lowercaseAction.getId());
        Physical2LogicalAction physical2logicalAction = new Physical2LogicalAction(this);
        convertMenu.add((IAction)physical2logicalAction);
        this.getActionRegistry().registerAction((IAction)physical2logicalAction);
        this.getSelectionActions().add(physical2logicalAction.getId());
        Logical2PhysicalAction logical2physicalAction = new Logical2PhysicalAction(this);
        convertMenu.add((IAction)logical2physicalAction);
        this.getActionRegistry().registerAction((IAction)logical2physicalAction);
        this.getSelectionActions().add(logical2physicalAction.getId());
        menuMgr.add((IAction)new ToggleModelAction(viewer));
        menuMgr.add((IAction)new ChangeDBTypeAction(viewer));
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_in"));
        menuMgr.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_out"));
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add((IAction)new CopyAsImageAction(viewer));
        menuMgr.add(this.getActionRegistry().getAction((Object)ActionFactory.PRINT.getId()));
        menuMgr.add((IContributionItem)new Separator());
        MenuManager validation = new MenuManager(DBPlugin.getResourceString("action.validation"));
        validation.add((IAction)new ValidateAction(viewer));
        validation.add((IAction)new DeleteMarkerAction(viewer));
        menuMgr.add((IContributionItem)validation);
        MenuManager importMenu = new MenuManager(DBPlugin.getResourceString("action.import"));
        importMenu.add((IAction)new ImportFromJDBCAction(viewer));
        importMenu.add((IAction)new ImportFromDiagramAction(viewer));
        menuMgr.add((IContributionItem)importMenu);
        MenuManager generate = new MenuManager(DBPlugin.getResourceString("action.export"));
        IGenerator[] generaters = GeneratorProvider.getGeneraters();
        int i = 0;
        while (i < generaters.length) {
            generate.add((IAction)new GenerateAction(generaters[i], viewer, this));
            ++i;
        }
        menuMgr.add((IContributionItem)generate);
        menuMgr.add((IAction)new SelectedTablesDDLAction(viewer));
        viewer.setContextMenu(menuMgr);
        viewer.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                IStructuredSelection selection = (IStructuredSelection)VisualDBEditor.this.getGraphicalViewer().getSelection();
                Object obj = selection.getFirstElement();
                if (obj != null && obj instanceof IDoubleClickSupport) {
                    ((IDoubleClickSupport)obj).doubleClicked();
                }
            }
        });
        this.outlinePage = new VisualDBOutlinePage(viewer, (EditDomain)this.getEditDomain(), root, this.getSelectionSynchronizer());
        this.applyPreferences();
        viewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 262144 && e.keyCode == 111) {
                    new QuickOutlineAction().run();
                }
            }
        });
    }

    public void doSave(IProgressMonitor monitor) {
        RootModel model = (RootModel)this.getGraphicalViewer().getContents().getModel();
        IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
        if (DBPlugin.getDefault().getPreferenceStore().getBoolean("pref_validate_on_save")) {
            try {
                file.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
                DiagramErrors errors = new DiagramValidator(model).doValidate();
                for (DiagramErrors.DiagramError error : errors.getErrors()) {
                    error.addMarker(file);
                }
            }
            catch (CoreException ex) {
                DBPlugin.logException((Exception)((Object)ex));
            }
        }
        try {
            this.needViewerRefreshFlag = false;
            file.setContents(VisualDBSerializer.serialize(model), true, true, monitor);
        }
        catch (Exception ex) {
            DBPlugin.logException(ex);
            throw new RuntimeException(ex);
        }
        this.getCommandStack().markSaveLocation();
    }

    public void doSaveAs() {
        this.doSave((IProgressMonitor)new NullProgressMonitor());
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void commandStackChanged(EventObject event) {
        if (this.isDirty()) {
            if (!this.savePreviouslyNeeded()) {
                this.setSavePreviouslyNeeded(true);
                this.firePropertyChange(257);
            }
        } else {
            this.setSavePreviouslyNeeded(false);
            this.firePropertyChange(257);
        }
        super.commandStackChanged(event);
    }

    private void setSavePreviouslyNeeded(boolean value) {
        this.savePreviouslyNeeded = value;
    }

    private boolean savePreviouslyNeeded() {
        return this.savePreviouslyNeeded;
    }

    private PaletteEntry createConnectionEntry(String itemName, Class<?> clazz, String icon) {
        ImageDescriptor image = null;
        if (icon != null) {
            image = DBPlugin.getImageDescriptor(icon);
        }
        ConnectionCreationToolEntry entry = new ConnectionCreationToolEntry(itemName, itemName, (CreationFactory)new SimpleFactory(clazz), image, image);
        return entry;
    }

    private PaletteEntry createEntityEntry(String itemName, Class<?> clazz, String icon) {
        ImageDescriptor image = null;
        if (icon != null) {
            image = DBPlugin.getImageDescriptor(icon);
        }
        CreationToolEntry entry = new CreationToolEntry(itemName, itemName, (CreationFactory)new SimpleFactory(clazz), image, image);
        return entry;
    }

    public Object getAdapter(Class type) {
        if (type == IContentOutlinePage.class) {
            return this.outlinePage;
        }
        return super.getAdapter(type);
    }

    private void refreshGraphicalViewer() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            try {
                IFile file = ((IFileEditorInput)input).getFile();
                GraphicalViewer viewer = this.getGraphicalViewer();
                RootModel newRoot = null;
                try {
                    newRoot = VisualDBSerializer.deserialize(file.getContents());
                }
                catch (Exception ex) {
                    DBPlugin.logException(ex);
                    return;
                }
                RootModel root = (RootModel)viewer.getContents().getModel();
                root.copyFrom(newRoot);
            }
            catch (Exception ex) {
                DBPlugin.logException(ex);
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1) {
            final IEditorInput input = this.getEditorInput();
            IMarkerDelta[] deltas = event.findMarkerDeltas("org.eclipse.core.resources.problemmarker", true);
            if (deltas.length > 0) {
                return;
            }
            if (input instanceof IFileEditorInput) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        IFile file = ((IFileEditorInput)input).getFile();
                        if (!file.exists()) {
                            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            page.closeEditor((IEditorPart)VisualDBEditor.this, false);
                        } else {
                            if (!VisualDBEditor.this.getPartName().equals(file.getName())) {
                                VisualDBEditor.this.setPartName(file.getName());
                            }
                            if (VisualDBEditor.this.needViewerRefreshFlag) {
                                VisualDBEditor.this.refreshGraphicalViewer();
                            } else {
                                VisualDBEditor.this.needViewerRefreshFlag = true;
                            }
                        }
                    }
                });
            }
        }
    }

    protected void applyPreferences() {
        IPreferenceStore store = DBPlugin.getDefault().getPreferenceStore();
        this.getGraphicalViewer().setProperty("SnapToGrid.isEnabled", (Object)new Boolean(store.getBoolean("pref_show_grid")));
        this.getGraphicalViewer().setProperty("SnapToGrid.isVisible", (Object)new Boolean(store.getBoolean("pref_show_grid")));
        int gridSize = store.getInt("pref_grid_size");
        this.getGraphicalViewer().setProperty("SnapToGrid.GridSpacing", (Object)new Dimension(gridSize, gridSize));
        this.getGraphicalViewer().setProperty("SnapToGeometry.isEnabled", (Object)new Boolean(store.getBoolean("pref_snap_geometry")));
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.applyPreferences();
        net.java.amateras.db.visual.editpart.RootEditPart root = (net.java.amateras.db.visual.editpart.RootEditPart)this.getGraphicalViewer().getRootEditPart().getContents();
        root.propertyChange(new java.beans.PropertyChangeEvent((Object)this, "p_mode", null, null));
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        DBPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }
}

