/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.visual.editor;

import java.util.List;
import net.java.amateras.db.visual.editor.ModelEditor;
import net.java.amateras.db.visual.editor.VisualDBOutlinePage;
import net.java.amateras.db.visual.editpart.tree.VisualDBTreeEditPartFactory;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class VisualDBInformationControl
extends AbstractInformationControl {
    private GraphicalViewer graphicalViewer;
    private TreeViewer viewer;
    private Text search;
    private ModelEditor modelEditor;

    public VisualDBInformationControl(Shell parentShell, GraphicalViewer graphicalViewer) {
        super(parentShell, true);
        this.graphicalViewer = graphicalViewer;
        this.modelEditor = new ModelEditor(graphicalViewer, false);
        VisualDBOutlinePage.setFilterText("");
        this.create();
        int width = 300;
        int height = 300;
        Point loc = graphicalViewer.getControl().getParent().toDisplay(0, 0);
        Point size = graphicalViewer.getControl().getParent().getSize();
        int x = (size.x - width) / 2 + loc.x;
        int y = (size.y - height) / 2 + loc.y;
        this.setSize(width, height);
        this.setLocation(new Point(x, y));
        this.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                VisualDBInformationControl.this.dispose();
            }
        });
    }

    protected void createContent(Composite parent) {
        Color foreground = parent.getShell().getDisplay().getSystemColor(28);
        Color background = parent.getShell().getDisplay().getSystemColor(29);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setForeground(foreground);
        composite.setBackground(background);
        this.search = new Text(composite, 0);
        this.search.setLayoutData((Object)new GridData(768));
        this.search.setForeground(foreground);
        this.search.setBackground(background);
        new Label(composite, 258).setLayoutData((Object)new GridData(768));
        Dialog.applyDialogFont((Control)this.search);
        this.search.setLayoutData((Object)new GridData(768));
        this.search.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditPart folder;
                List tables;
                String filterText = VisualDBInformationControl.this.search.getText();
                VisualDBOutlinePage.setFilterText(filterText);
                VisualDBInformationControl.this.viewer.getRootEditPart().getContents().refresh();
                if (filterText.length() > 0 && (tables = (folder = (EditPart)VisualDBInformationControl.this.viewer.getRootEditPart().getContents().getChildren().get(0)).getChildren()).size() > 0) {
                    VisualDBInformationControl.this.viewer.select((EditPart)tables.get(0));
                }
            }
        });
        this.search.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13) {
                    VisualDBInformationControl.this.selectAndDispose();
                }
                if (e.keyCode == 0x1000001) {
                    VisualDBInformationControl.this.viewer.getControl().setFocus();
                }
                if (e.keyCode == 0x1000002) {
                    VisualDBInformationControl.this.viewer.getControl().setFocus();
                }
            }
        });
        this.viewer = new TreeViewer();
        this.viewer.createControl(composite);
        this.viewer.setEditDomain(this.graphicalViewer.getEditDomain());
        this.viewer.setEditPartFactory((EditPartFactory)new VisualDBTreeEditPartFactory());
        this.viewer.setContents(this.graphicalViewer.getContents().getModel());
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13) {
                    VisualDBInformationControl.this.selectAndDispose();
                }
            }
        });
        this.viewer.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                VisualDBInformationControl.this.selectAndDispose();
            }
        });
        this.viewer.getControl().setForeground(foreground);
        this.viewer.getControl().setBackground(background);
    }

    private void selectAndDispose() {
        List selected = this.viewer.getSelectedEditParts();
        this.dispose();
        if (!selected.isEmpty()) {
            EditPart editPart = (EditPart)selected.get(0);
            Object model = editPart.getModel();
            this.modelEditor.editModel(model);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.search.setFocus();
    }

    public boolean hasContents() {
        return true;
    }
}

