/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.visual.editpart;

import java.util.List;
import net.java.amateras.db.util.UIUtils;
import net.java.amateras.db.visual.model.ColumnModel;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnSelectDialog
extends Dialog {
    private List<ColumnModel> columns;
    private ColumnModel selectedColumn;
    private TableViewer viewer;

    protected ColumnSelectDialog(Shell parentShell, List<ColumnModel> columns) {
        super(parentShell);
        this.columns = columns;
    }

    protected Point getInitialSize() {
        return new Point(400, 300);
    }

    protected Control createDialogArea(Composite parent) {
        this.viewer = new TableViewer(parent, 65540);
        Table table = this.viewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        UIUtils.createColumn(table, "dialog.table.columnName", 150);
        UIUtils.createColumn(table, "dialog.table.columnType", 150);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                ColumnModel column = (ColumnModel)element;
                if (columnIndex == 0) {
                    return column.getColumnName();
                }
                if (columnIndex == 1) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(column.getColumnType().getName());
                    if (column.getColumnType().supportSize()) {
                        sb.append("(").append(column).append(")");
                    }
                    return sb.toString();
                }
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.viewer.setInput(this.columns);
        return this.viewer.getControl();
    }

    protected void okPressed() {
        this.selectedColumn = (ColumnModel)((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        super.okPressed();
    }

    public ColumnModel getSelectedColumn() {
        return this.selectedColumn;
    }
}

