/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.visual.editpart;

import java.util.ArrayList;
import java.util.List;
import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.visual.model.ColumnModel;
import net.java.amateras.db.visual.model.ForeignKeyMapping;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ForeignKeyEditDialog
extends Dialog {
    private ForeignKeyMapping[] mappings;
    private String foreignKeyName;
    private ColumnModel[] columns;
    private ForeignKeyMapping[] result;
    private List<Combo> combos = new ArrayList<Combo>();
    private Text keyName;
    private boolean logicalMode;

    public ForeignKeyEditDialog(Shell shell, String foreignKeyName, ForeignKeyMapping[] mappings, ColumnModel[] columns, boolean logicalMode) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.foreignKeyName = foreignKeyName;
        this.mappings = mappings;
        this.columns = columns;
        this.logicalMode = logicalMode;
    }

    protected void constrainShellSize() {
        Shell shell = this.getShell();
        shell.pack();
        shell.setSize(400, shell.getSize().y);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(DBPlugin.getResourceString("dialog.mapping.title"));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText(DBPlugin.getResourceString("dialog.mapping.name"));
        this.keyName = new Text(composite, 2048);
        this.keyName.setLayoutData((Object)new GridData(768));
        this.keyName.setText(this.foreignKeyName);
        Group group = new Group(composite, 0);
        group.setText(DBPlugin.getResourceString("dialog.mapping.mapping"));
        group.setLayout((Layout)new GridLayout(3, false));
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        int i = 0;
        while (i < this.mappings.length) {
            label = new Label((Composite)group, 2048);
            if (this.logicalMode) {
                label.setText(this.mappings[i].getTarget().getLogicalName());
            } else {
                label.setText(this.mappings[i].getTarget().getColumnName());
            }
            label.setLayoutData((Object)new GridData(768));
            label = new Label((Composite)group, 0);
            label.setText("=");
            Combo combo = new Combo((Composite)group, 8);
            combo.setLayoutData((Object)new GridData(768));
            int j = 0;
            while (j < this.columns.length) {
                if (this.logicalMode) {
                    combo.add(this.columns[j].getLogicalName());
                } else {
                    combo.add(this.columns[j].getColumnName());
                }
                ++j;
            }
            if (this.mappings[i].getRefer() != null) {
                if (this.logicalMode) {
                    combo.setText(this.mappings[i].getRefer().getLogicalName());
                } else {
                    combo.setText(this.mappings[i].getRefer().getColumnName());
                }
            }
            this.combos.add(combo);
            ++i;
        }
        if (this.mappings.length == 0) {
            label = new Label((Composite)group, 0);
            label.setText(DBPlugin.getResourceString("dialog.mapping.noColumns"));
            gd = new GridData(768);
            gd.horizontalSpan = 3;
        }
        return composite;
    }

    protected void okPressed() {
        this.result = new ForeignKeyMapping[this.combos.size()];
        int i = 0;
        while (i < this.combos.size()) {
            Combo combo = this.combos.get(i);
            this.result[i] = new ForeignKeyMapping();
            this.result[i].setTarget(this.mappings[i].getTarget());
            String columnName = combo.getText();
            int index = 0;
            int j = 0;
            while (j < this.columns.length) {
                if (this.logicalMode) {
                    if (this.columns[j].getLogicalName().equals(columnName)) {
                        index = j;
                        break;
                    }
                } else if (this.columns[j].getColumnName().equals(columnName)) {
                    index = j;
                    break;
                }
                ++j;
            }
            this.result[i].setRefer(this.columns[index]);
            ++i;
        }
        this.foreignKeyName = this.keyName.getText();
        super.okPressed();
    }

    public String getForeignKeyName() {
        return this.foreignKeyName;
    }

    public ForeignKeyMapping[] getMapping() {
        return this.result;
    }
}

