/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.visual.editpart;

import net.java.amateras.db.visual.editpart.AbstractDBConnectionEditPart;
import net.java.amateras.db.visual.editpart.ForeignKeyEditDialog;
import net.java.amateras.db.visual.editpart.ManhattanConnectionRouter;
import net.java.amateras.db.visual.model.AbstractDBConnectionModel;
import net.java.amateras.db.visual.model.ForeignKeyMapping;
import net.java.amateras.db.visual.model.ForeignKeyModel;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public class ForeignKeyEditPart
extends AbstractDBConnectionEditPart {
    private Label label;
    private ManhattanConnectionRouter router;
    private Font font;

    protected IFigure createFigure() {
        PolylineConnection connection = new PolylineConnection();
        this.router = new ManhattanConnectionRouter();
        connection.setConnectionRouter((ConnectionRouter)this.router);
        PolygonDecoration decoration = new PolygonDecoration();
        connection.setTargetDecoration((RotatableDecoration)decoration);
        this.label = new Label();
        this.label.setLabelAlignment(2);
        this.label.setOpaque(true);
        this.label.setBackgroundColor(Display.getDefault().getSystemColor(1));
        this.updateConnection(connection);
        connection.add((IFigure)this.label, (Object)new ConnectionLocator((Connection)connection, 4));
        return connection;
    }

    private void updateConnection(PolylineConnection connection) {
        RootModel root = (RootModel)this.getRoot().getContents().getModel();
        ForeignKeyModel model = (ForeignKeyModel)this.getModel();
        ForeignKeyMapping[] mapping = model.getMapping();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < mapping.length) {
            try {
                if (i != 0) {
                    sb.append("\n");
                }
                sb.append(mapping[i].getDisplayString(root.getLogicalMode()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++i;
        }
        this.label.setText(sb.toString());
        connection.setLineStyle(2);
        i = 0;
        while (i < mapping.length) {
            if (mapping[i].getRefer() != null && mapping[i].getRefer().isPrimaryKey()) {
                connection.setLineStyle(1);
                break;
            }
            ++i;
        }
        int count = 0;
        for (AbstractDBConnectionModel conn : model.getSource().getModelSourceConnections()) {
            if (conn == model) break;
            if (conn.getTarget() != model.getTarget()) continue;
            ++count;
        }
        this.router.setDuplicationCount(count);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        if (this.font != null) {
            this.font.dispose();
        }
        RootModel root = (RootModel)this.getRoot().getContents().getModel();
        FontData[] fontData = root.getFontData();
        this.font = new Font((Device)Display.getDefault(), fontData);
        this.figure.setFont(this.font);
        this.updateConnection((PolylineConnection)this.getFigure());
    }

    public void deactivate() {
        super.deactivate();
        if (this.font != null) {
            this.font.dispose();
        }
    }

    public void doubleClicked() {
        ForeignKeyModel model = (ForeignKeyModel)this.getModel();
        TableModel source = (TableModel)model.getSource();
        ForeignKeyEditDialog dialog = new ForeignKeyEditDialog(this.getViewer().getControl().getShell(), model.getForeignKeyName(), model.getMapping(), source.getColumns(), ((RootModel)this.getRoot().getContents().getModel()).getLogicalMode());
        if (dialog.open() == 0) {
            model.setForeignKeyName(dialog.getForeignKeyName());
            model.setMapping(dialog.getMapping());
        }
    }
}

