/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.visual.editpart;

import java.util.List;
import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.util.UIUtils;
import net.java.amateras.db.visual.editpart.AbstractDBEntityEditPart;
import net.java.amateras.db.visual.editpart.ColumnFigure;
import net.java.amateras.db.visual.editpart.TableEditDialog;
import net.java.amateras.db.visual.editpart.TableFigure;
import net.java.amateras.db.visual.model.AbstractDBConnectionModel;
import net.java.amateras.db.visual.model.ColumnModel;
import net.java.amateras.db.visual.model.ForeignKeyMapping;
import net.java.amateras.db.visual.model.ForeignKeyModel;
import net.java.amateras.db.visual.model.IndexModel;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public class TableEditPart
extends AbstractDBEntityEditPart
implements NodeEditPart {
    private Font font;

    protected AbstractDBEntityEditPart.CreateConnectionCommand newCreateConnectionCommand() {
        return new CreateTableConnectionCommand();
    }

    protected IFigure createFigure() {
        TableFigure figure = new TableFigure();
        this.updateFigure(figure);
        return figure;
    }

    private void updateFigure(TableFigure figure) {
        TableModel model = (TableModel)this.getModel();
        RootModel root = (RootModel)this.getParent().getModel();
        if (this.font != null) {
            this.font.dispose();
        }
        FontData[] fontData = root.getFontData();
        this.font = new Font((Device)Display.getDefault(), fontData);
        figure.setFont(this.font);
        if (root.getLogicalMode()) {
            figure.setTableName(model.getLogicalName());
        } else {
            figure.setTableName(model.getTableName());
        }
        figure.setErrorMessage(model.getError());
        figure.removeAllColumns();
        figure.setLinkedTable(model.isLinkedTable());
        figure.setBackgroundColor(DBPlugin.getDefault().getColor(model.getBackgroundColor()));
        ColumnModel[] columns = model.getColumns();
        int i = 0;
        while (i < columns.length) {
            ColumnFigure[] figures = this.createColumnFigure(root, model, columns[i]);
            figure.add((IFigure)figures[0]);
            figure.add((IFigure)figures[1]);
            figure.add((IFigure)figures[2]);
            ++i;
        }
    }

    public void deactivate() {
        super.deactivate();
        if (this.font != null) {
            this.font.dispose();
        }
    }

    private ColumnFigure[] createColumnFigure(RootModel root, TableModel table, ColumnModel model) {
        StringBuffer sb = new StringBuffer();
        if (root.getLogicalMode()) {
            sb.append(model.getColumnType().getLogicalName());
        } else {
            sb.append(model.getColumnType().getName());
        }
        if (model.getColumnType().supportSize() && model.getSize().length() > 0) {
            sb.append("(");
            sb.append(model.getSize());
            sb.append(")");
        }
        ColumnFigure label1 = new ColumnFigure();
        ColumnFigure label2 = new ColumnFigure();
        ColumnFigure label3 = new ColumnFigure();
        if (root.getLogicalMode()) {
            label1.setText(model.getLogicalName());
        } else {
            label1.setText(model.getColumnName());
        }
        label1.setUnderline(model.isPrimaryKey());
        label2.setText(sb.toString());
        label2.setUnderline(model.isPrimaryKey());
        List<AbstractDBConnectionModel> connections = table.getModelSourceConnections();
        int i = 0;
        block0: while (i < connections.size()) {
            AbstractDBConnectionModel obj = connections.get(i);
            if (obj instanceof ForeignKeyModel) {
                ForeignKeyMapping[] mappings = ((ForeignKeyModel)obj).getMapping();
                int j = 0;
                while (j < mappings.length) {
                    if (mappings[j].getRefer() != null && mappings[j].getRefer().getColumnName().equals(model.getColumnName())) {
                        label1.setText(String.valueOf(label1.getText()) + "(FK)");
                        break block0;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (model.isNotNull() && DBPlugin.getDefault().getPreferenceStore().getBoolean("pref_show_notnull")) {
            if (root.getLogicalMode()) {
                label3.setText(DBPlugin.getResourceString("label.notNull"));
            } else {
                label3.setText("NOT NULL");
            }
        }
        return new ColumnFigure[]{label1, label2, label3};
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.updateFigure((TableFigure)this.getFigure());
        this.refreshChildren();
    }

    public void doubleClicked() {
        TableModel model = (TableModel)this.getModel();
        if (model.isLinkedTable()) {
            UIUtils.openAlertDialog(DBPlugin.getResourceString("error.edit.linkedTable"));
        } else {
            RootModel root = (RootModel)this.getParent().getModel();
            TableEditPart.openTableEditDialog(this.getViewer(), model, root);
        }
    }

    public static void openTableEditDialog(EditPartViewer viewer, TableModel model, RootModel root) {
        TableEditPart.openTableEditDialog(viewer, model, root, null);
    }

    public static void openTableEditDialog(EditPartViewer viewer, TableModel model, RootModel root, ColumnModel editColumn) {
        TableEditDialog dialog = new TableEditDialog(viewer.getControl().getShell(), root, model.getTableName(), model.getLogicalName(), model.getDescription(), model.getColumns(), editColumn, model.getIndices(), false, null, model.getSql());
        if (dialog.open() == 0) {
            List<ColumnModel> columns = dialog.getResultColumns();
            List<IndexModel> indices = dialog.getResultIncices();
            viewer.getEditDomain().getCommandStack().execute((Command)new TableEditCommand(model, dialog.getTableName(), dialog.getTableLogicalName(), dialog.getTableDescription(), columns.toArray(new ColumnModel[columns.size()]), indices.toArray(new IndexModel[indices.size()]), dialog.getSql()));
        }
    }

    public static void openTableEditDialog(EditPartViewer viewer, TableModel model, RootModel root, IndexModel editIndex) {
        TableEditDialog dialog = new TableEditDialog(viewer.getControl().getShell(), root, model.getTableName(), model.getLogicalName(), model.getDescription(), model.getColumns(), null, model.getIndices(), true, editIndex, model.getSql());
        if (dialog.open() == 0) {
            List<ColumnModel> columns = dialog.getResultColumns();
            List<IndexModel> indices = dialog.getResultIncices();
            viewer.getEditDomain().getCommandStack().execute((Command)new TableEditCommand(model, dialog.getTableName(), dialog.getTableLogicalName(), dialog.getTableDescription(), columns.toArray(new ColumnModel[columns.size()]), indices.toArray(new IndexModel[indices.size()]), dialog.getSql()));
        }
    }

    protected static class CreateTableConnectionCommand
    extends AbstractDBEntityEditPart.CreateConnectionCommand {
        protected ColumnModel[] oldColumns;

        protected CreateTableConnectionCommand() {
        }

        public void execute() {
            if (this.connection instanceof ForeignKeyModel) {
                ForeignKeyMapping[] mappings;
                TableModel table = (TableModel)this.getModel();
                List<AbstractDBConnectionModel> sources = table.getModelSourceConnections();
                String fkName = String.valueOf(table.getTableName()) + "_FK_";
                int count = 1;
                int i = 0;
                while (i < sources.size()) {
                    AbstractDBConnectionModel obj = sources.get(i);
                    if (obj instanceof ForeignKeyModel && ((ForeignKeyModel)obj).getForeignKeyName().equals(String.valueOf(fkName) + count)) {
                        ++count;
                        break;
                    }
                    ++i;
                }
                fkName = String.valueOf(fkName) + count;
                ((ForeignKeyModel)this.connection).setForeignKeyName(fkName);
                ForeignKeyMapping[] foreignKeyMappingArray = mappings = ((ForeignKeyModel)this.connection).getMapping();
                int n = mappings.length;
                int n2 = 0;
                while (n2 < n) {
                    ForeignKeyMapping mapping = foreignKeyMappingArray[n2];
                    if (mapping.getRefer() == null) {
                        ColumnModel targetColumn = mapping.getTarget();
                        ColumnModel referColumn = new ColumnModel();
                        referColumn.setColumnName(targetColumn.getColumnName());
                        referColumn.setLogicalName(targetColumn.getLogicalName());
                        referColumn.setColumnType(targetColumn.getColumnType());
                        referColumn.setDommain(targetColumn.getDommain());
                        referColumn.setSize(targetColumn.getSize());
                        referColumn.setDescription(targetColumn.getDescription());
                        this.oldColumns = table.getColumns();
                        ColumnModel[] newArray = new ColumnModel[this.oldColumns.length + 1];
                        System.arraycopy(this.oldColumns, 0, newArray, 0, this.oldColumns.length);
                        newArray[this.oldColumns.length] = referColumn;
                        table.setColumns(newArray);
                    }
                    ++n2;
                }
            }
            super.execute();
        }

        public void undo() {
            if (this.oldColumns != null) {
                TableModel table = (TableModel)this.getModel();
                table.setColumns(this.oldColumns);
            }
            super.undo();
        }
    }

    private static class TableEditCommand
    extends Command {
        private TableModel model;
        private String oldTableName;
        private String newTableName;
        private String oldTableLogicalName;
        private String newTableLogicalName;
        private String oldTableDescription;
        private String newTableDescription;
        private ColumnModel[] oldColumns;
        private ColumnModel[] newColumns;
        private IndexModel[] oldIndices;
        private IndexModel[] newIndices;
        private String oldSql;
        private String newSql;

        public TableEditCommand(TableModel model, String newTableName, String newTableLogicalName, String newTableDescription, ColumnModel[] newColumns, IndexModel[] newIndices, String sql) {
            this.model = model;
            this.oldTableName = model.getTableName();
            this.newTableName = newTableName;
            this.oldTableLogicalName = model.getLogicalName();
            this.newTableLogicalName = newTableLogicalName;
            this.oldTableDescription = model.getDescription();
            this.newTableDescription = newTableDescription;
            this.oldColumns = model.getColumns();
            this.newColumns = newColumns;
            this.oldIndices = model.getIndices();
            this.newIndices = newIndices;
            this.oldSql = model.getSql();
            this.newSql = sql;
        }

        public void execute() {
            this.model.setTableName(this.newTableName);
            this.model.setLogicalName(this.newTableLogicalName);
            this.model.setDescription(this.newTableDescription);
            this.model.setColumns(this.newColumns);
            this.model.setIndices(this.newIndices);
            this.model.setSql(this.newSql);
        }

        public void undo() {
            this.model.setTableName(this.oldTableName);
            this.model.setLogicalName(this.oldTableLogicalName);
            this.model.setDescription(this.oldTableDescription);
            this.model.setColumns(this.oldColumns);
            this.model.setIndices(this.oldIndices);
            this.model.setSql(this.oldSql);
        }
    }
}

