/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.visual.generate;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.dialect.DialectProvider;
import net.java.amateras.db.util.UIUtils;
import net.java.amateras.db.visual.generate.FolderSelectWizardPage;
import net.java.amateras.db.visual.generate.IGenerator;
import net.java.amateras.db.visual.model.RootModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class DDLGenerater
implements IGenerator {
    public String getGeneratorName() {
        return "DDL";
    }

    public void execute(IFile erdFile, RootModel root, GraphicalViewer viewer) {
        WizardDialog dialog = new WizardDialog(null, (IWizard)new DDLWizard(erdFile, root));
        dialog.open();
    }

    private static boolean isSupportedEncoding(String encoding) {
        try {
            new String(new byte[0], encoding);
        }
        catch (UnsupportedEncodingException ex) {
            return false;
        }
        return true;
    }

    private class DDLWizard
    extends Wizard {
        private IFile erdFile;
        private RootModel root;
        private DDLWizardPage page;

        public DDLWizard(IFile erdFile, RootModel root) {
            this.erdFile = erdFile;
            this.root = root;
            this.setWindowTitle(DDLGenerater.this.getGeneratorName());
            IDialogSettings settings = DBPlugin.getDefault().getDialogSettings();
            IDialogSettings section = settings.getSection("DDLWizard");
            if (section == null) {
                section = settings.addNewSection("DDLWizard");
                section.put("schema", false);
                section.put("drop", false);
                section.put("alterTable", true);
                section.put("comment", true);
                section.put("encoding", System.getProperty("file.encoding"));
            }
            this.setDialogSettings(section);
        }

        public void addPages() {
            this.page = new DDLWizardPage(this.erdFile);
            this.addPage((IWizardPage)this.page);
        }

        public boolean performFinish() {
            IFile file;
            String ddl;
            block5: {
                try {
                    IPath path = this.page.getOutputFolderResource().getFullPath();
                    path = path.append(this.page.filename.getText());
                    ddl = DialectProvider.getDialect(this.root.getDialectName()).createDDL(this.root, this.page.schema.getSelection(), this.page.drop.getSelection(), this.page.alterTable.getSelection(), this.page.comment.getSelection());
                    IDialogSettings section = this.getDialogSettings();
                    section.put("schema", this.page.schema.getSelection());
                    section.put("drop", this.page.drop.getSelection());
                    section.put("alterTable", this.page.alterTable.getSelection());
                    section.put("comment", this.page.comment.getSelection());
                    section.put("encoding", this.page.encoding.getText());
                    IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
                    file = wsroot.getFile(path);
                    if (!file.exists() || MessageDialog.openConfirm(null, (String)DBPlugin.getResourceString("wizard.generate.ddl.confirm.title"), (String)DBPlugin.getDefault().createMessage("wizard.generate.ddl.confirm.message", new String[]{this.page.filename.getText()}))) break block5;
                    return false;
                }
                catch (Exception ex) {
                    DBPlugin.logException(ex);
                    return false;
                }
            }
            if (file.exists()) {
                file.setContents((InputStream)new ByteArrayInputStream(ddl.getBytes(this.page.encoding.getText())), true, true, (IProgressMonitor)new NullProgressMonitor());
                file.setCharset(this.page.encoding.getText(), null);
            } else {
                file.create((InputStream)new ByteArrayInputStream(ddl.getBytes(this.page.encoding.getText())), true, (IProgressMonitor)new NullProgressMonitor());
                file.setCharset(this.page.encoding.getText(), null);
            }
            file.getParent().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            return true;
        }
    }

    private class DDLWizardPage
    extends FolderSelectWizardPage {
        private Text filename;
        private Button comment;
        private Button drop;
        private Button alterTable;
        private Button schema;
        private Text encoding;

        public DDLWizardPage(IFile erdFile) {
            super(erdFile, DBPlugin.getResourceString("wizard.generate.ddl.title"));
            this.setDescription(DBPlugin.getResourceString("wizard.generate.ddl.description"));
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            IDialogSettings section = this.getDialogSettings();
            Composite composite = (Composite)this.getControl();
            Label label = new Label(composite, 0);
            label.setText(DBPlugin.getResourceString("wizard.generate.ddl.filename"));
            this.filename = new Text(composite, 2048);
            this.filename.setLayoutData((Object)new GridData(768));
            this.filename.setText(this.erdFile.getName().replaceFirst("\\.erd$", ".ddl"));
            this.filename.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    DDLWizardPage.this.doValidate();
                }
            });
            new Label(composite, 0);
            new Label(composite, 0).setText(DBPlugin.getResourceString("wizard.generate.ddl.encoding"));
            this.encoding = new Text(composite, 2048);
            this.encoding.setLayoutData((Object)new GridData(768));
            this.encoding.setText(section.get("encoding"));
            this.encoding.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    DDLWizardPage.this.doValidate();
                }
            });
            this.schema = new Button(composite, 32);
            this.schema.setText(DBPlugin.getResourceString("wizard.generate.ddl.schema"));
            this.schema.setLayoutData((Object)UIUtils.createGridData(2));
            this.schema.setSelection(section.getBoolean("schema"));
            this.drop = new Button(composite, 32);
            this.drop.setText(DBPlugin.getResourceString("wizard.generate.ddl.dropTable"));
            this.drop.setLayoutData((Object)UIUtils.createGridData(2));
            this.drop.setSelection(section.getBoolean("drop"));
            this.alterTable = new Button(composite, 32);
            this.alterTable.setText(DBPlugin.getResourceString("wizard.generate.ddl.alterTable"));
            this.alterTable.setLayoutData((Object)UIUtils.createGridData(2));
            this.alterTable.setSelection(section.getBoolean("alterTable"));
            this.comment = new Button(composite, 32);
            this.comment.setText(DBPlugin.getResourceString("wizard.generate.ddl.comment"));
            this.comment.setLayoutData((Object)UIUtils.createGridData(2));
            this.comment.setSelection(section.getBoolean("comment"));
        }

        protected void doValidate() {
            super.doValidate();
            if (this.filename.getText().length() == 0) {
                this.setErrorMessage(DBPlugin.getResourceString("wizard.generate.ddl.error.filename"));
                this.setPageComplete(false);
                return;
            }
            if (!DDLGenerater.isSupportedEncoding(this.encoding.getText())) {
                this.setErrorMessage(DBPlugin.getResourceString("wizard.generate.ddl.error.encoding"));
                this.setPageComplete(false);
                return;
            }
        }
    }
}

