/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.visual.generate;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.util.IOUtils;
import net.java.amateras.db.visual.generate.IGenerator;
import net.java.amateras.db.visual.model.AbstractDBConnectionModel;
import net.java.amateras.db.visual.model.ColumnModel;
import net.java.amateras.db.visual.model.ForeignKeyMapping;
import net.java.amateras.db.visual.model.ForeignKeyModel;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.eclipse.core.resources.IFile;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.seasar.fisshplate.template.FPTemplate;

public class ExcelGenerator
implements IGenerator {
    public void execute(IFile erdFile, RootModel root, GraphicalViewer viewer) {
        FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
        dialog.setFilterExtensions(new String[]{"*.xls"});
        String path = dialog.open();
        if (path == null) {
            return;
        }
        ArrayList<TableData> tables = new ArrayList<TableData>();
        for (TableModel table : root.getTables()) {
            TableData tableData = new TableData();
            tableData.setLogicalTableName(table.getLogicalName());
            tableData.setPhysicalTableName(table.getTableName());
            tableData.setDescription(table.getDescription());
            ArrayList<ColumnData> columns = new ArrayList<ColumnData>();
            ColumnModel[] columnModelArray = table.getColumns();
            int n = columnModelArray.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnModel column = columnModelArray[n2];
                ColumnData columnData = new ColumnData();
                columnData.setLogicalColumnName(column.getLogicalName());
                columnData.setPhysicalColumnName(column.getColumnName());
                columnData.setDescription(column.getDescription());
                columnData.setType(column.getColumnType().getName());
                columnData.setDefaultValue(column.getDefaultValue());
                if (column.getColumnType().supportSize()) {
                    columnData.setSize(column.getSize());
                }
                if (column.isPrimaryKey()) {
                    columnData.setPrimaryKey(DBPlugin.getResourceString("label.o"));
                }
                if (column.isNotNull()) {
                    columnData.setNullable(DBPlugin.getResourceString("label.x"));
                }
                block4: for (AbstractDBConnectionModel conn : table.getModelSourceConnections()) {
                    ForeignKeyMapping[] mappings;
                    if (!(conn instanceof ForeignKeyModel)) continue;
                    ForeignKeyModel foreignKey = (ForeignKeyModel)conn;
                    ForeignKeyMapping[] foreignKeyMappingArray = mappings = foreignKey.getMapping();
                    int n3 = mappings.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ForeignKeyMapping mapping = foreignKeyMappingArray[n4];
                        if (mapping.getRefer() == column) {
                            columnData.setForeignKey(DBPlugin.getResourceString("label.o"));
                            columnData.setReference(String.valueOf(((TableModel)foreignKey.getTarget()).getTableName()) + "." + mapping.getTarget().getColumnName());
                            break block4;
                        }
                        ++n4;
                    }
                }
                columnData.setIndex(columns.size() + 1);
                columns.add(columnData);
                ++n2;
            }
            tableData.setColumns(columns);
            tables.add(tableData);
        }
        HashMap<String, ArrayList<TableData>> data = new HashMap<String, ArrayList<TableData>>();
        data.put("tables", tables);
        InputStream in = this.getClass().getResourceAsStream("template.xls");
        FPTemplate template = new FPTemplate();
        try {
            HSSFWorkbook wb = template.process(in, data);
            FileOutputStream fos = new FileOutputStream(path);
            wb.write((OutputStream)fos);
            IOUtils.close(fos);
        }
        catch (Exception ex) {
            DBPlugin.logException(ex);
        }
    }

    public String getGeneratorName() {
        return "Excel (for Japanese)";
    }

    public static class ColumnData {
        private int index;
        private String logicalColumnName = "";
        private String physicalColumnName = "";
        private String primaryKey = "";
        private String foreignKey = "";
        private String type = "";
        private String size = "";
        private String reference = "";
        private String description = "";
        private String nullable = "";
        private String defaultValue = "";

        public String getNullable() {
            return this.nullable;
        }

        public void setNullable(String nullable) {
            this.nullable = nullable;
        }

        public String getLogicalColumnName() {
            return this.logicalColumnName;
        }

        public void setLogicalColumnName(String logicalColumnName) {
            this.logicalColumnName = logicalColumnName;
        }

        public String getPhysicalColumnName() {
            return this.physicalColumnName;
        }

        public void setPhysicalColumnName(String physicalColumnName) {
            this.physicalColumnName = physicalColumnName;
        }

        public String getPrimaryKey() {
            return this.primaryKey;
        }

        public void setPrimaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
        }

        public String getForeignKey() {
            return this.foreignKey;
        }

        public void setForeignKey(String foreignKey) {
            this.foreignKey = foreignKey;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getSize() {
            return this.size;
        }

        public void setSize(String size) {
            this.size = size;
        }

        public String getReference() {
            return this.reference;
        }

        public void setReference(String reference) {
            this.reference = reference;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TableData {
        private String logicalTableName = "";
        private String physicalTableName = "";
        private String description;
        private List<ColumnData> columns = new ArrayList<ColumnData>();

        public String getLogicalTableName() {
            return this.logicalTableName;
        }

        public void setLogicalTableName(String logicalTableName) {
            this.logicalTableName = logicalTableName;
        }

        public String getPhysicalTableName() {
            return this.physicalTableName;
        }

        public void setPhysicalTableName(String physicalTableName) {
            this.physicalTableName = physicalTableName;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public List<ColumnData> getColumns() {
            return this.columns;
        }

        public void setColumns(List<ColumnData> columns) {
            this.columns = columns;
        }
    }
}

