/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.visual.generate;

import net.java.amateras.db.DBPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.FolderSelectionDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class FolderSelectWizardPage
extends WizardPage {
    private Text txtOutputFolder;
    protected IFile erdFile;

    public FolderSelectWizardPage(IFile erdFile, String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.erdFile = erdFile;
    }

    public IResource getOutputFolderResource() {
        String outputDir = this.txtOutputFolder.getText();
        IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
        return wsroot.findMember(outputDir);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText(DBPlugin.getResourceString("wizard.generate.folder"));
        this.txtOutputFolder = new Text(composite, 2048);
        this.txtOutputFolder.setLayoutData((Object)new GridData(768));
        this.txtOutputFolder.setText(this.erdFile.getParent().getFullPath().toString());
        this.txtOutputFolder.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FolderSelectWizardPage.this.doValidate();
            }
        });
        Button button = new Button(composite, 8);
        button.setText(DBPlugin.getResourceString("button.browse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FolderSelectWizardPage.this.selectFolder();
            }
        });
        this.setControl((Control)composite);
    }

    protected void doValidate() {
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    private void selectFolder() {
        try {
            IResource init = null;
            if (!this.txtOutputFolder.getText().equals("")) {
                init = this.getOutputFolderResource();
            }
            Class[] acceptedClasses = new Class[]{IProject.class, IFolder.class};
            TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false);
            IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
            FolderSelectionDialog dialog = new FolderSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
            ViewerFilter filter = new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return element instanceof IContainer;
                }
            };
            dialog.setTitle(DBPlugin.getResourceString("wizard.generate.browse.title"));
            dialog.setMessage(DBPlugin.getResourceString("wizard.generate.browse.message"));
            dialog.addFilter(filter);
            dialog.setInput((Object)wsroot);
            dialog.setValidator((ISelectionStatusValidator)validator);
            dialog.setInitialSelection((Object)init);
            if (dialog.open() == 0) {
                this.txtOutputFolder.setText(this.getFolderName(dialog.getFirstResult()));
            }
        }
        catch (Exception ex) {
            DBPlugin.logException(ex);
        }
    }

    private String getFolderName(Object result) throws CoreException {
        if (result instanceof IContainer) {
            IContainer folder = (IContainer)result;
            return folder.getFullPath().toString();
        }
        return "";
    }
}

