/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.visual.generate;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import net.java.amateras.db.util.IOUtils;
import net.java.amateras.db.visual.generate.IGenerator;
import net.java.amateras.db.visual.generate.VelocityUtils;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.NullLogChute;
import org.eclipse.core.resources.IFile;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;

public class HTMLGenerator
implements IGenerator {
    private static ResourceBundle bundle = ResourceBundle.getBundle(HTMLGenerator.class.getName());
    private static Map<String, String> messages = new HashMap<String, String>();

    static {
        Enumeration<String> e = bundle.getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            messages.put(key, bundle.getString(key));
        }
        Velocity.addProperty((String)"runtime.log.logsystem.class", (Object)NullLogChute.class.getName());
    }

    private void processTemplate(String templateName, File output, VelocityContext context) throws Exception {
        StringWriter writer = new StringWriter();
        InputStreamReader reader = new InputStreamReader(HTMLGenerator.class.getResourceAsStream(templateName), "UTF-8");
        Velocity.evaluate((Context)context, (Writer)writer, null, (Reader)reader);
        FileOutputStream out = new FileOutputStream(output);
        out.write(writer.getBuffer().toString().getBytes("UTF-8"));
        IOUtils.close(out);
        IOUtils.close(reader);
        IOUtils.close(writer);
    }

    public void execute(IFile erdFile, RootModel root, GraphicalViewer viewer) {
        try {
            DirectoryDialog dialog = new DirectoryDialog(Display.getCurrent().getActiveShell(), 8192);
            String rootDir = dialog.open();
            if (rootDir != null) {
                this.generate(rootDir, root);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void generate(String rootDir, RootModel root) throws Exception {
        IOUtils.copyStream(HTMLGenerator.class.getResourceAsStream("stylesheet.css"), new FileOutputStream(new File(rootDir, "stylesheet.css")));
        Velocity.init();
        VelocityContext context = new VelocityContext();
        context.put("model", (Object)root);
        context.put("util", (Object)new VelocityUtils());
        context.put("msg", messages);
        this.processTemplate("index.html", new File(rootDir, "index.html"), context);
        this.processTemplate("list.html", new File(rootDir, "list.html"), context);
        this.processTemplate("summary.html", new File(rootDir, "summary.html"), context);
        File imageDir = new File(rootDir, "images");
        imageDir.mkdir();
        IOUtils.copyStream(HTMLGenerator.class.getResourceAsStream("primarykey.gif"), new FileOutputStream(new File(imageDir, "primarykey.gif")));
        File tableDir = new File(rootDir, "tables");
        tableDir.mkdir();
        for (TableModel table : root.getTables()) {
            context.put("table", (Object)table);
            this.processTemplate("table.html", new File(tableDir, String.valueOf(table.getTableName()) + ".html"), context);
        }
    }

    public String getGeneratorName() {
        return "HTML";
    }
}

