/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.visual.model;

import java.util.ArrayList;
import java.util.List;
import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.util.FontPropertyDescriptor;
import net.java.amateras.db.visual.model.AbstractDBEntityModel;
import net.java.amateras.db.visual.model.AbstractDBModel;
import net.java.amateras.db.visual.model.ColumnModel;
import net.java.amateras.db.visual.model.DommainModel;
import net.java.amateras.db.visual.model.TableModel;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootModel
extends AbstractDBModel
implements IPropertySource {
    private List<AbstractDBEntityModel> children = new ArrayList<AbstractDBEntityModel>();
    private List<DommainModel> dommains = new ArrayList<DommainModel>();
    private String dialectName = "";
    private boolean logicalMode = false;
    private String jarFile = "";
    private String jdbcDriver = "";
    private String jdbcUrl = "";
    private String jdbcUser = "";
    private String jdbcPassword = "";
    private String jdbcSchema = "";
    private String jdbcCatalog = "";
    private boolean includeView = false;
    private String fontData;
    public static final String P_MODE = "p_mode";
    public static final String P_JDBC_INFO = "p_jdbc_info";
    public static final String P_CHILDREN = "p_children";
    public static final String P_DOMMAINS = "p_dommains";
    public static final String P_FONT = "p_font";

    public void copyFrom(RootModel model) {
        this.setDialectName(model.getDialectName());
        this.setLogicalMode(model.getLogicalMode());
        this.setJarFile(model.getJarFile());
        this.setJdbcDriver(model.getJdbcDriver());
        this.setJdbcUrl(model.getJdbcUrl());
        this.setJdbcUser(model.getJdbcUser());
        this.setJdbcPassword(model.getJdbcPassword());
        this.setJdbcSchema(model.getJdbcSchema());
        this.setJdbcCatalog(model.getJdbcCatalog());
        this.setIncludeView(model.isIncludeView());
        this.children.clear();
        this.children.addAll(model.getChildren());
        this.dommains.clear();
        this.dommains.addAll(model.getDommains());
        this.firePropertyChange(P_CHILDREN, null, null);
    }

    public FontData[] getFontData() {
        if (this.fontData == null) {
            this.fontData = "";
        }
        return PreferenceConverter.basicGetFontData((String)this.fontData);
    }

    public void setFontData(FontData[] fontData) {
        this.fontData = PreferenceConverter.getStoredRepresentation((FontData[])fontData);
        this.firePropertyChange(P_FONT, null, fontData);
    }

    public String getJarFile() {
        return this.jarFile;
    }

    public void setJarFile(String jarFile) {
        this.jarFile = jarFile;
        this.firePropertyChange(P_JDBC_INFO, null, jarFile);
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public void setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
        this.firePropertyChange(P_JDBC_INFO, null, jdbcDriver);
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
        this.firePropertyChange(P_JDBC_INFO, null, jdbcUrl);
    }

    public String getJdbcUser() {
        return this.jdbcUser;
    }

    public void setJdbcUser(String jdbcUser) {
        this.jdbcUser = jdbcUser;
        this.firePropertyChange(P_JDBC_INFO, null, jdbcUser);
    }

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public void setJdbcPassword(String jdbcPassword) {
        this.jdbcPassword = jdbcPassword;
        this.firePropertyChange(P_JDBC_INFO, null, jdbcPassword);
    }

    public String getJdbcSchema() {
        return this.jdbcSchema;
    }

    public void setJdbcSchema(String jdbcSchema) {
        this.jdbcSchema = jdbcSchema;
        this.firePropertyChange(P_JDBC_INFO, null, jdbcSchema);
    }

    public String getJdbcCatalog() {
        return this.jdbcCatalog;
    }

    public void setJdbcCatalog(String jdbcCatalog) {
        this.jdbcCatalog = jdbcCatalog;
        this.firePropertyChange(P_JDBC_INFO, null, jdbcCatalog);
    }

    public boolean isIncludeView() {
        return this.includeView;
    }

    public void setIncludeView(boolean includeView) {
        this.includeView = includeView;
        this.firePropertyChange(P_JDBC_INFO, null, new Boolean(this.jdbcCatalog));
    }

    public void setLogicalMode(boolean logicalMode) {
        this.logicalMode = logicalMode;
        this.firePropertyChange(P_MODE, null, new Boolean(logicalMode));
    }

    public boolean getLogicalMode() {
        return this.logicalMode;
    }

    public void addChild(AbstractDBEntityModel model) {
        this.children.add(model);
        this.firePropertyChange(P_CHILDREN, null, model);
    }

    public void removeChild(AbstractDBEntityModel model) {
        this.children.remove(model);
        this.firePropertyChange(P_CHILDREN, model, null);
    }

    public List<AbstractDBEntityModel> getChildren() {
        return this.children;
    }

    public List<TableModel> getTables() {
        ArrayList<TableModel> result = new ArrayList<TableModel>();
        for (AbstractDBEntityModel model : this.getChildren()) {
            if (!(model instanceof TableModel)) continue;
            result.add((TableModel)model);
        }
        return result;
    }

    public TableModel getTable(String tableName) {
        int i = 0;
        while (i < this.children.size()) {
            TableModel table = (TableModel)this.children.get(i);
            if (table.getTableName().equals(tableName)) {
                return table;
            }
            ++i;
        }
        return null;
    }

    public List<DommainModel> getDommains() {
        if (this.dommains == null) {
            this.dommains = new ArrayList<DommainModel>();
        }
        return this.dommains;
    }

    public void setDommains(List<DommainModel> dommains) {
        this.dommains = dommains;
        for (AbstractDBEntityModel entity : this.getChildren()) {
            if (!(entity instanceof TableModel)) continue;
            TableModel table = (TableModel)entity;
            ColumnModel[] columnModelArray = table.getColumns();
            int n = columnModelArray.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnModel column = columnModelArray[n2];
                if (column.getDommain() != null) {
                    for (DommainModel dommain : dommains) {
                        if (!dommain.getId().equals(column.getDommain().getId())) continue;
                        column.setDommain(dommain);
                        break;
                    }
                }
                ++n2;
            }
            table.firePropertyChange("p_columns", null, null);
        }
        this.firePropertyChange(P_DOMMAINS, null, dommains);
    }

    public String getDialectName() {
        return this.dialectName;
    }

    public void setDialectName(String dialectName) {
        this.dialectName = dialectName;
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)P_JDBC_INFO, DBPlugin.getResourceString("property.schema")), new FontPropertyDescriptor(P_FONT, DBPlugin.getResourceString("property.font"))};
    }

    public Object getPropertyValue(Object id) {
        if (id == P_JDBC_INFO) {
            return this.getJdbcSchema();
        }
        if (id == P_FONT) {
            return new FontPropertyDescriptor.FontDataWrapper(this.getFontData());
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return id == P_JDBC_INFO || id == P_FONT;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        if (id == P_JDBC_INFO) {
            this.setJdbcSchema((String)value);
        } else if (id == P_FONT) {
            this.setFontData(((FontPropertyDescriptor.FontDataWrapper)value).getFontData());
        }
    }
}

