/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.wizard;

import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.dialect.DialectProvider;
import net.java.amateras.db.dialect.IDialect;
import net.java.amateras.db.dialect.ISchemaLoader;
import net.java.amateras.db.util.DatabaseInfo;
import net.java.amateras.db.util.JarClassLoader;
import net.java.amateras.db.util.UIUtils;
import net.java.amateras.db.visual.model.RootModel;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.FolderSelectionDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class NewDiagramWizardPage2
extends WizardPage {
    private JarClassLoader classLoader;
    private DatabaseInfo dbinfo;
    private Button view;
    private Text jarFile;
    private Combo driver;
    private org.eclipse.swt.widgets.List list;
    private Text catalog;
    private Text schema;
    private Text password;
    private Text user;
    private Text databaseURI;
    private URL[] classpathes = new URL[0];
    private ResourceBundle url = ResourceBundle.getBundle("net.java.amateras.db.wizard.databaseURI");
    private Text filter;
    private Button autoConvert;
    private ArrayList<String> tableNames = new ArrayList();
    private RootModel model;

    public NewDiagramWizardPage2() {
        this(null);
    }

    public NewDiagramWizardPage2(RootModel model) {
        super(DBPlugin.getResourceString("wizard.new.import.title"));
        this.setTitle(DBPlugin.getResourceString("wizard.new.import.title"));
        this.setMessage(DBPlugin.getResourceString("wizard.new.import.message"));
        this.model = model;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(4, false));
        container.setLayoutData((Object)new GridData(1808));
        UIUtils.createLabel(container, DBPlugin.getResourceString("wizard.new.import.jarFile"));
        this.jarFile = new Text(container, 2052);
        this.jarFile.setEditable(false);
        this.jarFile.setLayoutData((Object)new GridData(768));
        Button button = new Button(container, 8);
        button.setText(DBPlugin.getResourceString("button.browseFileSystem"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewDiagramWizardPage2.this.handleFileSystemBrowse();
            }
        });
        Button button2 = new Button(container, 8);
        button2.setText(DBPlugin.getResourceString("button.browseWorkspace"));
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewDiagramWizardPage2.this.handleWorkspaceBrowse();
            }
        });
        UIUtils.createLabel(container, DBPlugin.getResourceString("wizard.new.import.driver"));
        this.driver = new Combo(container, 8);
        this.driver.setLayoutData((Object)UIUtils.createGridData(3));
        this.driver.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (Collections.list(NewDiagramWizardPage2.this.url.getKeys()).contains(NewDiagramWizardPage2.this.driver.getText())) {
                    String template = NewDiagramWizardPage2.this.url.getString(NewDiagramWizardPage2.this.driver.getText());
                    NewDiagramWizardPage2.this.databaseURI.setText(template);
                }
            }
        });
        this.driver.add("sun.jdbc.odbc.JdbcOdbc");
        this.driver.select(0);
        UIUtils.createLabel(container, DBPlugin.getResourceString("wizard.new.import.uri"));
        this.databaseURI = new Text(container, 2052);
        this.databaseURI.setLayoutData((Object)UIUtils.createGridData(3));
        UIUtils.createLabel(container, DBPlugin.getResourceString("wizard.new.import.user"));
        this.user = new Text(container, 2052);
        this.user.setLayoutData((Object)UIUtils.createGridData(3));
        UIUtils.createLabel(container, DBPlugin.getResourceString("wizard.new.import.pass"));
        this.password = new Text(container, 0x400800);
        this.password.setLayoutData((Object)UIUtils.createGridData(3));
        UIUtils.createLabel(container, DBPlugin.getResourceString("wizard.new.import.schema"));
        this.schema = new Text(container, 2052);
        this.schema.setLayoutData((Object)UIUtils.createGridData(3));
        UIUtils.createLabel(container, DBPlugin.getResourceString("wizard.new.import.catalog"));
        this.catalog = new Text(container, 2052);
        this.catalog.setLayoutData((Object)UIUtils.createGridData(3));
        UIUtils.createLabel(container, DBPlugin.getResourceString("wizard.new.import.view"));
        this.view = new Button(container, 32);
        this.view.setLayoutData((Object)UIUtils.createGridData(3));
        new Label(container, 0);
        Button load = new Button(container, 8);
        load.setText(DBPlugin.getResourceString("wizard.new.import.loadTables"));
        load.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    NewDiagramWizardPage2.this.loadTables();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    MessageBox msg = new MessageBox(NewDiagramWizardPage2.this.getShell());
                    msg.setMessage(ex.getMessage());
                    msg.open();
                }
            }
        });
        new Label(container, 0);
        new Label(container, 0);
        UIUtils.createLabel(container, DBPlugin.getResourceString("wizard.new.import.filter"));
        this.filter = new Text(container, 2048);
        this.filter.setLayoutData((Object)UIUtils.createGridData(3));
        this.filter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String filterText = NewDiagramWizardPage2.this.filter.getText();
                NewDiagramWizardPage2.this.list.removeAll();
                for (String tableName : NewDiagramWizardPage2.this.tableNames) {
                    if (!tableName.startsWith(filterText)) continue;
                    NewDiagramWizardPage2.this.list.add(tableName);
                }
            }
        });
        UIUtils.createLabel(container, DBPlugin.getResourceString("wizard.new.import.tables"));
        this.list = new org.eclipse.swt.widgets.List(container, 2562);
        this.list.setLayoutData((Object)UIUtils.createGridData(3));
        this.autoConvert = new Button(container, 32);
        this.autoConvert.setText(DBPlugin.getResourceString("wizard.new.import.autoConvert"));
        this.autoConvert.setLayoutData((Object)UIUtils.createGridData(4));
        if (this.model != null) {
            this.jarFile.setText(this.model.getJarFile());
            this.loadJdbcDriver();
            this.driver.setText(this.model.getJdbcDriver());
            this.databaseURI.setText(this.model.getJdbcUrl());
            this.user.setText(this.model.getJdbcUser());
            this.password.setText(this.model.getJdbcPassword());
            this.catalog.setText(this.model.getJdbcCatalog());
            this.schema.setText(this.model.getJdbcSchema());
            this.view.setSelection(this.model.isIncludeView());
        }
        this.setControl((Control)container);
    }

    private void loadTables() throws Exception {
        if (this.classLoader != null) {
            Class<?> driverClass = this.classLoader.loadClass(this.driver.getText());
            this.dbinfo = new DatabaseInfo(driverClass);
            this.dbinfo.setURI(this.databaseURI.getText());
            this.dbinfo.setUser(this.user.getText());
            this.dbinfo.setPassword(this.password.getText());
            this.dbinfo.setCatalog(this.catalog.getText());
            this.dbinfo.setSchema(this.schema.getText());
            this.dbinfo.setEnableView(this.view.getSelection());
            this.dbinfo.setAutoConvert(this.autoConvert.getSelection());
            this.list.removeAll();
            this.tableNames.clear();
            this.filter.setText("");
            for (String tableName : this.dbinfo.loadTables()) {
                this.list.add(tableName);
                this.tableNames.add(tableName);
            }
        }
    }

    private void loadJdbcDriver() {
        try {
            URL jarURL = null;
            String jarFilePath = this.jarFile.getText();
            if (jarFilePath.startsWith("workspace:")) {
                IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
                jarFilePath = jarFilePath.replaceFirst("^workspace:", "");
                IFile file = wsroot.getFile((IPath)new Path(jarFilePath));
                jarFilePath = file.getLocation().makeAbsolute().toString();
                jarURL = new URL("file:///" + jarFilePath);
            } else {
                jarURL = new URL("file:///" + jarFilePath);
            }
            URL[] clspath = new URL[this.classpathes.length + 1];
            clspath[0] = jarURL;
            int i = 0;
            while (i < this.classpathes.length) {
                clspath[i + 1] = this.classpathes[i];
                ++i;
            }
            this.classLoader = new JarClassLoader(clspath);
            List<Class<?>> list = this.classLoader.getJDBCDriverClass(jarFilePath);
            this.driver.removeAll();
            for (Class<?> item : list) {
                if (Arrays.binarySearch(this.driver.getItems(), item.getName()) >= 0) continue;
                this.driver.add(item.getName());
            }
            this.driver.add("sun.jdbc.odbc.JdbcOdbc");
            this.driver.select(0);
        }
        catch (Exception e1) {
            DBPlugin.logException(e1);
        }
    }

    private void handleFileSystemBrowse() {
        FileDialog dialog = new FileDialog(this.getShell());
        if (dialog.open() == null) {
            return;
        }
        this.jarFile.setText(String.valueOf(dialog.getFilterPath()) + System.getProperty("file.separator") + dialog.getFileName());
        this.loadJdbcDriver();
    }

    private void handleWorkspaceBrowse() {
        try {
            IFile selectedResource = null;
            if (this.jarFile.getText().startsWith("workspace:")) {
                String jarFilePath = this.jarFile.getText().replaceFirst("^workspace:", "");
                IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
                IFile file = wsroot.getFile((IPath)new Path(jarFilePath));
                if (file != null && file.exists()) {
                    selectedResource = file;
                }
            }
            Class[] acceptedClasses = new Class[]{IFile.class};
            TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false);
            IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
            FolderSelectionDialog dialog = new FolderSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
            ViewerFilter filter = new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (element instanceof IContainer) {
                        return true;
                    }
                    return element instanceof IFile && ((IFile)element).getName().endsWith(".jar");
                }
            };
            dialog.setTitle(DBPlugin.getResourceString("wizard.generate.browse.title"));
            dialog.setMessage(DBPlugin.getResourceString("wizard.generate.browse.message"));
            dialog.addFilter(filter);
            dialog.setInput((Object)wsroot);
            dialog.setValidator((ISelectionStatusValidator)validator);
            dialog.setInitialSelection((Object)selectedResource);
            if (dialog.open() == 0) {
                IFile selectedFile = (IFile)dialog.getFirstResult();
                this.jarFile.setText("workspace:" + selectedFile.getFullPath().toString());
                this.loadJdbcDriver();
            }
        }
        catch (Exception ex) {
            DBPlugin.logException(ex);
        }
    }

    public void importTables(RootModel root) throws SQLException {
        root.setJarFile(this.jarFile.getText());
        root.setJdbcDriver(this.driver.getText());
        root.setJdbcUrl(this.databaseURI.getText());
        root.setJdbcUser(this.user.getText());
        root.setJdbcPassword(this.password.getText());
        root.setJdbcCatalog(this.catalog.getText());
        root.setJdbcSchema(this.schema.getText());
        root.setIncludeView(this.view.getSelection());
        if (this.list.getSelection().length == 0) {
            return;
        }
        IDialect dialect = DialectProvider.getDialect(root.getDialectName());
        ISchemaLoader loader = dialect.getSchemaLoader();
        Connection conn = null;
        try {
            try {
                conn = this.dbinfo.connect();
                loader.loadSchema(root, DialectProvider.getDialect(root.getDialectName()), conn, this.list.getSelection(), this.dbinfo.getCatalog(), this.dbinfo.getSchema(), this.dbinfo.isAutoConvert());
            }
            catch (Exception ex) {
                DBPlugin.logException(ex);
                if (conn != null) {
                    conn.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }
}

