/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sf.amateras.mirage.EntityCreationFailedException;
import jp.sf.amateras.mirage.ResultEntityCreator;
import jp.sf.amateras.mirage.annotation.Column;
import jp.sf.amateras.mirage.bean.BeanDesc;
import jp.sf.amateras.mirage.bean.PropertyDesc;
import jp.sf.amateras.mirage.dialect.Dialect;
import jp.sf.amateras.mirage.naming.NameConverter;
import jp.sf.amateras.mirage.type.ValueType;
import jp.sf.amateras.mirage.util.MirageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResultEntityCreator
implements ResultEntityCreator {
    private static final Logger logger = Logger.getLogger(DefaultResultEntityCreator.class.getName());

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T createEntity(Class<T> clazz, ResultSet rs, ResultSetMetaData meta, int columnCount, BeanDesc beanDesc, Dialect dialect, List<ValueType<?>> valueTypes, NameConverter nameConverter) {
        try {
            void var10_21;
            ValueType<T> valueType;
            if (dialect.getValueType() != null && (valueType = dialect.getValueType()).isSupport(clazz)) {
                return (T)valueType.get(clazz, rs, 1);
            }
            for (ValueType<T> valueType2 : valueTypes) {
                if (!valueType2.isSupport(clazz)) continue;
                return (T)valueType2.get(clazz, rs, 1);
            }
            HashMap entity = null;
            if (clazz == Map.class) {
                entity = new HashMap();
            } else {
                Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                entity = constructor.newInstance(new Object[0]);
            }
            boolean bl = false;
            while (var10_21 < columnCount) {
                String columnName = meta.getColumnName((int)(var10_21 + true));
                PropertyDesc pd = null;
                for (int j = 0; j < beanDesc.getPropertyDescSize(); ++j) {
                    PropertyDesc property = beanDesc.getPropertyDesc(j);
                    Column column = property.getAnnotation(Column.class);
                    if (column == null || !columnName.equals(column.name())) continue;
                    pd = property;
                    break;
                }
                if (pd == null) {
                    String propertyName = nameConverter.columnToProperty(columnName);
                    pd = beanDesc.getPropertyDesc(propertyName);
                }
                if (pd != null) {
                    Class<?> propertyType = pd.getPropertyType();
                    ValueType<?> valueType3 = MirageUtil.getValueType(propertyType, dialect, valueTypes);
                    if (valueType3 != null) {
                        pd.setValue(entity, valueType3.get(propertyType, rs, columnName));
                    } else if (logger.isLoggable(Level.FINE)) {
                        logger.fine(String.format("column [%s] is ignored because property [%s]'s type is not supported: %s", columnName, pd.getPropertyName(), propertyType.getName()));
                    }
                } else if (logger.isLoggable(Level.FINER)) {
                    logger.finer(String.format("column [%s] is ignored because property is not found in the bean", columnName));
                }
                ++var10_21;
            }
            return (T)entity;
        }
        catch (SQLException e) {
            throw new EntityCreationFailedException(e);
        }
        catch (SecurityException e) {
            throw new EntityCreationFailedException(e);
        }
        catch (NoSuchMethodException e) {
            throw new EntityCreationFailedException(e);
        }
        catch (IllegalArgumentException e) {
            throw new EntityCreationFailedException(e);
        }
        catch (InstantiationException e) {
            throw new EntityCreationFailedException(e);
        }
        catch (IllegalAccessException e) {
            throw new EntityCreationFailedException(e);
        }
        catch (InvocationTargetException e) {
            throw new EntityCreationFailedException(e);
        }
    }
}

