/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import jp.sf.amateras.mirage.type.AbstractValueType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerPrimitiveValueType
extends AbstractValueType<Integer> {
    public IntegerPrimitiveValueType() {
        super(Integer.TYPE);
    }

    @Override
    public Integer get(Class<? extends Integer> type, ResultSet rs, int columnIndex) throws SQLException {
        return rs.getInt(columnIndex);
    }

    @Override
    public Integer get(Class<? extends Integer> type, ResultSet rs, String columnName) throws SQLException {
        return rs.getInt(columnName);
    }

    @Override
    public void set(Class<? extends Integer> type, PreparedStatement stmt, Integer value, int index) throws SQLException {
        if (value == null) {
            this.setNull(type, stmt, index);
        } else {
            stmt.setInt(index, value);
        }
    }

    @Override
    public Integer get(Class<? extends Integer> type, CallableStatement cs, int index) throws SQLException {
        Integer value = cs.getInt(index);
        if (value != null && cs.wasNull()) {
            value = null;
        }
        return value;
    }

    @Override
    public Integer get(Class<? extends Integer> type, CallableStatement cs, String parameterName) throws SQLException {
        Integer value = cs.getInt(parameterName);
        if (value != null && cs.wasNull()) {
            value = null;
        }
        return value;
    }
}

