/*
 * Decompiled with CFR 0.152.
 */
package org.amritaj.html.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.amritaj.AttrArray;
import org.amritaj.config.AmritaJConfig;
import org.amritaj.expander.Expander;
import org.amritaj.expander.ExpanderUtil;
import org.amritaj.expander.impl.ArrayExpander;
import org.amritaj.expander.impl.AttrArrayExpander;
import org.amritaj.expander.impl.CollectionExpander;
import org.amritaj.expander.impl.HtmlNodeExpander;
import org.amritaj.expander.impl.NestExpander;
import org.amritaj.expander.impl.PrimitiveExpander;
import org.amritaj.html.HtmlNode;
import org.amritaj.html.Node;
import org.amritaj.html.util.NodeUtil;
import org.amritaj.script.AmritaScript;
import org.amritaj.type.AmritaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlNodeImpl
implements HtmlNode {
    private Node rootNode = null;
    private Node parentNode = null;
    private String startQName = null;
    private String endQName = null;
    private ArrayList<Node> childNode = new ArrayList();
    private Map<String, String> attributes = new HashMap<String, String>();
    private ArrayList<AmritaType> amritaTypeList = new ArrayList();
    private ArrayList<AmritaScript> amritaScriptList = new ArrayList();
    private Object expandData = null;

    public HtmlNodeImpl(Node node, Node node2) {
        this.rootNode = node;
        this.parentNode = node2;
    }

    @Override
    public void replaceNode(HtmlNode htmlNode) {
        HtmlNodeImpl htmlNodeImpl = (HtmlNodeImpl)htmlNode;
        this.parentNode = htmlNodeImpl.parentNode;
        this.startQName = htmlNodeImpl.startQName;
        this.endQName = htmlNodeImpl.endQName;
        this.childNode = htmlNodeImpl.childNode;
        this.attributes = htmlNodeImpl.attributes;
        this.amritaTypeList = htmlNodeImpl.amritaTypeList;
    }

    @Override
    public void replaceChild(ArrayList<Node> arrayList) {
        this.childNode = arrayList;
    }

    @Override
    public Expander detectExpander(Object object) {
        if (ExpanderUtil.isPrimitiveExpand(object)) {
            return new PrimitiveExpander(this, object);
        }
        if (ExpanderUtil.isArrayExpand(object)) {
            return new ArrayExpander(this, (Object[])object);
        }
        if (ExpanderUtil.isCollectionExpand(object)) {
            return new CollectionExpander(this, (Collection)object);
        }
        if (ExpanderUtil.isAttrArray(object)) {
            return new AttrArrayExpander(this, (AttrArray)object);
        }
        return new NestExpander(this, object);
    }

    @Override
    public void addAmritaType(AmritaType amritaType) {
        this.amritaTypeList.add(amritaType);
    }

    @Override
    public void addAmritaScript(AmritaScript amritaScript) {
        this.amritaScriptList.add(amritaScript);
    }

    @Override
    public boolean canReplace() {
        for (AmritaType amritaType : this.amritaTypeList) {
            if (amritaType.canReplace()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setStartQName(String string) {
        this.startQName = string;
    }

    @Override
    public String getStartQName() {
        return this.startQName;
    }

    @Override
    public void setEndQName(String string) {
        this.endQName = string;
    }

    @Override
    public String getEndQName() {
        return this.endQName;
    }

    @Override
    public void addChild(Node node) {
        this.childNode.add(node);
    }

    @Override
    public boolean hasChild() {
        return !this.childNode.isEmpty();
    }

    @Override
    public ArrayList<Node> getChild() {
        return this.childNode;
    }

    @Override
    public Node getParent() {
        return this.parentNode;
    }

    @Override
    public Node getRoot() {
        return this.rootNode;
    }

    @Override
    public Object getExpandData() {
        return this.expandData;
    }

    @Override
    public void addAttribute(String string, String string2) {
        this.attributes.put(string, string2);
    }

    @Override
    public Map<String, String> getAttributeMap() {
        return this.attributes;
    }

    @Override
    public boolean hasAmritaHandler() {
        AmritaJConfig amritaJConfig = new AmritaJConfig();
        return this.attributes.containsKey(amritaJConfig.getHandleString()) || this.amritaScriptList.size() > 0;
    }

    @Override
    public String getAmritaHandlerValue() {
        AmritaJConfig amritaJConfig = new AmritaJConfig();
        return this.attributes.get(amritaJConfig.getHandleString());
    }

    @Override
    public String attributeString(Collection<String> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        AmritaJConfig amritaJConfig = new AmritaJConfig();
        if (!amritaJConfig.isKeepid()) {
            collection.add(amritaJConfig.getHandleString());
        }
        Set<String> set = this.attributes.keySet();
        for (String object : set) {
            if (collection.contains(object)) continue;
            String string = this.attributes.get(object);
            stringBuilder.append(" ");
            stringBuilder.append(object);
            stringBuilder.append("=");
            stringBuilder.append("\"");
            stringBuilder.append(string);
            stringBuilder.append("\"");
        }
        for (AmritaType amritaType : this.amritaTypeList) {
            stringBuilder.append(" ");
            stringBuilder.append(((Object)amritaType).toString());
        }
        return stringBuilder.toString();
    }

    @Override
    public String expand(Object object) {
        Object object2;
        this.expandData = object;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        if (this.hasAmritaHandler() && NodeUtil.defineKeyOrGetter(object, (String)(object2 = this.getAmritaHandlerValue()))) {
            Object object3 = NodeUtil.selectExpandData(object, (String)object2);
            object3 = this.processAmritaType(object3);
            this.processAmriteScript(this.getRoot().getExpandData(), (String)object2, object3);
            Expander expander = this.detectExpander(object3);
            stringBuilder.append(expander.expand());
            bl = true;
        }
        if (!bl) {
            this.processAmriteScript(this.getRoot().getExpandData(), null, null);
            object2 = new HtmlNodeExpander(this, object);
            stringBuilder.append(((HtmlNodeExpander)object2).expand());
        }
        return stringBuilder.toString();
    }

    private Object processAmritaType(Object object) {
        for (AmritaType amritaType : this.amritaTypeList) {
            object = amritaType.processHtmlNode(this, object);
        }
        return object;
    }

    private void processAmriteScript(Object object, String string, Object object2) {
        for (AmritaScript amritaScript : this.amritaScriptList) {
            amritaScript.processHtmlNode(this, object, string, object2);
        }
    }

    @Override
    public boolean isPutStartQName() {
        if (this.startQName == null) {
            return false;
        }
        return !this.startQName.equalsIgnoreCase("span") || !this.hasAmritaHandler() || this.attributes.keySet().size() > 1;
    }

    @Override
    public boolean isPutEndQName() {
        if (this.endQName == null) {
            return false;
        }
        return !this.endQName.equalsIgnoreCase("span") || !this.hasAmritaHandler() || this.attributes.keySet().size() > 1;
    }
}

