/*
 * Decompiled with CFR 0.152.
 */
package org.amritaj.html;

import java.util.Stack;
import org.amritaj.html.HtmlNode;
import org.amritaj.html.Node;
import org.amritaj.html.impl.HtmlNodeImpl;
import org.amritaj.html.impl.RootNodeImpl;
import org.amritaj.html.impl.TextNodeImpl;
import org.amritaj.script.impl.AmritaScriptImpl;
import org.amritaj.type.impl.CheckBoxImpl;
import org.amritaj.type.impl.InputImpl;
import org.amritaj.type.impl.LinkImpl;
import org.amritaj.type.impl.UseArgsImpl;
import org.amritaj.type.impl.UseOriginalElementImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AmritajHtmlHandler
extends DefaultHandler {
    private Node rootNode = null;
    private Node currentNode = null;
    private Stack<Node> nodeStack = new Stack();

    public void startDocument() throws SAXException {
        super.startDocument();
        this.currentNode = this.rootNode = new RootNodeImpl();
    }

    private void addAttributes(HtmlNode htmlNode, Attributes attributes) {
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            String string = attributes.getQName(i);
            if (string.equalsIgnoreCase("amrita:type")) {
                this.handleAmritaType(htmlNode, attributes.getValue(i));
                continue;
            }
            if (string.equalsIgnoreCase("amrita:script")) {
                this.handleAmritaScript(htmlNode, attributes.getValue(i));
                continue;
            }
            this.handleNormalAttribute(htmlNode, string, attributes.getValue(i));
        }
    }

    private void handleAmritaType(HtmlNode htmlNode, String string) {
        if ("link".equalsIgnoreCase(string)) {
            htmlNode.addAmritaType(new LinkImpl());
        } else if ("use_args".equalsIgnoreCase(string)) {
            htmlNode.addAmritaType(new UseArgsImpl());
        } else if ("use_original_element".equalsIgnoreCase(string)) {
            htmlNode.addAmritaType(new UseOriginalElementImpl());
        } else if ("input".equalsIgnoreCase(string)) {
            htmlNode.addAmritaType(new InputImpl());
        } else if ("checkbox".equalsIgnoreCase(string)) {
            htmlNode.addAmritaType(new CheckBoxImpl());
        }
    }

    private void handleAmritaScript(HtmlNode htmlNode, String string) {
        htmlNode.addAmritaScript(new AmritaScriptImpl(string));
    }

    private void handleNormalAttribute(HtmlNode htmlNode, String string, String string2) {
        htmlNode.addAttribute(string, string2);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        super.startElement(string, string2, string3, attributes);
        HtmlNodeImpl htmlNodeImpl = new HtmlNodeImpl(this.rootNode, this.currentNode);
        htmlNodeImpl.setStartQName(string3);
        this.addAttributes(htmlNodeImpl, attributes);
        this.currentNode.addChild(htmlNodeImpl);
        this.nodeStack.push(this.currentNode);
        this.currentNode = htmlNodeImpl;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        super.characters(cArray, n, n2);
        TextNodeImpl textNodeImpl = new TextNodeImpl(this.rootNode, this.currentNode, new String(cArray, n, n2));
        this.currentNode.addChild(textNodeImpl);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        super.endElement(string, string2, string3);
        if (this.currentNode instanceof HtmlNode) {
            HtmlNode htmlNode = (HtmlNode)this.currentNode;
            htmlNode.setEndQName(string3);
        }
        this.currentNode = this.nodeStack.pop();
    }

    public void endDocument() throws SAXException {
        super.endDocument();
    }

    public Node getRootNode() {
        return this.rootNode;
    }
}

