package org.amritaj.sample;

import java.util.HashMap;
import java.util.Map;

import org.amritaj.AmritaJHelper;
import org.amritaj.AmritaJProc;
import org.amritaj.TemplateFile;
import org.amritaj.Tuple;
import org.amritaj.html.HtmlNode;
import org.amritaj.html.impl.TextNodeImpl;

public class Attribute {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		TemplateFile template = new TemplateFile("src/sample/html/Attribute.html");
		
		HashMap<String, Object> po = new HashMap<String, Object>();
		
		po.put("a1", AmritaJHelper.attr("href", "http://amritaj.sourceforge.jp", "replaced"));
		po.put("a2", "http://amritaj.sourceforge.jp");
		po.put("a3", new AmritaJProc() {
			public HtmlNode execute(HtmlNode node) {
				node.addChild(new TextNodeImpl(node.getRoot(), node, "(Javanese)"));
				Map<String, String> attr = node.getAttributeMap();
				String href = attr.get("href");
				attr.put("href", href + "ja");
				return node;
			}
		});
		po.put("rubytalk", "132304");
		Tuple t = new Tuple();
		t.addReplaceValue("amrita");
		t.addReplaceValue("amrita: HTML template library");
		po.put("raa", t);
		
		template.expand(System.out, po);
	}

}
