/*
 * Copyright(C) 2007 t-doi,All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.amritaj;

import junit.framework.TestCase;

import org.amritaj.html.HtmlNode;
import org.amritaj.html.impl.HtmlNodeImpl;
import org.amritaj.html.impl.RootNodeImpl;
import org.amritaj.html.impl.TextNodeImpl;
import org.amritaj.script.AmritaScript;
import org.amritaj.script.impl.AmritaScriptImpl;

public class AmritaScriptTest extends TestCase {
	
	public void testNormalEval() {

		RootNodeImpl root = new RootNodeImpl();
		HtmlNodeImpl span = new HtmlNodeImpl(root, root);
		span.setStartQName("span");
		span.setEndQName("span");
		root.addChild(span);
		
		String script[] = {"function hoge(){", "\n"
				, "var str = '';", "\n"
				, "for (i = 0; i < 10; i++) {", "\n"
				, "  str += 'Hello!';", "\n"
				, "}", "\n"
				, "return str;", "\n"
				, "}", "\n"
				, "hoge();", "\n"
		};
		
		textNodeHelper(span, script);
		
		AmritaScript as = new AmritaScriptImpl("js");
		as.processHtmlNode(span, null, "", null);
		assertEquals("<span>Hello!Hello!Hello!Hello!Hello!Hello!Hello!Hello!Hello!Hello!</span>", root.expand(""));
	}
	
	public class RootData {
		public ChildData getHoge() {
			return new ChildData();
		}
		
		public String getFuga() {
			return "fuga";
		}
		
		
	}
	
	public class ChildData {
		public String getHoge() {
			return "hoge";
		}
	}
	
	public void test2Script() {

		RootNodeImpl root = new RootNodeImpl();
		HtmlNodeImpl span = new HtmlNodeImpl(root, root);
		span.setStartQName("span");
		span.setEndQName("span");
		root.addChild(span);
		
		String script1[] = {"root.getHoge().getHoge()+root.getFuga();", "\n"
		};
		
		textNodeHelper(span, script1);
		
		HtmlNodeImpl span2 = new HtmlNodeImpl(root, span);
		span2.setStartQName("span");
		span2.setEndQName("span");
		span2.addChild(new TextNodeImpl(root, span2, "'sep'"));
		
		span.addChild(span2);
		
		String script2[] = {"hoge.getHoge();", "\n"
		};
		
		textNodeHelper(span, script2);
					
		AmritaScript as = new AmritaScriptImpl("js");
		as.processHtmlNode(span, new RootData(), "hoge", new ChildData());
		assertEquals("<span>hogefuga<span>sep</span>hoge</span>", root.expand(""));
	}
	
	public void testEndHtmlNode() {

		RootNodeImpl root = new RootNodeImpl();
		HtmlNodeImpl span = new HtmlNodeImpl(root, root);
		span.setStartQName("span");
		span.setEndQName("span");
		root.addChild(span);
		
		String script1[] = {"root.getHoge().getHoge()+root.getFuga();", "\n"
		};
		
		textNodeHelper(span, script1);
		
		HtmlNodeImpl span2 = new HtmlNodeImpl(root, span);
		span2.setStartQName("span");
		span2.setEndQName("span");
		span2.addChild(new TextNodeImpl(root, span2, "'sep'"));
		
		span.addChild(span2);
		
		AmritaScript as = new AmritaScriptImpl("js");
		as.processHtmlNode(span, new RootData(), "hoge", new ChildData());
		assertEquals("<span>hogefuga<span>sep</span></span>", root.expand(""));
	}	
		
	
	private void textNodeHelper(HtmlNode parent, String[] script) {
		for (int i = 0; i < script.length ; ++i) {
			parent.addChild(new TextNodeImpl(parent.getRoot(), parent, script[i]));
		}
	}
	
	public void testNestScript() {

		RootNodeImpl root = new RootNodeImpl();
		HtmlNodeImpl span = new HtmlNodeImpl(root, root);
		span.setStartQName("span");
		span.setEndQName("span");
		root.addChild(span);
		
		String script1[] = {"root.getHoge().getHoge()+root.getFuga();", "\n"
		};
		
		textNodeHelper(span, script1);
		
		HtmlNodeImpl span2 = new HtmlNodeImpl(root, span);
		span2.setStartQName("span");
		span2.setEndQName("span");
		
		span.addChild(span2);
		
		String script2[] = {"hoge.getHoge();", "\n"
		};
		
		textNodeHelper(span2, script2);
					
		AmritaScript as = new AmritaScriptImpl("js");
		as.processHtmlNode(span, new RootData(), "hoge", new ChildData());
		assertEquals("<span>hogefuga<span>hoge</span></span>", root.expand(""));
	}	

}
