#! /usr/bin/ruby

require 'net/http'
require 'uri'

if (ARGV[0] == nil) 
  print "fossil.rb URL:\n"
  print "fossil.rb http://anthy.sourceforge.jp/fossil/fossil-example/a.html\n"
  exit
end

def push_word()
  print "#index="
  print @ent["index"]
  print " word="
  print @ent["word"]
  print " pos="
  print @ent["pos"]
  print " canna-pos="
  print @ent["ctd-pos"]
  print "\n"
end

def parse_link()
  url = @ent["url"]
  if (@visited[url])
    return
  end
  @will_visit.push(url)
end

def parse_entry()
  if (@ent["type"] == "word")
    push_word();
  end
  if (@ent["type"] == "link")
    parse_link()
  end
end

def parse(arg)
  uri = URI.parse(arg)

  conn = Net::HTTP::new(uri.host)
  conn.get(uri.path){|s| @str = s}

  @ent = {}

  @str.each_line{|ln|
    if (ln =~ /^#/ || !(ln =~ /\S+/))
      parse_entry()
      @ent = {}
    end
    if (ln =~ /(\S+):\s+(\S+)/)
      $2.chomp
      @ent[$1] = $2
    end
  }
  parse_entry()
end

@will_visit = [];
@visited = {};

@will_visit.push(ARGV[0])
while (@will_visit.length > 0)
  url = @will_visit.shift
  print(["#URL=", url,"\n"])
  parse(url)
end

