/*
 * Anthy library interface
 * Anthy is a KanaKanji conversion engine (Library for Japanese Input Method)
 *
 * please read doc/LIB file in source package.
 */
#ifndef _anthy_h_included_
#define _anthy_h_included_

#ifdef __cplusplus
extern "C" {
#endif


/* Data types */
struct anthy_conv_stat{
  int nr_segment;
};

struct anthy_segment_stat{
  int nr_candidate;
  int seg_len;
};

typedef struct anthy_context *anthy_context_t;



/* constants */
#define NTH_UNCONVERTED_CANDIDATE -1



/* Configuration */
int anthy_init();
void anthy_quit();
void anthy_conf_override(char *, char *);
int anthy_set_personality(char *);



/* Context management */
anthy_context_t anthy_create_context();
void anthy_reset_context(anthy_context_t);
void anthy_release_context(anthy_context_t);



/* Conversion control */
int anthy_set_string(anthy_context_t, char *);
/* nth,resize ie. +1,-1 */
void anthy_resize_segment(anthy_context_t, int, int);
int anthy_get_stat(anthy_context_t, struct anthy_conv_stat *);
int anthy_get_segment_stat(anthy_context_t, int, struct anthy_segment_stat *);
/* context,nth segment,nth candidate,buffer,buffer len */
int anthy_get_segment(anthy_context_t, int, int, char *, int);
/* ʸᤴȤ˥ߥåȤ */
int anthy_commit_segment(anthy_context_t, int, int);



/* Etc */
void anthy_print_context(anthy_context_t);

#ifdef __cplusplus
}
#endif

#endif
