/*
 * ¤Υ
 * Funded by IPA̤Ƨեȥ¤ 2001 8/15
 *
 * dtor: destructor
 * 
 * ڡΥե꡼chunkñꥹȤ˷ѤƤ
 * chunk°ڡؤƤ
 */

#include <stdlib.h>
#include <stdio.h>
#include <alloc.h>

//#define MEM_DEBUG
/**/
#define HEAD_MAGIC 0x12345678
#define TAIL_MAGIC 0x87654321

static int nr_pages;


#define PAGE_SIZE 4096
#define HEADER_SIZE (sizeof(void *))

struct chunk {
  void *ptr;
  void *storage[1];
};

/*
 * pagestorageˤ max_obj = PAGE_SIZE / (objsize + HEADER_SIZE)Ĥ
 * åȤ롣Τuse_countĤΥåȤfree_listˤĤʤäƤ롢
 * ⤷ϻǤ롣
 */
struct page {
  int objsize;
  int max_obj;
  int use_count;
  struct page *prev, *next;
  struct chunk free_list;
  unsigned char *storage;
};

struct allocator_{
  int size;
  struct page page_list;
  struct allocator_ *next;
  void (*dtor)(void *);/* sfreeݤ˸ƤФ */
}allocator_list;

static struct chunk *get_chunk_address(void *s);
static struct page *alloc_page(int size);
static struct chunk *get_chunk_from_page(struct page *p);

struct chunk *get_chunk_address(void *s)
{
  return (struct chunk *)
    ((unsigned long)s - HEADER_SIZE);
}

struct page *alloc_page(int objsize)
{
  struct page *p;
  p = malloc(sizeof(*p));
  if (!p) {
    fprintf(stderr, "Anthy: Fatal error: Failed to allocate memory.\n");
    exit(-1);
  }
  p->storage = malloc(PAGE_SIZE);
  if (!p->storage) {
    fprintf(stderr, "Anthy: Fatal error: Failed to allocate memory.\n");
    exit(-1);
  }
  p->objsize = objsize;
  p->max_obj = PAGE_SIZE / (objsize + HEADER_SIZE);
  p->use_count = 0;
  p->free_list.ptr = NULL;
  return p;
}

struct chunk *get_chunk_from_page(struct page *p)
{
  struct chunk *c;
  if (p->free_list.ptr) {
    c = (struct chunk *)p->free_list.ptr;
    p->free_list.ptr = c->ptr;
    c->ptr = p;
    return c;
  }
  if (p->use_count == p->max_obj) {
    return NULL;
  }
  c = (struct chunk *)
    &p->storage[p->use_count * (p->objsize + HEADER_SIZE)];
  c->ptr = p;
  p->use_count ++;
  return c;
}

allocator create_allocator(int size, void (*dtor)(void *))
{
  allocator a;
  if (size >= PAGE_SIZE - HEADER_SIZE) {
    fprintf(stderr, "Anthy: Fatal error: too big allocator is requested.\n");
    exit(-1);
  }
  a = malloc(sizeof(*a));
  if (!a) {
    fprintf(stderr, "Anthy: Fatal error: Failed to allocate memory.\n");
    exit(-1);
  }
  a->size = size;
  a->dtor = dtor;
  a->page_list.next = &a->page_list;
  a->page_list.prev = &a->page_list;
  return a;
}

void free_allocator(allocator a)
{
  struct page *p, *tmp;
  for (p = a->page_list.next; p != &a->page_list; ) {
    int i;
    tmp = p->next;
    if (a->dtor) {
      for (i = 0; i < p->use_count; i++) {
	struct chunk *c;
	c = (struct chunk *)
	  &p->storage[i * (p->objsize + HEADER_SIZE)];
	if (c->ptr == (void*)p) {
	  a->dtor(c->storage);
	}
      }
    }
    free(p->storage);
    free(p);
    nr_pages--;
    p = tmp;
  }
  free(a);
}

void *smalloc(allocator a)
{
  struct page *p;
  struct chunk *c;
  for (p = a->page_list.next; p != &a->page_list; p = p->next) {
    c = get_chunk_from_page(p);
    if (c) {
      return c->storage;
    }
  }
  p = alloc_page(a->size);
  nr_pages++;
  p->next = a->page_list.next;
  p->prev = &a->page_list;
  a->page_list.next->prev = p;
  a->page_list.next = p;
  c = get_chunk_from_page(p);
  return c->storage;
}

void sfree(allocator a, void *ptr)
{
  struct chunk *c;
  struct page *p;
  if (a->dtor) {
    a->dtor(ptr);
  }
  c = get_chunk_address(ptr);
  p = (struct page *)c->ptr;
  c->ptr = p->free_list.ptr;
  p->free_list.ptr = (void *)c;
}

void quit_allocator()
{
  allocator a;
  for (a = allocator_list.next; a;) {
    allocator tmp;
    tmp = a;
    free_allocator(tmp);
    a = a->next;
  }
  allocator_list.next = NULL;
}
