/*
 * AnthyΥǡ١
 * conf_initꤵѿconf_overrideꤵ
 * ѿδط
 */
#include <unistd.h>
#include <pwd.h>
#include <time.h>
#include <sys/types.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <alloc.h>
#include <conf.h>

#include <config.h>

static struct val_ent{
  char *var;
  char *val;
  struct val_ent *next;
}ents;

static void add_val(char *, char *);
static struct val_ent *find_val_ent(char *v);
static void read_conf_file();
static void alloc_session_id();
static void val_ent_dtor(void *);

static int confIsInit;
static allocator val_ent_ator;

void val_ent_dtor(void *p)
{
  struct val_ent *v = p;
  free(v->var);
  if (v->val) {
    free(v->val);
  }
}

struct val_ent *find_val_ent(char *v)
{
  struct val_ent *e;
  for (e = ents.next; e; e = e->next) {
    if(!strcmp(v, e->var)) {
      return e;
    }
  }
  e = malloc(sizeof(struct val_ent));
  e->var = strdup(v);
  e->val = 0;
  e->next = ents.next;
  ents.next = e;
  return e;
}

void add_val(char *var, char *val)
{
  struct val_ent *e;
  e = find_val_ent(var);
  if (e->val) {
    free(e->val);
  }
  e->val = strdup(val);
}

void read_conf_file()
{
  char *fn;
  FILE *fp;
  char buf[256];
  fn = conf_get_str("CONFFILE");
  fp = fopen(fn, "r");
  if (!fp){
    fprintf(stderr, "Anthy: Failed to open %s\n", fn);
    return ;
  }
  while(fgets(buf, 256, fp)) {
    if (buf[0] != '#') {
      char var[256], val[256];
      if (sscanf(buf, "%s %s", var, val) == 2){
	add_val(var, val);
      }
    }
  }
  fclose(fp);
}

void conf_override(char *var, char *val)
{
  if (!strcmp(var,"CONFFILE")) {
    add_val(var, val);
    conf_init();
  }else{
    conf_init();
    add_val(var, val);
  }
}

void alloc_session_id()
{
  time_t t;
  pid_t pid;
  char hn[64];
  char sid[80];
  t = time(0);
  pid = getpid();
  gethostname(hn, 64);
  sprintf(sid,"%s-%x-%d", hn, (unsigned int)t, pid);
  add_val("SESSION-ID", sid);
}

void conf_init()
{
  char *fn;
  val_ent_ator = create_allocator(sizeof(struct val_ent),
				  val_ent_dtor);

  if (!confIsInit) {
    struct passwd *pw;
    /*ǥեȤͤꤹ롣*/
    add_val("VERSION", VERSION);
    fn = conf_get_str("CONFFILE");
    if (!fn){
      add_val("CONFFILE", CONF_DIR"/anthy-conf");
    }
    pw = getpwuid(getuid());
    add_val("HOME", pw->pw_dir);
    alloc_session_id();
    read_conf_file();
    confIsInit = 1;
  }
}

char *conf_get_str(char *var)
{
  struct val_ent *e;
  e = find_val_ent(var);
  return e->val;
}
