/*
 * ddicΥåºݤ˹Ԥ
 */
#include <stdio.h>
#include <stdlib.h>

#include <alloc.h>
#include "dic_main.h"
#include "ddic_tree.h"

/* ̵ä0֤ */
static struct seq_node *alloc_seq_node_by_xstr(ddic_t d, xstr *);
static int hash_function(xstr *x);
static void seq_node_dtor(void *);
static void ddic_dtor(void *);

static allocator ddic_ator;

void seq_node_dtor(void *p)
{
  struct seq_node *s = p;
  int i;
  for (i = 0; i < s->data.nr_dic_ents; i++) {
    free(s->data.dic_ents[i]->str.str);
    free(s->data.dic_ents[i]);
  }
  if (s->data.nr_dic_ents) {
    free(s->data.dic_ents);
  }
  free(s->str.str);
}

void ddic_dtor(void *p)
{
  ddic_t d = p;
  free_allocator(d->node_allocator);
}

struct seq_node *alloc_seq_node_by_xstr(ddic_t d, xstr *x)
{
  struct seq_node *s;
  int mask = get_current_session_mask();
  s = (struct seq_node *)smalloc(d->node_allocator);
  s->data.dic_ents = 0;
  s->data.flags = F_NONE;
  s->data.nr_dic_ents = 0;
  s->data.node_type = 0;
  s->data.back = 0;
  s->str.len = x->len;
  s->str.str = xstr_dup_str(x);
  s->mask = mask;
  return s;
}

struct seq_ent *ddic_alloc_seq_ent_by_xstr(ddic_t d, xstr *x)
{
  struct seq_node *n;
  struct seq_ent *e;
  struct ddic_handle *dd=d;
  int h;
  /*åˤФ֤*/
  e = ddic_find_seq_ent_by_xstr(d,x);
  if (e) {
    return e;
  }
  /*/åˤ̵ä*/
  n = alloc_seq_node_by_xstr(d,x);

  h = hash_function(x);
  n->next = dd->root_node[h].next;
  dd->root_node[h].next = n;

  return &n->data;
}

struct seq_ent *ddic_find_seq_ent_by_xstr(ddic_t d,xstr *x)
{
  struct seq_node *c;
  struct ddic_handle *dh=d;
  int h;
  h = hash_function(x);
  for ( c = dh->root_node[h].next ; c ;c= c->next){
    if (!xstrcmp(&c->str,x)){
      int mask;
      mask = get_current_session_mask();
      c->mask |= mask;
      return &c->data;
    }
  }
  return 0;
}

void ddic_release_seq_ent(ddic_t d, xstr *x)
{
  struct seq_node *c;
  struct ddic_handle *dh = d;
  int h;
  h = hash_function(x);
  for (c = &dh->root_node[h]; c->next; c = c->next) {
    if (!xstrcmp(&c->next->str,x)) {
      struct seq_node *p;
      p = c->next;
      c->next = c->next->next;
      sfree(d->node_allocator, p);
      return ;
    }
  }
}

void invalidate_seq_node_mask(ddic_t d,int mask)
{
  int i;
  struct seq_node *n;
  for (i = 0; i < HASH_SIZE; i++) {
    for (n = d->root_node[i].next; n; n = n->next) {
      n->mask &= mask;
    }
  }
}

void ddic_push_back_dic_ent(struct seq_ent *se,xstr *xs,wtype_t wt,int freq)
{
  struct dic_ent *de;
  de = malloc(sizeof(struct dic_ent));
  de->type = wt;
  de->freq = freq;
  de->str.len = xs->len;
  de->str.str = xstr_dup_str(xs);

  se->nr_dic_ents ++;
  se->dic_ents = realloc(se->dic_ents,
			sizeof(struct dic_ent *)*se->nr_dic_ents);
  se->dic_ents[se->nr_dic_ents-1] = de;
}

ddic_t create_ddic()
{
  int i;
  struct ddic_handle *de;

  de = smalloc(ddic_ator);
  for (i=0 ; i<HASH_SIZE ; i++) {
    de->root_node[i].next = 0;
  }
  
  de->node_allocator = 
    create_allocator(sizeof(struct seq_node),
		     seq_node_dtor);
  init_sessions(de);

  return de;
}

void release_ddic(ddic_t d)
{
  sfree(ddic_ator, d);
}

/*ϥåؿȤꤢƤȡ*/
int hash_function(xstr *x)
{
  if (x->len) {
    return x->str[0]% HASH_SIZE;
  }
  return 0;
}

void shrink_ddic(ddic_t d)
{
  int i;
  struct seq_node *n;
  for ( i = 0 ; i < HASH_SIZE ; i ++){
    n = &d->root_node[i];
    for (; n && n->next ; n = n->next) {
      if (!n->next->mask) {
	/*ɤΥåˤäƤȤƤʤ*/
	struct seq_node *tmp;
	tmp = n->next;
	n->next = n->next->next;
	sfree(d->node_allocator,tmp);
      }
    }
  }
}

void init_ddic()
{
  ddic_ator = create_allocator(sizeof(struct ddic_handle),
			       ddic_dtor);
}

void quit_ddic()
{
  free_allocator(ddic_ator);
}
