/*
 * ΥåԤ
 * ºݤ˥å夹Τddic_ent.c
 * (ΤsdicʣĤ⤷ʤ)
 * ĿѤμⰷ
 */
#include <stdlib.h>
#include <stdio.h>

#include <alloc.h>
#include <wtype.h>
#include <record.h>
#include <dic.h>
#include <conf.h>

#include "xchar.h"
#include "dic_main.h"
#include "dic_cache.h"
#include "dic_ent.h"
#include "dic_personality.h"

/* personalityǶͭ뼭 */
struct global_cache g_dic_cache;

/* ɽ */
static struct conjugate_table{
  xchar t[2];
  int cc;
  int ct;
  int cst;
}ctab[]={
#include "ctab.h"
};

/* ؤΥ */
static void fill_conjugated_ent(xstr *x, struct seq_ent *);
static void fill_sv_conjugated_ent(xstr *x, struct seq_ent *,
				   struct conjugate_table *);
static void calc_seq_flags(struct seq_ent *);
static struct seq_ent *global_cache_get_seq_ent(xstr *x);
static struct seq_ent *cache_get_seq_ent_to_ddic(ddic_t d, xstr *x);

/* Ŀͼ */
static void init_private_dic(ddic_t);
static void add_word_to_private_dic(ddic_t);

/*
 * ñγѤμबɽΥȥȰפñ򼭽񤫤õ
 */
void fill_conjugated_ent(xstr *x, struct seq_ent *s)
{
  struct conjugate_table *p;
  xchar l1 = 0, l2 = 0;
  xstr z;
  xstr tail;/* Ѹ */
  z.str = x->str;
  z.len = x->len;

  /* Ǹΰʸʸ */
  if (x->len > 0) {
    l1 = x->str[x->len - 1];
    if (x->len > 1) {
      l2 = x->str[x->len - 2];
    }
  }

  /* ɽγƳѥѥФ */
  for (p = &ctab[0]; p->t[0] >= 0; p++) {
    tail.str = p->t;
    if (p->t[0] == 0) {
      /* 촴ΤߤǤڤ */
      z.len = x->len;
      sdic_fill_seq_ent_by_xstr(g_dic_cache.dic,
				&z, s, 0, p->cc, p->ct, p->cst);
    }else if (p->t[1] == 0) {
      /* Ѥʬʸ */
      tail.len = 1;
      if (l1 == p->t[0]) {
	z.len = x->len - 1;
	sdic_fill_seq_ent_by_xstr(g_dic_cache.dic,
				  &z, s, &tail, p->cc, p->ct, p->cst);
	if (p->cc == CC_SV && z.len == 0) {
	  fill_sv_conjugated_ent(x, s, p);
	}
      }
    }else{
      tail.len = 2;
      /* Ѥʬʸ */
      if (l2 == p->t[0] && l1 == p->t[1]) {
	z.len = x->len - 2;
	sdic_fill_seq_ent_by_xstr(g_dic_cache.dic,
				  &z, s, &tail, p->cc, p->ct, p->cst);
	if (p->cc == CC_SV && z.len == 0) {
	  fill_sv_conjugated_ent(x, s, p);
	}
      }
    }
  }
}

/*
 * ̤Υưϳɽ˴𤤤̤˽򤹤Τ
 * Ǥϡ֤ñȤǽФ 
 */
void fill_sv_conjugated_ent(xstr *x, struct seq_ent *s, struct conjugate_table *c)
{
  wtype_t wt = wt_all;
  wtype_set_pos(&wt, POS_V);
  wtype_set_cc(&wt, CC_SV);
  wtype_set_ct(&wt, c->ct);
  wtype_set_cst(&wt, c->cst);
  ddic_push_back_dic_ent(s, x, wt, 1);
}

void calc_seq_flags(struct seq_ent *e)
{
  int i;
  for (i = 0; i < e->nr_dic_ents; i++) {
    int p;
    p = wtype_get_pos(e->dic_ents[i]->type);
    switch (p) {
    case POS_NOUN:
    {
      int c;
      c = wtype_get_cos(e->dic_ents[i]->type);
      if (c == COS_NN) {
	e->flags |= NF_NUM;
      }else if (c == COS_JN) {
	e->flags |= NF_NAME;
      }
    }
    break;
    case POS_PRE:
    case POS_SUC:
    {
      int c;
      c = wtype_get_cos(e->dic_ents[i]->type);
      if (c == COS_JN) {
	e->flags |= SF_JN;
      }else if (c == COS_NN) {
	e->flags |= SF_NUM;
      }
    }
    break;
    }
  }
}

void add_word_to_private_dic(ddic_t d)
{
  int nr, i;
  xstr *word,*yomi,*tmp;
  wtype_t wt;
  char *cstr;
  int freq;
  struct seq_ent *se;

  nr = get_nr_values();
  if (nr < 3) {
    return ;
  }
  yomi = get_index_xstr();
  for (i = 0; i + 2 < nr; i += 3) {
    word = get_nth_xstr(i);/* ñ */
    tmp = get_nth_xstr(i+1);/* ʻ̾ */
    cstr = xstr_to_cstr(tmp);
    type_to_wtype(cstr, &wt);
    free(cstr);
    freq = get_nth_value(i+2);/*  */

    se = ddic_alloc_seq_ent_by_xstr(d, yomi);
    ddic_push_back_dic_ent(se, word, wt, freq);
  }
}

void init_private_dic(ddic_t d)
{
  if (select_section("PRIVATEDIC", 0) == -1) {
    return ;
  }
  if (select_first_column() == -1) {
    return ;
  }
  do {
    add_word_to_private_dic(d);
  } while (select_next_column() != -1);
}

int init_dic_cache()
{
  char *fn;
  fn = conf_get_str("SDIC");
  if (!fn) {
    fprintf(stderr, "Anthy: sdic file not specified.\n");
    return -1;
  }
  g_dic_cache.dic = create_sdic(fn);
  if (!g_dic_cache.dic) {
    fprintf(stderr, "Anthy: Failed to create sdic.\n");
    return -1;
  }
  g_dic_cache.cache = create_ddic();
  return 0;
}

struct seq_ent *cache_get_seq_ent_to_ddic(ddic_t d, xstr *x)
{
  struct seq_ent *s = ddic_find_seq_ent_by_xstr(d, x);
  if (s) {
    return s;
  }
  s = ddic_alloc_seq_ent_by_xstr(d, x);

  /* sdicΥեå */
  /* ޤեå */
  sdic_fill_seq_ent_by_xstr(g_dic_cache.dic, x, s, 0,
			    CC_NONE, CT_NONE, CST_NONE);
  /* ư̾ȤƤθ */
  sdic_fill_seq_ent_by_xstr(g_dic_cache.dic, x, s, 0,
			    CC_AJV, CT_NONE, CST_NONE);
  /* Ĥ˳Ѥ륨ȥ򸡺 */
  fill_conjugated_ent(x, s);

  /*٤Ƥdic_entФflag׻*/
  calc_seq_flags(s);
  
  return s;
}

struct seq_ent *global_cache_get_seq_ent(xstr *x)
{
  return cache_get_seq_ent_to_ddic(g_dic_cache.cache,x);
}

struct seq_ent *cache_get_seq_ent(xstr *x)
{
  struct seq_ent *s, *t;
  ddic_t dic;

  if (!get_current_session_mask()) {
    /*
     * ѡʥƥꤵƤʤΤǡ
     * Х륭å˼Ф
     */
    return global_cache_get_seq_ent(x);
  }

  /* ߥѡʥƥΥåϤ */
  dic = gCurrentPersonality->dic->cache;

  /* åˤФ֤ */
  s = ddic_find_seq_ent_by_xstr(dic, x);
  if (s) {
    return s;
  }

  /*
   * ʬ(ȥѡʥƥ)Υå̵Τ
   * Х륭å򸫤
   */
  t = ddic_find_seq_ent_by_xstr(g_dic_cache.cache, x);
  if (t) {
    /* äΤƤ򥳥ԡƤ */
    int i;
    s = ddic_alloc_seq_ent_by_xstr(dic, x);
    s->back = t;
    s->node_type = t->node_type;
    /* tƤs˥ԡ */
    for (i = 0; i < t->nr_dic_ents; i++) {
      ddic_push_back_dic_ent(s,
			     &t->dic_ents[i]->str,t->dic_ents[i]->type,
			     t->dic_ents[i]->freq);
    }
    calc_seq_flags(s);
  }else{
    /* ʤäΤǼʬѤ˥쥯Ȥ˼Ф */
    s = cache_get_seq_ent_to_ddic(dic, x);
  }

  /* Ŀͼ񤫤Υեå */
  t = ddic_find_seq_ent_by_xstr(gCurrentPersonality->dic->priv, x);
  if (t) {
    int i;
    /* Ŀͼˤ⤢ä */
    for (i = 0; i < t->nr_dic_ents; i++) {
      ddic_push_back_dic_ent(s,
			     &t->dic_ents[i]->str,t->dic_ents[i]->type,
			     t->dic_ents[i]->freq);
    }
  }

  if (s->nr_dic_ents == 0) {
    /* ̵ʥȥΤcache */
    ddic_release_seq_ent(dic, x);
    return 0;
  }
  
  return s;
}

void shrink_cache()
{
  shrink_ddic(gCurrentPersonality->dic->cache);
}

struct dic_cache *create_dic_cache(char *id)
{
  struct dic_cache *d = malloc(sizeof(struct dic_cache));
  d->id = id;
  d->cache = create_ddic();
  d->priv = create_ddic();
  init_private_dic(d->priv);
  return d;
}

void release_dic_cache(struct dic_cache * d)
{
  release_ddic(d->cache);
  release_ddic(d->priv);
  free(d);
}
