/*
 * Anthyμ饤֥Υȥ롼
 */
#include <stdlib.h>
#include <stdio.h>

#include <dic.h>
#include <conf.h>
#include <record.h>
#include <alloc.h>

#include "dic_main.h"
#include "dic_personality.h"
#include "dic_ent.h"
#include "dic_cache.h"
#include "dic_session.h"

/**/
static int dic_is_init;

/*  */

/* personality */
struct dic_personality *gCurrentPersonality;
static struct dic_personality personality_list;
static struct dic_personality *find_personality(char *id);

int init_anthy_dic()
{
  if (dic_is_init) {
    return 0;
  }
  conf_init();

  init_wtypes();
  init_ext_ent();
  init_ddic();
  init_record();
  init_xchar_tab();

  if (init_dic_cache() == -1) {
    fprintf(stderr, "Anthy: Failed to init dic cache.\n");
    return -1;
  }
  dic_is_init = 1;
  return 0;
}

void quit_anthy_dic()
{
  quit_ddic();
  quit_allocator();
  dic_is_init = 0;
}

int seq_ent_cmp(seq_ent_t s, seq_ent_t t)
{
  if (s == t) {
    return 0;
  }
  if (!s || !t) {
    return 1;
  }
  if (s->back == t || s == t->back) {
    return 0;
  }
  return 1;
}


seq_ent_t get_seq_ent_from_xstr(xstr *x)
{
  struct seq_ent *s;
  s = cache_get_seq_ent(x);
  if (!s || s->nr_dic_ents==0) {
    return get_ext_seq_ent_from_xstr(x);
  }
  return s;
}

int get_seq_ent_type(seq_ent_t s)
{
  struct seq_ent *se=s;
  if (!se) {
    return ST_NONE;
  }
  return se->node_type;
}

int get_seq_flag(seq_ent_t se)
{
  if (!se) {
    return 0;
  }
  return se->flags;
}

int get_nr_dic_ents(seq_ent_t se, xstr *xs)
{
  struct seq_ent *s = se;
  if (!s) {
    return 0;
  }
  return s->nr_dic_ents + get_nr_dic_ents_of_ext_ent(se, xs);
}

int get_nth_dic_ent_str(seq_ent_t se, xstr *o, int n, xstr *x)
{
  struct seq_ent *s = se;
  if (!s) {
    return -1;
  }
  if (n >= s->nr_dic_ents) {
    return get_nth_dic_ent_str_of_ext_ent(se, o, n - s->nr_dic_ents, x);
  }
  x->len = s->dic_ents[n]->str.len;
  x->str = xstr_dup_str(&s->dic_ents[n]->str);
  return 0;
}

int get_nth_dic_ent_freq(seq_ent_t se, int n)
{
  struct seq_ent *s = se;
  if (!s || s->nr_dic_ents <= n) {
      return 0;
  }
  return s->dic_ents[n]->freq;
}

int get_nth_dic_ent_wtype(seq_ent_t se, xstr *xs, int n, wtype_t *w)
{
  struct seq_ent *s = se;
  if (!s) {
    *w = wt_none;
    return -1;
  }
  if (s->nr_dic_ents <= n) {
    int r;
    r = get_nth_dic_ent_wtype_of_ext_ent(xs, n - s->nr_dic_ents, w);
    if ( r == -1) {
      *w = wt_none;
    }
    return r;
  }
  *w =  s->dic_ents[n]->type;
  return 0;
}

int get_seq_ent_pos(seq_ent_t se, int pos)
{
  int i, v=0;
  struct seq_ent *s = se;
  if (!s) {
    return 0;
  }
  if (s->nr_dic_ents == 0) {
    return get_ext_seq_ent_pos(se, pos);
  }
  for (i = 0; i < s->nr_dic_ents; i++) {
    if (wtype_get_pos(s->dic_ents[i]->type) == pos) {
      v += s->dic_ents[i]->freq;
      if (v == 0) {
	v = 1;
      }
    }
  }
  return v;
}

int get_seq_ent_ct(seq_ent_t se, int pos, int ct)
{
  int i, v=0;
  struct seq_ent *s = se;
  if (!s) {
      return 0;
  }
  if (s->nr_dic_ents == 0) {
    return get_ext_seq_ent_ct(s, pos, ct);
  }
  for (i = 0; i < s->nr_dic_ents; i++) {
    if (wtype_get_pos(s->dic_ents[i]->type)== pos &&
	 wtype_get_ct(s->dic_ents[i]->type)==ct) {
      v += s->dic_ents[i]->freq;
      if (v == 0) {
	v = 1;
      }
    }
  }
  return v;
}

int get_ext_seq_ent_wtype(struct seq_ent *se, wtype_t w)
{
  if (wtype_get_pos(w) == POS_NOUN) {
    return 10;
  }
  return 0;
}

int get_seq_ent_wtype_freq(seq_ent_t se, wtype_t w)
{
  int i,f;
  struct seq_ent *s = se;
  if (!s) {
      return 0;
  }
  if (s->nr_dic_ents == 0) {
    return get_ext_seq_ent_wtype(se, w);
  }
  f = 0;
  for (i = 0; i < s->nr_dic_ents; i++) {
    if (wtypecmp(w, s->dic_ents[i]->type)) {
      if (f < s->dic_ents[i]->freq) {
	f = s->dic_ents[i]->freq;
      }
    }
  }
  return f;
}

int get_seq_ent_indep(seq_ent_t se)
{
  int i;
  struct seq_ent *s = se;
  if (!s) {
      return 0;
  }
  if (s->nr_dic_ents == 0) {
    return get_ext_seq_ent_indep(s);
  }
  for (i = 0; i < s->nr_dic_ents; i++) {
    if (wtype_get_indep(s->dic_ents[i]->type)) {
      return 1;
    }
  }
  return 0;
}

dic_session_t dic_create_session()
{
  return create_session();
}

void dic_activate_session(dic_session_t d)
{
  activate_session(d);
}

void dic_release_session(dic_session_t d)
{
  release_session(d);
  shrink_cache();
}

void dic_set_personality(char *id)
{
  gCurrentPersonality = find_personality(id);
  if (!gCurrentPersonality->record) {
    /*
     * 
     * 񥭥åιۤˤե뤬ɬ
     */
    gCurrentPersonality->record = create_record(id);
    gCurrentPersonality->dic = create_dic_cache(id);
  }
}

void dic_release_personality(char *id)
{
  struct dic_personality *p;
  if (gCurrentPersonality->id == id) {
    gCurrentPersonality = 0;
  }
  for (p = &personality_list; p && p->next; p = p->next) {
    if (p->next->id == id) {
      struct dic_personality *tmp;
      tmp = p->next;
      p->next = p->next->next;

      release_record(tmp->record);
      release_dic_cache(tmp->dic);

      free(tmp);
      return ;
    }
  }
}

struct dic_personality *find_personality(char *id)
{
  struct dic_personality *p;
  for (p = personality_list.next; p; p = p->next ) {
    if (p->id == id) {
      return p;
    }
  }
  p = malloc(sizeof(struct dic_personality));
  p->id = id;
  p->record = 0;
  p->dic = 0;

  p->next = personality_list.next;
  personality_list.next = p;
  return p;
}
