#ifndef _dic_main_h_included_
#define _dic_main_h_included_

#include "xstr.h"
#include "wtype.h"

typedef struct ddic_handle *ddic_t;
typedef struct sdic_handle *sdic_t;


/* dic_session.h */
void init_sessions(ddic_t d);
struct dic_session *create_session();
void activate_session(struct dic_session *);
void release_session(struct dic_session *);
int get_current_session_mask();


/* ddic.c */
void init_ddic();
void quit_ddic();
ddic_t create_ddic();
void release_ddic(ddic_t );
/* node ʤк */
struct seq_ent *ddic_alloc_seq_ent_by_xstr(ddic_t d,xstr *);
/* node ʤкʤ */
struct seq_ent *ddic_find_seq_ent_by_xstr(ddic_t d,xstr *);
void ddic_push_back_dic_ent(struct seq_ent *,xstr *,wtype_t ,int freq);
void ddic_release_seq_ent(ddic_t d,xstr *);
void shrink_ddic(ddic_t d);


/* dic_cache.c */
int init_dic_cache();
struct seq_ent *cache_get_seq_ent(xstr *x);
void shrink_cache();


/* sdic.c */
void init_sdic();
sdic_t create_sdic(char *fn);
void release_sdic(sdic_t );
void sdic_fill_seq_ent_by_xstr(sdic_t, xstr *, struct seq_ent *, xstr *eow,
			       int cc, int ct, int cst);


/* wtype.c */
void init_wtypes();


/* xchar.c */
void init_xchar_tab();

#endif
