/*
 * Υå񥭥åΥȥ
 * Ƥθߥƥ֤ѴƥȤȤäƤʤ
 * Τߤ˲뤳ȤǤ롣
 */

#include <stdlib.h>
#include <string.h>

#include <conf.h>
#include "dic_session.h"
#include "dic_personality.h"
#include "dic_cache.h"
#include "ddic_tree.h"

static struct dic_session *g_current_session;

/* åcurrentѡʥƥΥåФƺ */
struct dic_session *create_session()
{
  int i;
  ddic_t d = gCurrentPersonality->dic->cache;
  for (i = 0; i < MAX_SESSION; i++) {
    if (d->sessions[i].is_free) {
      d->sessions[i].is_free = 0;
      d->sessions[i].dic = d;
      return &d->sessions[i];
    }
  }
  return 0;
}

void activate_session(struct dic_session *d)
{
  g_current_session = d;
}

void release_session(struct dic_session *d)
{
  if (g_current_session == d) {
    g_current_session = 0;
  }
  d->is_free = 1;
  invalidate_seq_node_mask(d->dic, ~d->mask);
}

int get_current_session_mask()
{
  if (g_current_session) {
    return g_current_session->mask;
  }
  return 0;
}

void init_sessions(ddic_t d)
{
  int i;
  for (i = 0; i < MAX_SESSION; i++) {
    d->sessions[i].id = i;
    d->sessions[i].mask = 1<<i;
    d->sessions[i].is_free = 1;
  }
}
