/*
 * $B8D?M<-=q4IM}MQ$N4X?t72(B
 * Funded by IPA$BL$F'%=%U%H%&%'%"AOB$;v6H(B 2001 10/24
 */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <conf.h>
#include <dic.h>
#include <record.h>
#include <dicutil.h>

static int gIsInit;

/* record$BCf$NF1$8(Bindex$B$NCf$N2?HVL\$+$iCM$r<h$j=P$9$+(B */
static int gOffset;

void dic_util_init()
{
  if (gIsInit) {
    return ;
  }
  if (init_anthy_dic() == -1) {
    return ;
  }
  dic_set_personality("");
  gIsInit = 1;
}

void dic_util_set_personality(char *id)
{
  dic_set_personality(id);
}

void priv_dic_delete()
{
  if (select_section("PRIVATEDIC", 0) == -1) {
    return ;
  }
  release_section();
}

int priv_dic_select_first_entry()
{
  if (select_section("PRIVATEDIC",0) == -1) {
    return -1;
  }
  gOffset = 0;
  return select_first_column();
}

int priv_dic_select_next_entry()
{
  int nr = get_nr_values();
  if (nr > gOffset + 3) {
    gOffset += 3;
    return 0;
  }
  gOffset = 0;
  return select_next_column();
}

int priv_dic_select_entry(char *index)
{
  return 0;
}

char *priv_dic_get_index(char *buf, int len)
{
  xstr *xs;
  xs = get_index_xstr();
  if (!xs) {
    return 0;
  }
  if (snputxstr(buf, len, xs) == len) {
    return 0;
  }
  return buf;
}

int priv_dic_get_freq()
{
  return get_nth_value(gOffset + 2);
}

char *priv_dic_get_wtype(char *buf, int len)
{
  xstr *xs = get_nth_xstr(gOffset + 1);
  if (!xs) {
    return 0;
  }
  if (snputxstr(buf, len, xs) == len) {
    return 0;
  }
  return buf;
}

char *priv_dic_get_word(char *buf, int len)
{
  xstr *xs = get_nth_xstr(gOffset);
  if (!xs) {
    return 0;
  }
  if (snputxstr(buf, len, xs) == len) {
    return 0;
  }
  return buf;
}

int priv_dic_add_entry(char *yomi, char *word, char *wt_name, int freq)
{
  wtype_t wt;
  xstr *xs;
  int nr;
  if (select_section("PRIVATEDIC", 1) == -1) {
    return -1;
  }
  xs = cstr_to_xstr(yomi);
  if (select_column(xs, 1) == -1) {
    free_xstr(xs);
    return -1;
  }
  
  free_xstr(xs);
  nr = get_nr_values();
  xs = cstr_to_xstr(word);
  set_nth_xstr(nr, xs);
  free_xstr(xs);
  xs = cstr_to_xstr(wt_name);
  set_nth_xstr(nr+1, xs);
  free_xstr(xs);
  set_nth_value(nr + 2, freq);
  mark_column_used();
  return 0;
}

char *dic_util_get_anthydir()
{
  return conf_get_str("ANTHYDIR");
}
