/*
 * ΥץIPAΤǤĤޤ
 */
/*
 * ؽΥҥȥ
 *
 * ֥ѥȥꥷȥ饤פȤǡ¤ѤƤ롣
 * θʤɤ򰷤äƤ붵ʽ򻲾ȤΤ
 */
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <alloc.h>
#include <conf.h>
#include <ruleparser.h>
#include <record.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>

#include "dic_personality.h"

/*  */
struct record_val{
  int type;
  union {
    xstr str;
    int val;
    xstr* strp;
  } u;
};

enum {
  RT_EMPTY, RT_VAL, RT_XSTR, RT_XSTRP
};

/*  */
struct record_column{
  xstr key;
  int nr_vals;
  struct record_val *vals;
};

/*  */
struct trie_node{
  struct trie_node *l;
  struct trie_node *r;
  int bit;
  struct record_column column;
  struct trie_node *prev, *next; /* ξü롼 */
  struct trie_node *lru_prev, *lru_next; /* ξü롼 */
  int dirty; /* LRU Τ used, sused ӥå */
};

struct trie_root{
  struct trie_node root;
  allocator node_ator;
};
#define LRU_USED  0x01
#define LRU_SUSED 0x02
#define PROTECT   0x04 /* ʬ񤭽Ф˻Ȥ(LRUȤϴطʤ)
			*   ʬ񤭽ФǤϡե˽񤭽Ф
			*   ե¾ΥץϿ
			*   ɤ߹ࡣˤäơ줫ɲä
			*   ȤΡɤäΤɤ
			*/
/*
 * LRU:
 *   USED:  ǻȤ줿
 *   SUSED: ¸줿 used ӥå
 *
 * LRUꥹȾǤϡ USED ɬꥹƬ¤Ǥ뤬 SUSED 
 * ե饰ʤΥΡɤȺߤƤǽ롣
 *
 * nĤĤ褦˻ꤵ줿ư
 *    1. used > n
 *        LRU ꥹȤƬ n ܰʹߤä
 *    2. used + sused > n
 *        used -> Ĥ
 *        sused -> sused ե饰
 *        ʳ -> ä
 *    3. ʳ
 *        ƻĤ
 * ե˽񤭽Фˡ used || sused -> sused Ȥƽ񤭽Ф
 */

/*  */
struct record_section{
  char *name;
  struct trie_root cols;
  struct record_section *next;
  int lru_nr_used, lru_nr_sused; /* LRU  */
};

/* ǡ١ */
struct record_stat{
  struct record_section section;
  struct record_section *cur_section;
  struct trie_root xstrs; /* xstr  intern 뤿 trie */
  struct trie_node *cur_column;
  int column_dirty; /* cur_column ¸ɬפ뤫 */
  char *id;         /* ѡʥƥid */
  char *file_name1; /* ܥե ۡǥ쥯ȥ꤫Хѥ */
  char *file_name2; /* ʬե ۡǥ쥯ȥ꤫Хѥ */
  int fd_lock;      /* ʬեåѤΥեǥץ */
  int last_update;  /* ʬեκǸɤ */
  time_t timestamp; /* ܥեΥॹ */
};

#define FILE2_LIMIT 4096

/*
 * xstr  intern:
 *  Ŀͤ( record_stat )ʸ intern 롣ϡ
 *  ¾ˡǡ١ flush ˥ǡ١
 *  ͳ褹 xstr ̵ˤʤΤɤŪ롣
 *  äơǡ١ flush Ǥ xstr  intern 
 *  Υǡ١ xstrs ϤΤޤ¸롣
 *  
 *  xstrs: xstr  intern ѤΥǡ١
 *         column  key  intern 줿 xstr ȤƻȤ
 *         column  value ϻʤ
 *                    (Ūˤϻȥ󥿤ĤƤ⤤)
 *  : intern_xstr()
 */

/*
 * ʬ񤭽Ф:
 *  ǡ١¸ʣ anthy 饤֥󥯤
 *  ץγؽƱΤˡؽι
 *  ե˽񤭽Ф
 *
 * ܥե  Ť anthy γؽƱ
 *                 ʬŬѤ븵Ȥʤե롣
 *                 Ūˤϵưɤ߹ࡣ
 *                 Υץǥե1ȸƤ֤Ȥ롣
 * ʬե  ܥեФ빹
 *                 ǡ١Ф빹ߥåȤ뤿Ӥ
 *                 ɤ߽񤭤롣
 *                 Υץǥե2ȸƤ֤Ȥ롣
 *  :
 *     ǡ١Ф빹ߥåȤȡޤʬե
 *     ¾Υץɲäɤ߹ߡθ˼ʬ
 *     ߥåȤʬե˽񤭽Ф
 *     ϥåեѤƥȥߥå˹Ԥ롣ޤ
 *     ܥե롢ʬեȤ⡢åäƤ֤
 *     ץ󤷤ƤƤϤʤ
 *  ɲäȺ:
 *     ɲäϤǤ˥ǹ줿 column 򥳥ߥåȤˤä
 *     ˽񤭽Фᡢ
 *       1. ߥåо column ʳʬեξ
 *       2. ߥåо column ʬե˽񤭽Ф
 *     Ȥ롣Ϥޤ column ĤäƤ֤ǥߥå
 *     Ԥ(׵򥳥ߥåȤȤư)ᡢ
 *       1. ξʬե˽񤭽Ф
 *       2. ʬեɤ߹ߤˤ׵¹Ԥ
 *     Ȥ롣
 *  ܥեι:
 *     ʬե뤬粽ȡʬեξ
 *     ܥեȿǤƺʬեˤ롣
 *     ץ:
 *       ʬե˽񤭽ФԤä塢ʬե礭Ĵ١
 *       粽ƤСΤȤΥΥǡ١(ˤ
 *       ƤκʬեιŬѤƤ)ܥե
 *       񤭽Ф
 *     ʳΥץ:
 *       ʬեɤˡܥե뤬Ƥ뤫
 *       եΥॹפĴ١ƤСߥå
 *       줿ľ˹եɲä
 *       ǡ١ flush ܥե롢ʬե
 *       ɤ߹ľ
 *       ǡ١ flush ˤꡢ 
 *           cur_column ̵ˤʤ (NULL ˤʤ)
 *           cur_section ͭ¸(sectionϲʤ)
 *           xstr  intern Ƥ¸
 *                              (٤Ƥ xstr  intern ƤϤ)
 *   ɡͤˤʤ:
 *     if (ܥե뤬Ƥ) {
 *             ʬեإߥåȤ줿񤭽Ф;
 *             ǡ١Υեå;
 *             ܥեɹȺʬեκǽɹ֥ꥢ;
 *             ʬեɹȺʬեκǽɹֹ;
 *     } else {
 *             if (ɲ) {
 *                     ʬեɹȺʬեκǽɹֹ;
 *                     ʬեؤν񤭽Ф;
 *             } else {
 *                     ʬեؤν񤭽Ф;
 *                     ʬեɹȺʬեκǽɹֹ;
 *             }
 *     }
 *     if (ʬե뤬礭) {
 *             ܥեؤν񤭽Ф;
 *             ʬեΥꥢ;
 *     }
 */

static allocator record_ator;

/* wrapped functions */
static struct record_section*
do_select_section(struct record_stat *rst, char *name, int flag);
static struct trie_node*
do_select_longest_column(struct record_section *rsc, xstr *name);
static struct trie_node*
do_select_column(struct record_section *rsc, xstr *name, int flag, int dirty);
static void do_set_nth_value(struct trie_node* node, int nth, int val);
static void do_set_nth_xstr(struct trie_node *node, int nth, xstr *xs,
			    struct trie_root* xstrs);
static int do_get_nr_values(struct trie_node *node);
static int do_get_nth_value(struct trie_node *node, int n);
static xstr *do_get_nth_xstr(struct trie_node *node, int n);
static void do_truncate_column(struct trie_node* node, int n);
static void 
do_remove_column(struct record_section* rsc, struct trie_node* node);
static struct trie_node* do_select_first_column(struct record_section *rsc);
static struct trie_node* do_select_next_column(struct record_section *rsc,
					       struct trie_node* node);
static xstr *do_get_index_xstr(struct record_stat *);
static void do_truncate_section(struct record_stat *s, int count);
static void
do_mark_column_used(struct record_stat* rst, 
		    struct record_section* rsc, struct trie_node* node);

/* functions */
static xstr* intern_xstr(struct trie_root* xstrs, xstr* xs);
static void sync_add(struct record_stat* rst, struct record_section* rsc, 
		     struct trie_node* node);
static void
sync_del_and_del(struct record_stat* rst, struct record_section* rsc, 
		 struct trie_node* node);
static void lock_record(struct record_stat* rs);
static void unlock_record(struct record_stat* rs);
static void update_record(struct record_stat* rs);
static void update_base_record(struct record_stat* rst);
static int check_base_record(struct record_stat *rst);
static void read_base_record(struct record_stat *);
static void read_session(struct record_stat *);
static void check_anthy_dir();
static void save_a_column(FILE *fp, struct record_column *, int);
static FILE *fopen_in_recorddir(char *, char *);
static void update_session_file();
static void free_record(struct record_stat *);
static void free_section(struct record_stat *r, struct record_section *rs);
static struct record_val *get_nth_val_ent(struct trie_node *, int, 
					  int create_if_not_exist);
static void record_dtor(void *);
static void free_val_contents(struct record_val* v);

/* trie */
static void init_trie_root(struct trie_root *n);
static int trie_key_nth_bit(xstr* key, int n);
static int trie_key_first_diff_bit_1byte(xchar c1, xchar c2);
static int trie_key_first_diff_bit(xstr *k1, xstr *k2);
static int trie_key_cmp(xstr *k1, xstr *k2);
static void trie_key_dup(xstr *dst, xstr *src);
static void trie_column_init(struct record_column *rc);
static void trie_column_free(struct record_column *rc);
static struct trie_node *trie_find(struct trie_root *root, xstr *key);
static struct trie_node *trie_insert(struct trie_root *root, xstr *key,
				     int dirty, int *nr_used, int *nr_sused);
static void trie_remove(struct trie_root *root, xstr *key,
			int *nr_used, int *nr_sused);
static struct trie_node *trie_first(struct trie_root *root);
static struct trie_node *trie_next(struct trie_root *root,
				   struct trie_node *cur);
static void trie_remove_all(struct trie_root *root,
			    int *nr_used, int *nr_sused);
static void trie_remove_old(struct trie_root *root, int count,
			    int* nr_used, int* nr_sused);
static void trie_mark_used(struct trie_root *root, struct trie_node *n,
			   int *nr_used, int *nr_sused);


/* 
   ȥ饤μ
   struct trie_nodeΤcolumnʳʬcolumn.key
   λtrie_column_freeȤäcolumnƤ
*/

#define PUTNODE(x) ((x) == &root->root ? printf("root\n") : putxstrln(&(x)->column.key))
int debug_trie_dump(FILE* fp, struct trie_node* n)
{
  int cnt = 0;
  char buf[1024];

  if (n->l->bit > n->bit)
    cnt = debug_trie_dump(fp, n->l);
  else {
    if (n->l->column.key.len == -1) {
      if (fp)
	fprintf(fp, "root\n");
    } else {
      if (fp) {
	sputxstr(buf, &n->l->column.key);
	fprintf(fp, "%s\n", buf);
      }
      cnt = 1;
    }
  }

  if (n->r->bit > n->bit)
    return cnt + debug_trie_dump(fp, n->r);
  else {
    if (n->r->column.key.len == -1) {
      if(fp) 
	fprintf(fp, "root\n");
    } else {
      if(fp) {
	sputxstr(buf, &n->r->column.key);
	fprintf(fp, "%s\n", buf);
      }
      return cnt + 1;
    }
  }

  return cnt;
}

void init_trie_root(struct trie_root *root)
{
  struct trie_node* n;
  root->node_ator = create_allocator(sizeof(struct trie_node), NULL);
  n = &root->root;
  n->l = n;
  n->r = n;
  n->bit = 0;
  n->prev = n;
  n->next = n;
  n->lru_next = n;
  n->lru_prev = n;
  n->dirty = 0;
  trie_column_init(&n->column);
  n->column.key.len = -1;
}

/* bit0: 0
   bit1: headΥ0
   bit2: ʸΥӥå0
   bit3: ʸΥӥå1
    ...
   ʸĹۤ0
 */
int trie_key_nth_bit(xstr* key, int n)
{
  switch (n) {
  case 0:
    return 0;
  case 1:
    return key->len + 1; /* key->len == -1 ? 0 : non-zero */
  default:
    {
      int pos;
      n -= 2;
      pos = n / (sizeof(xchar) << 3);
      if (pos >= key->len)
	return 0;
      return key->str[pos] & (1 << (n % (sizeof(xchar) << 3)));
    }
  }
}

/* c1 == c2 ǤϸƤǤϤʤ */
int trie_key_first_diff_bit_1byte(xchar c1,xchar c2)
{
  int i;
  int ptn;
  for (i = 0, ptn = c1 ^ c2; !(ptn & 1); i++, ptn >>= 1 )
    ;
  return i;
}

/* k1 == k2 ǤϸƤǤϤʤ
   ki->str[0 .. (ki->len - 1)]0ϤʤȲ
 */
#define MIN(a,b) ((a)<(b)?(a):(b))
int trie_key_first_diff_bit(xstr *k1, xstr *k2)
{
  int len;
  int i;

  len = MIN(k1->len, k2->len);
  if (len == -1) {
    return 1;
  }
  for ( i = 0 ; i < len ; i++ ){
    if (k1->str[i] != k2->str[i]) {
      return (2 + (i * (sizeof(xchar) << 3)) + 
	      trie_key_first_diff_bit_1byte(k1->str[i], k2->str[i]));
    }
  }
  if (k1->len < k2->len) {
    return (2 + (i * (sizeof(xchar) << 3)) +
	    trie_key_first_diff_bit_1byte(0, k2->str[i]));
  } else {
    return (2 + (i * (sizeof(xchar) << 3)) +
	    trie_key_first_diff_bit_1byte(k1->str[i], 0));
  }
}
#undef MIN

int trie_key_cmp(xstr *k1, xstr *k2)
{
  if (k1->len == -1 || k2->len == -1) {
    return k1->len - k2->len;
  }
  return xstrcmp(k1, k2);
}

void trie_key_dup(xstr *dst, xstr *src)
{
  dst->str = xstr_dup_str(src);
  dst->len = src->len;
}

/* Ĥʤ 0 */
struct trie_node *trie_find(struct trie_root *root, xstr *key)
{
  struct trie_node *p;
  struct trie_node *q;

  p = &root->root;
  q = p->l;
  while (p->bit < q->bit) {
    p = q;
    q = trie_key_nth_bit(key, p->bit) ? p->r : p->l;
  }
  return trie_key_cmp(&q->column.key,key) ? 0 : q; 
}

/*
 * ĹޥåΤؿ
 *  key õơϤưפʤʤäΡɤ֤
 */
struct trie_node *trie_find_longest(struct trie_root* root, xstr *key)
{
  struct trie_node *p;
  struct trie_node *q;

  p = &root->root;
  q = p->l;
  while (p->bit < q->bit) {
    p = q;
    q = trie_key_nth_bit(key, p->bit) ? p->r : p->l;
  }

  return q;
}

/* 
   ɲäΡɤ֤
   ǤƱĥΡɤȤϡɲä0֤
*/
struct trie_node *trie_insert(struct trie_root *root, xstr *key, int dirty,
			      int *nr_used, int *nr_sused)
{
  struct trie_node *n;
  struct trie_node *p;
  struct trie_node *q;
  int i;

  p = &root->root;
  q = p->l;
  while (p->bit < q->bit) {
    p = q;
    q = trie_key_nth_bit(key, p->bit) ? p->r : p->l;
  }
  if (trie_key_cmp(&q->column.key,key) == 0) {
    /* USED > SUSED > 0 ǶĤ */
    if (dirty == LRU_USED)
      trie_mark_used(root, q, nr_used, nr_sused);
    else if (q->dirty == 0)
      q->dirty = dirty;
    return 0;
  }
  i = trie_key_first_diff_bit(&q->column.key, key);
  p = &root->root;
  q = p->l;
  while (p->bit < q->bit && i > q->bit) {
    p = q;
    q = trie_key_nth_bit(key, p->bit) ? p->r : p->l;
  }
  n = smalloc(root->node_ator);
  trie_column_init(&n->column);
  trie_key_dup(&n->column.key, key);
  n->bit = i;
  if (trie_key_nth_bit(key, i)) {
    n->l = q;
    n->r = n;
  } else {
    n->l = n;
    n->r = q;
  }
  if (p->l == q) {
    p->l = n;
  } else {
    p->r = n;
  }
  if (trie_key_cmp(&q->column.key, key) > 0) {
    n->prev = q;
    n->next = q->next;
    q->next = n;
    n->next->prev = n;
  } else {
    n->next = q;
    n->prev = q->prev;
    q->prev = n;
    n->prev->next = n;
  }

  /* LRU ν */
  if (dirty == LRU_USED) {
    root->root.lru_next->lru_prev = n;
    n->lru_prev = &root->root;
    n->lru_next = root->root.lru_next;
    root->root.lru_next = n;
    (*nr_used)++;
  } else {
    root->root.lru_prev->lru_next = n;
    n->lru_next = &root->root;
    n->lru_prev = root->root.lru_prev;
    root->root.lru_prev = n;
    if (dirty == LRU_SUSED) {
      (*nr_sused)++;
    }
  }
  n->dirty = dirty;
  return n;
}

/* 
   Ρɤ򸫤ĤȺ
   trie_column_freeƤӡޤǡʬfree

   ǡȥΡɤ롣
   оݤΥǡϺоݤΥΡɤ˳ǼƤȤ
   ¤ʤȤա
   1. оݤդĥΡɤ˺оݤդޤޤƤȤ
        оݤΥΡɤϡҤؤλޤΤΤޤƤϤƻ
   2. оݤդĥΡɤ˺оݤդޤޤƤȤ
        1. ˲äơоݤդĥΡɤ򻦤ơ˺
	оݤΥΡɤоݤդĥΡɤΰ֤˰ư
*/
void trie_remove(struct trie_root *root, xstr *key, 
		 int *nr_used, int *nr_sused)
{
  struct trie_node *p;
  struct trie_node *q;
  struct trie_node **pp = NULL; /* gcc  warning  */
  struct trie_node **qq;
  p = &root->root;
  qq = &p->l;
  q = *qq;
  while (p->bit < q->bit) {
    pp = qq;
    p = q;
    qq = trie_key_nth_bit(key,p->bit) ? &p->r : &p->l;
    q = *qq;
  }
  if (trie_key_cmp(&q->column.key, key) != 0) {
    return ;
  }
  if (p != q) {
    /* case 2. */
    struct trie_node *r;
    struct trie_node *s;
    r = &root->root;
    s = r->l;
    while (s != q) {
      r = s;
      s = trie_key_nth_bit(key, r->bit) ? r->r : r->l;
    }
    *pp = (p->r == q) ? p->l : p->r;
    p->l = q->l;
    p->r = q->r;
    p->bit = q->bit;
    if (trie_key_nth_bit(key, r->bit)) {
      r->r = p;
    } else {
      r->l = p;
    }
    p = q;
  } else {
    *pp = (p->r == q) ? p->l : p->r;
  }
  p->prev->next = p->next; 
  p->next->prev = p->prev;
  p->lru_prev->lru_next = p->lru_next;
  p->lru_next->lru_prev = p->lru_prev;
  if (p->dirty == LRU_USED) {
    (*nr_used)--;
  } else if (p->dirty == LRU_SUSED) {
    (*nr_sused)--;
  }
  trie_column_free(&p->column);
  sfree(root->node_ator, p);
}

/* headʳΥΡɤʤ 0 ֤ */
struct trie_node *trie_first(struct trie_root *root)
{
  return root->root.next == &root->root ? NULL : root->root.next;
}

/* ΥΡɤʤ 0 ֤ */
struct trie_node *trie_next(struct trie_root *root, struct trie_node *cur)
{
  return cur->next == &root->root ? 0 : cur->next;
}

/* headʳƤΥΡɤ
   trie_column_freeƤӡޤǡʬfree
 */
void trie_remove_all(struct trie_root *root, int *nr_used, int *nr_sused)
{
  struct trie_node* p;
  for (p = root->root.next; p != &root->root; p = p->next)
    trie_column_free(&p->column);
  free_allocator(root->node_ator);
  init_trie_root(root);
  *nr_used = 0;
  *nr_sused = 0;
}

/*
 * LRU ꥹȤƬ count ܤޤǤĤƻĤ
 */
void trie_remove_old(struct trie_root *root, int count, 
		     int *nr_used, int *nr_sused)
{
  struct trie_node *p;
  struct trie_node *q;

  if (*nr_used > count) {
    for (p = root->root.lru_next; count; count--, p = p->lru_next)
      ;
    /* p  head ޤǤä */
    for ( ; p != &root->root; p = q) {
      q = p->lru_next;
      trie_remove(root, &p->column.key, nr_used, nr_sused);
    }
  } else if (*nr_used + *nr_sused > count) {
    for (p = root->root.lru_next; p->dirty == LRU_USED; p = p->lru_next)
      ; 
    /* p  root ޤ  sused    -> dirty := 0
     *                   ʳ -> ä
     */
    for ( ; p != &root->root; p = q) {
      q = p->lru_next;
      if (p->dirty == LRU_SUSED) {
	p->dirty = 0;
      } else {
	trie_remove(root, &p->column.key, nr_used, nr_sused);
      }
    }
    *nr_sused = 0;
  }
}      

void trie_mark_used(struct trie_root *root, struct trie_node *n,
		    int *nr_used, int *nr_sused)
{
  switch(n->dirty) {
  case LRU_USED:
    break;
  case LRU_SUSED:
    (*nr_sused)--;
    /* fall through */
  default:
    n->dirty = LRU_USED;
    (*nr_used)++;
    break;
  }
  n->lru_prev->lru_next = n->lru_next;
  n->lru_next->lru_prev = n->lru_prev;
  root->root.lru_next->lru_prev = n;
  n->lru_next = root->root.lru_next;
  root->root.lru_next = n;
  n->lru_prev = &root->root;
}

FILE *fopen_in_recorddir(char *fn, char *mode)
{
  char *pn;
  char *hd;
  hd = conf_get_str("HOME");
  pn = alloca(strlen(hd)+strlen(fn) + 10);
  strcpy(pn, hd);
  strcat(pn, "/.anthy/");
  strcat(pn, fn);
  return fopen(pn, mode);
}

/* Wrappers begin.. */
int select_section(char *name, int flag)
{
  struct record_stat* rst;
  struct record_section* rsc;
  rst = gCurrentPersonality->record;
  if (rst->column_dirty && rst->cur_section && rst->cur_column)
    sync_add(rst, rst->cur_section, rst->cur_column);
  rst->cur_column = NULL;
  rst->column_dirty = 0;
  rsc = do_select_section(rst, name, flag);
  if (!rsc)
    return -1;
  rst->cur_section = rsc;
  return 0;
}

int select_column(xstr *name, int flag)
{
  struct record_stat* rst;
  struct trie_node* node;

  rst = gCurrentPersonality->record;
  if (!rst->cur_section)
    return -1;
  
  if (rst->column_dirty && rst->cur_column) {
    sync_add(rst, rst->cur_section, rst->cur_column);
    rst->column_dirty = 0;
  }
  node = do_select_column(rst->cur_section, name, flag, LRU_USED);
  if (!node)
    return -1;
  rst->cur_column = node;
  rst->column_dirty = flag;
  return 0;
}

int select_longest_column(xstr *name)
{
  struct record_stat* rst;
  struct trie_node* node;

  rst = gCurrentPersonality->record;
  if (!rst->cur_section)
    return -1;

  if (rst->column_dirty && rst->cur_column) {
    sync_add(rst, rst->cur_section, rst->cur_column);
    rst->column_dirty = 0;
  }
  node = do_select_longest_column(rst->cur_section, name);
  if (!node)
    return -1;

  rst->cur_column = node;
  rst->column_dirty = 0;
  return 0;
}

void truncate_section(int count)
{
  do_truncate_section(gCurrentPersonality->record, count);
}

int mark_column_used(void)
{
  struct record_stat* rst;

  rst = gCurrentPersonality->record;
  if (!rst->cur_column)
    return -1;

  do_mark_column_used(rst, rst->cur_section, rst->cur_column);
  sync_add(rst, rst->cur_section, rst->cur_column);
  rst->column_dirty = 0;
  return 0;
}

void set_nth_value(int nth, int val)
{
  struct record_stat* rst;

  rst = gCurrentPersonality->record;
  if (!rst->cur_column)
    return;
  do_set_nth_value(rst->cur_column, nth, val);
  rst->column_dirty = 1;
}

void set_nth_xstr(int nth, xstr *xs)
{
  struct record_stat* rst;

  rst = gCurrentPersonality->record;
  if (!rst->cur_column)
    return;
  do_set_nth_xstr(rst->cur_column, nth, xs, &rst->xstrs);
  rst->column_dirty = 1;
}

int get_nr_values()
{
  return do_get_nr_values(gCurrentPersonality->record->cur_column);
}

int get_nth_value(int n)
{
  return do_get_nth_value(gCurrentPersonality->record->cur_column, n);
}

xstr *get_nth_xstr(int n)
{
  return do_get_nth_xstr(gCurrentPersonality->record->cur_column, n);
}

int select_first_column()
{
  struct record_stat* rst;
  struct trie_node* node;

  rst = gCurrentPersonality->record;
  if (!rst->cur_section)
    return -1;
  
  if (rst->column_dirty && rst->cur_column) {
    sync_add(rst, rst->cur_section, rst->cur_column);
    rst->column_dirty = 0;
  }
  node = do_select_first_column(rst->cur_section);
  if (!node)
    return -1;
  rst->cur_column = node;
  rst->column_dirty = 0;
  return 0;
}

int select_next_column()
{
  struct record_stat* rst;
  struct trie_node* node;

  rst = gCurrentPersonality->record;
  if (!rst->cur_section || !rst->cur_column)
    return -1;
  
  /* sync_add()  cur_column ̵ˤʤ뤳ȤΤǡ
   * Ȥ column_dirty Ǥ sync_add() ʤ
   */
  rst->column_dirty = 0;
  node = do_select_next_column(rst->cur_section, rst->cur_column);
  if (!node)
    return -1;
  rst->cur_column = node;
  rst->column_dirty = 0;
  return 0;
}

xstr *get_index_xstr()
{
  return do_get_index_xstr(gCurrentPersonality->record);
}
/*..Wrappers end*/

xstr *do_get_index_xstr(struct record_stat *rec)
{
  if (!rec->cur_column) {
    return 0;
  }
  return &rec->cur_column->column.key;
}

struct record_section*
do_select_section(struct record_stat *rst, char *name, int flag)
{
  struct record_section *rsc;

  for (rsc = rst->section.next; rsc; rsc = rsc->next)
    if (!strcmp(name, rsc->name))
      return rsc;

  if (flag) {
    rsc = malloc(sizeof(struct record_section));
    rsc->name = strdup(name);
    rsc->next = rst->section.next;
    rst->section.next = rsc;
    rsc->lru_nr_used = 0;
    rsc->lru_nr_sused = 0;
    init_trie_root(&rsc->cols);
    return rsc;
  }

  return NULL;
}

struct trie_node* 
do_select_longest_column(struct record_section *rsc, xstr *name)
{
  struct trie_node *mark, *found;
  xstr xs;
  int i;

  mark = trie_find_longest(&rsc->cols, name);
  xs.str = name->str;
  for (i = mark->column.key.len; i > 1; i--) {
    /* 롼ȥΡɤ i == 1 ǥޥåΤǽ
     * trie_key_nth_bit 
     */
    xs.len = i;
    found = trie_find(&rsc->cols, &xs);
    if (found)
      return found;
  }
  return NULL;
}

struct trie_node* 
do_select_column(struct record_section* rsc, xstr *name, int flag, int dirty)
{
  struct trie_node *node;

  if (flag) {
    node = trie_insert(&rsc->cols, name, dirty,
		       &rsc->lru_nr_used, &rsc->lru_nr_sused);
    if (node) {
      node->column.nr_vals = 0;
      node->column.vals = 0;
    } else {
      node = trie_find(&rsc->cols, name);
    }
  } else {
    node = trie_find(&rsc->cols, name);
  }
  return node;
}

void do_mark_column_used(struct record_stat* rst, 
			 struct record_section* rsc, struct trie_node* node)
{
  trie_mark_used(&rsc->cols, node, &rsc->lru_nr_used, &rsc->lru_nr_sused);
}

void do_truncate_section(struct record_stat *s, int count)
{
  if (!s->cur_section) {
    return;
  }
#if 0
{
  FILE* fp;
  int nxstr;
  fp = fopen("debug", "w");
  nxstr = debug_trie_dump(fp, &s->xstrs);
  printf("truncate: %s (xstr = %d)", s->cur_section->name, nxstr);
  printf("  count %d used %d sused %d\n", count, 
	 s->cur_section->lru_nr_used,
	 s->cur_section->lru_nr_sused);
  fclose(fp);
}
#endif
  trie_remove_old(&s->cur_section->cols, count,
		  &s->cur_section->lru_nr_used,
		  &s->cur_section->lru_nr_sused);
}


struct trie_node* do_select_first_column(struct record_section *rsc)
{
  return trie_first(&rsc->cols);
}

struct trie_node* do_select_next_column(struct record_section *rsc, 
					struct trie_node* node)
{
  return trie_next(&rsc->cols, node);
}

/*
 * trie_column_init ϲǤ⤤
 */
void trie_column_init(struct record_column* rc)
{
  rc->nr_vals = 0;
  rc->vals = NULL;
}

void trie_column_free(struct record_column *rc)
{
  int i;
  for (i = 0; i < rc->nr_vals; i++)
    free_val_contents(rc->vals + i);
  free(rc->vals);
  free(rc->key.str);
}  

/* 륻ΥǡƲ */
void free_section(struct record_stat *r, struct record_section *rs)
{
  struct record_section *s;
  trie_remove_all(&rs->cols, &rs->lru_nr_used, &rs->lru_nr_sused);
  if (r->cur_section == rs) {
    r->cur_column = 0;
    r->cur_section = 0;
  }
  for (s = &r->section; s && s->next; s = s->next) {
    if (s->next == rs) {
      s->next = s->next->next;
    }
  }
  if (rs->name){
    free(rs->name);
  }
  free(rs);
}

/* ٤ƤΥǡ */
void free_record(struct record_stat *rst)
{
  struct record_section *rsc;
  for (rsc = rst->section.next; rsc; ){
    struct record_section *tmp;
    tmp = rsc;
    rsc = rsc->next;
    free_section(rst, tmp);
  }
  rst->section.next = NULL;
}

/* Ƥ column  */
void flush_record(struct record_stat* rst)
{
  struct record_section *rsc;
  for (rsc = rst->section.next; rsc; rsc = rsc->next)
    trie_remove_all(&rsc->cols, &rsc->lru_nr_used, &rsc->lru_nr_sused);
  rst->cur_column = NULL;
}

struct record_val *get_nth_val_ent(struct trie_node *node, int n, int f)
{
  struct record_column *col;
  col = &node->column;
  if (n < 0)
    return NULL;
  if (n < do_get_nr_values(node)) {
    return &col->vals[n];
  }
  if (f) {
    int i;
    col->vals = realloc(col->vals, sizeof(struct record_val)*(n + 1));
    for (i = col->nr_vals; i < n+1; i++) {
      col->vals[i].type = RT_EMPTY;
    }
    col->nr_vals = n + 1;
    return &col->vals[n];
  }
  return NULL;
}

int do_get_nr_values(struct trie_node *node)
{
  if (!node)
    return 0;
  return node->column.nr_vals;
}

int do_get_nth_value(struct trie_node *node, int n)
{
  struct record_val *v = get_nth_val_ent(node, n, 0);
  if (v && v->type == RT_VAL) {
    return v->u.val;
  }
  return 0;
}

xstr *do_get_nth_xstr(struct trie_node *node, int n)
{
  struct record_val *v = get_nth_val_ent(node, n, 0);
  if (v) {
    if (v->type == RT_XSTR)
      return &v->u.str;
    else if (v->type == RT_XSTRP)
      return v->u.strp;
  }
  return 0;
}

void free_val_contents(struct record_val* v)
{
  switch (v->type) {
  case RT_XSTR:
    free_xstr_str(&v->u.str);
    break;
  case RT_XSTRP:
  case RT_VAL:
  case RT_EMPTY:
  default:
    break;
  }
}

void do_set_nth_value(struct trie_node *node, int nth, int val)
{
  struct record_val *v = get_nth_val_ent(node, nth, 1);
  if (!v) {
    return ;
  }
  free_val_contents(v);
  v->type = RT_VAL;
  v->u.val = val;
}

void do_set_nth_xstr(struct trie_node *node, int nth, xstr *xs,
		     struct trie_root* xstrs)
{
  struct record_val *v = get_nth_val_ent(node, nth, 1);
  if (!v){
    return ;
  }
  free_val_contents(v);
  v->type = RT_XSTRP;
  v->u.strp = intern_xstr(xstrs, xs);
}

void do_truncate_column(struct trie_node* node, int n)
{
  int i;
  if (n < node->column.nr_vals) {
    for (i = n; i < node->column.nr_vals; i++)
      free_val_contents(node->column.vals + i);
    node->column.vals = realloc(node->column.vals, 
				sizeof(struct record_val)* n);
    node->column.nr_vals = n;
  }
}

void do_remove_column(struct record_section* rsc, struct trie_node* node)
{
  xstr* xs;
  xs = xstr_dup(&node->column.key);
  trie_remove(&rsc->cols, &node->column.key, 
	      &rsc->lru_nr_used, &rsc->lru_nr_sused);
#if 0
  {
    FILE* fp;
    struct trie_node* n;
    char buf[1024];

    fp = fopen("debug", "a");
    n = trie_find(&rsc->cols, xs);
    sputxstr(buf, xs);
    fprintf(fp, "%s => %p\n", buf, n);
    fclose(fp);
  }
#endif
  free_xstr(xs);
}

xstr* intern_xstr(struct trie_root* xstrs, xstr* xs)
{
  struct trie_node* node;
  int dummy;

  node = trie_find(xstrs, xs);
  if (!node) 
    node = trie_insert(xstrs, xs, 0, &dummy, &dummy);
  return &node->column.key;
}

void release_section()
{
  if (!gCurrentPersonality->record->cur_section) {
    return ;
  }
  free_section(gCurrentPersonality->record,
	       gCurrentPersonality->record->cur_section);
  gCurrentPersonality->record->cur_section = 0;
}

void release_column()
{
  struct record_stat* rst;

  rst = gCurrentPersonality->record;
  if (!rst->cur_section || !rst->cur_column)
    return;
#if 0
  {
    FILE* fp;
    char buf[1024];

    fp = fopen("debug", "a");
    sputxstr(buf, &rst->cur_column->column.key);
    fprintf(fp, "release %s\n", buf);
    fclose(fp);
  }
#endif

  rst->column_dirty = 0;
  /* sync_del_and_del Ǻ⤹ */
  sync_del_and_del(rst, rst->cur_section, rst->cur_column);
  rst->cur_column = NULL;
}

void check_anthy_dir()
{
  char *hd;
  char *dn;
  struct stat st;
  hd = conf_get_str("HOME");
  dn = alloca(strlen(hd) + 10);
  strcpy(dn, hd);
  strcat(dn,"/.anthy/");
  if (stat(dn,&st) || !S_ISDIR(st.st_mode)) {
    int r;
    /*fprintf(stderr, "Anthy: Failed to open anthy directory(%s).\n", dn);*/
    r = mkdir(dn, S_IRWXU);
    if (r == -1){
      fprintf(stderr, "Anthy: Failed to create\n");
      return ;
    }
    /*fprintf(stderr, "Anthy: Created\n");*/
    r = chmod(dn, S_IRUSR | S_IWUSR | S_IXUSR);
    if (r == -1) {
      fprintf(stderr, "Anthy: But failed to change permission.\n");
    }
  }
}

void read_session(struct record_stat *r)
{
  char **tokens;
  int nr;
  int s = 0;
  while (!read_line(&tokens, &nr)) {
    if (!strcmp(tokens[0], "---") && nr > 1) {
      s = 1;
      r->cur_section = do_select_section(r, tokens[1], 1);
    }else if (s == 1 && nr > 1) {
      xstr *xs;
      int i;
      int dirty;
      struct trie_node* node;
      if (tokens[0][0] == '-') {
	dirty = 0;
	xs = cstr_to_xstr(&tokens[0][1]);
      } else if (tokens[0][0] == '+') {
	dirty = LRU_SUSED;
	xs = cstr_to_xstr(&tokens[0][1]);
      } else {
	/* ΥեθߴΤ */
	dirty = 0;
	xs = cstr_to_xstr(tokens[0]);
      }
      node = do_select_column(r->cur_section, xs, 1, dirty);
      free_xstr(xs);
      r->cur_column = node;
      for (i = 1; i < nr; i++) {
	if (tokens[i][0] == '"') {
	  char *str;
	  str = strdup(&tokens[i][1]);
	  str[strlen(str) - 1] = 0;
	  xs = cstr_to_xstr(str);
	  free(str);
	  do_set_nth_xstr(r->cur_column, i-1, xs, &r->xstrs);
	  free_xstr(xs);
	}else if (tokens[i][0] == '*') {
	  /* EMPTY entry */
	  get_nth_val_ent(r->cur_column, i-1, 1);
	} else {
	  do_set_nth_value(r->cur_column, i-1, atoi(tokens[i]));
	}
      }
    }
    free_line();
  }
}

void write_string(FILE* fp, char* str)
{
  fprintf(fp, "%s", str);
}

void write_quote_string(FILE* fp, char* str)
{
  char* p;

  for (p = str; *p; p++) {
    if (*p == '\"' || *p == '\\')
      fputc('\\', fp);
    fputc(*p, fp);
  }
}

void write_quote_xstr(FILE* fp, xstr* xs)
{
  char* buf;

  buf = (char*) alloca(xs->len * 2 + 2); /* EUC  */
  sputxstr(buf, xs);
  write_quote_string(fp, buf);
}

void write_number(FILE* fp, int x)
{
  fprintf(fp, "%d", x);
}

void commit_column(struct record_stat* rst, int is_add,
		   char* sname, struct trie_node* node)
{
  char* home;
  char* fname;
  FILE* fp;
  int i;

  home = conf_get_str("HOME");
  fname = (char*) alloca(strlen(home) + strlen(rst->file_name2) + 1);
  sprintf(fname, "%s%s", home, rst->file_name2);
  fp = fopen(fname, "a");
  if (fp == NULL) {
    return;
  }
  if (is_add)
    write_string(fp, "ADD \"");
  else
    write_string(fp, "DEL \"");
  write_quote_string(fp, sname);
  write_string(fp, "\" S\"");
  write_quote_xstr(fp, &node->column.key);
  write_string(fp, "\"");
  if (is_add)
    for (i = 0; i < node->column.nr_vals; i++) {
      switch (node->column.vals[i].type) {
      case RT_EMPTY:
	write_string(fp, " E");
	break;
      case RT_VAL:
	write_string(fp, " N");
	write_number(fp, node->column.vals[i].u.val);
	break;
      case RT_XSTR:
	write_string(fp, " S\"");
	write_quote_xstr(fp, &node->column.vals[i].u.str);
	write_string(fp, "\"");
	break;
      case RT_XSTRP:
	write_string(fp, " S\"");
	write_quote_xstr(fp, node->column.vals[i].u.strp);
	write_string(fp, "\"");
	break;
      }
    }
  write_string(fp, "\n");
  if (is_add)
    rst->last_update = ftell(fp);
  fclose(fp);
}

/*
 * sync_add: ADD ν񤭹
 * sync_del_and_del: DEL ν񤭹ߤȺ
 *   ɤ񤭹ߤˡ¾Υץˤäƥǥ¸줿
 *   ɤ߹ࡣ
 *   ΤȤǡ١եå夹ǽ⤢롣ǡ١
 *   եå夬ȡ cur_column Ƥ xstr ̵ˤʤ롣
 *    cur_section ͭ¸롣
 */
void sync_add(struct record_stat* rst, struct record_section* rsc, 
	      struct trie_node* node)
{
  lock_record(rst);
  if (check_base_record(rst)) {
    commit_column(rst, 1, rsc->name, node);
    read_base_record(rst);
    update_record(rst);
  } else {
    node->dirty |= PROTECT;
    update_record(rst);
    node->dirty &= ~PROTECT;
    commit_column(rst, 1, rsc->name, node);
  }
  if (rst->last_update > FILE2_LIMIT)
    update_base_record(rst);
  unlock_record(rst);
}

void sync_del_and_del(struct record_stat* rst, struct record_section* rsc, 
		      struct trie_node* node)
{
  lock_record(rst);
  commit_column(rst, 0, rsc->name, node);
  if (check_base_record(rst))
    read_base_record(rst);
  update_record(rst);
  if (rst->last_update > FILE2_LIMIT)
    update_base_record(rst);
  unlock_record(rst);
}

void update_session_file()
{
  char *hd, *fn1, *fn2;
  char *sid;
  hd = conf_get_str("HOME");
  sid = conf_get_str("SESSION-ID");
  fn1 = alloca(strlen(hd)+strlen(sid) + 10);
  fn2 = alloca(strlen(hd)+
	       strlen(gCurrentPersonality->record->file_name1) + 1);
  strcpy(fn1, hd);
  strcat(fn1, "/.anthy/");
  strcat(fn1, sid);
  strcpy(fn2, hd);
  strcat(fn2, gCurrentPersonality->record->file_name1);
  if (rename(fn1, fn2)){
    printf("Failed to update record file %s -> %s.\n", fn1, fn2);
  }
}

void save_a_column(FILE *fp, struct record_column *c, int dirty)
{
  int i;
  char *buf = malloc(c->key.len * 2 + 2);
  if (dirty == 0) {
    fputc('-', fp);
  } else {
    fputc('+', fp);
  }    
  sputxstr(buf, &c->key);
  fprintf(fp, "%s ", buf);
  for (i = 0; i < c->nr_vals; i++) {
    struct record_val *val = &c->vals[i];
    switch (val->type) {
    case RT_EMPTY:
      fprintf(fp, "* ");
      break;
    case RT_XSTR:
      buf = realloc(buf, val->u.str.len*2 + 2);
      sputxstr(buf, &val->u.str);
      fprintf(fp, "\"%s\" ", buf);
      abort();
      break;
    case RT_XSTRP:
      buf = realloc(buf, val->u.strp->len*2 + 2);
      sputxstr(buf, val->u.strp);
      fprintf(fp, "\"%s\" ", buf);
      break;
    case RT_VAL:
      fprintf(fp, "%d ", val->u.val);
      break;
    default:
      printf("Faild to save an unkonwn record. (in record.c)\n");
      break;
    }
  }
  fprintf(fp, "\n");
  free(buf);
}

void update_base_record(struct record_stat* rst)
{
  struct record_section *sec;
  struct trie_node *col;
  char *sid;
  FILE *fp;

  check_anthy_dir();
  sid = conf_get_str("SESSION-ID");
  fp = fopen_in_recorddir(sid, "w");
  if (!fp) {
    fprintf(stderr, "Anthy: Failed to open temporaly session file.\n");
    return ;
  }
  for (sec = gCurrentPersonality->record->section.next;
       sec; sec = sec->next) {
    if (!sec->cols.root.next) {
      /*Υ϶*/
      continue;
    }
    fprintf(fp, "--- %s\n", sec->name);
    for (col = trie_first(&sec->cols); col; 
	 col = trie_next(&sec->cols,col)) {
      save_a_column(fp, &col->column, col->dirty);
    }
  }
  fclose(fp);
  update_session_file();
  {
    char* home;
    char* fname;
    struct stat st;

    home = conf_get_str("HOME");
    fname = (char*) alloca(strlen(home) + strlen(rst->file_name1) + 1);
    sprintf(fname, "%s%s", home, rst->file_name1);
    if (stat(fname, &st) == 0)
      rst->timestamp = st.st_mtime;

    fname = (char*) alloca(strlen(home) + strlen(rst->file_name2) + 1);
    sprintf(fname, "%s%s", home, rst->file_name2);
    unlink(fname);
  }
}

/* ɤ߹ߤɬפ -> 1 */
int check_base_record(struct record_stat *rst)
{
  char *pn, *hd;
  struct stat st;
  check_anthy_dir();
  hd = conf_get_str("HOME");/*ۡǥ쥯ȥ*/
  pn = alloca(strlen(hd)+strlen(rst->file_name1) + 1);/*եѥ*/
  strcpy(pn, hd);
  strcat(pn, rst->file_name1);
  if (stat(pn, &st) < 0)
    return 1;
  else if (st.st_mtime != rst->timestamp)
    return 1;
  return 0;
}

/* ޤΥǡ١ɤ߹ */
void read_base_record(struct record_stat *rst)
{
  char *pn, *hd;

  check_anthy_dir();
  hd = conf_get_str("HOME");/*ۡǥ쥯ȥ*/
  pn = alloca(strlen(hd)+strlen(rst->file_name1) + 1);/*եѥ*/
  sprintf(pn, "%s%s",hd, rst->file_name1);
  if (open_file(pn) == 0) {
    struct stat st;

    flush_record(rst);
    read_session(rst);
    close_file();
    if (stat(pn, &st) == 0)
      rst->timestamp = st.st_mtime;
    rst->last_update = 0;
  }
}

void lock_record(struct record_stat* rs)
{
  char* home;
  char* fname;
  check_anthy_dir();
  home = conf_get_str("HOME");
  fname = (char*) alloca(strlen(home) + strlen(rs->file_name2) + 
			 strlen(".lock") + 1);
  sprintf(fname, "%s%s.lock", home, rs->file_name2);
  /* SUN  flock λȤʬΤǡȤꤢ롼פˤ */
  while ((rs->fd_lock = open(fname, O_WRONLY | O_CREAT | O_EXCL, 0600)) < 0) {
    sleep(1);
  }
}

void unlock_record(struct record_stat* rs)
{
  char* home;
  char* fname;
  home = conf_get_str("HOME");
  fname = (char*) alloca(strlen(home) + strlen(rs->file_name2) + 
			 strlen(".lock") + 1);
  sprintf(fname, "%s%s.lock", home, rs->file_name2);

  close(rs->fd_lock);
  unlink(fname);
  rs->fd_lock = -1;
}

/*
 * column format:
 *  COLUMN := OPERATION SECTION KEY VALUE*
 *  OPERATION := "ADD"    (ɲäޤLRU)
 *               "DEL"    ()
 *  SECTION := (ʸ)
 *  KEY     := TD
 *  VALUE   := TD
 *  TD      := TYPE DATA  (򤢤˽)
 *  TYPE    := "S"        (xstr)
 *             "N"        (number)
 *  DATA    := (Ȥ˥ꥢ饤)
 */

char* read_1_token(FILE* fp, int* eol)
{
  int c;
  char* s;
  int in_quote;
  int len;

  in_quote = 0;
  s = NULL;
  len = 0;
  while (1) {
    c = fgetc(fp);
    switch (c) {
    case EOF: case '\n':
      goto out;
    case '\\':
      c = fgetc(fp);
      if (c == EOF || c == '\n')
	goto out;
      break;
    case '\"':
      in_quote = !in_quote;
      continue;
    case ' ': case '\t': case '\r':
      if (in_quote)
	break;
      if (s != NULL)
	goto out;
      break;
    default:
      break;
    }
    
    s = (char*) realloc(s, len + 2);
    s[len++] = c;
  }
out:
  if (s)
    s[len] = '\0';
  *eol = (c == '\n');
  return s;
}

void read_1_column(struct record_stat* rst, FILE* fp)
{
  char* op, * token;
  struct record_section* rsc;
  struct trie_node* node;
  int eol;

  op = read_1_token(fp, &eol);
  if (!op || eol)
    goto end;

  token = read_1_token(fp, &eol);
  if (!token || eol) {
    free(token);
    goto end;
  }
  rsc = do_select_section(rst, token, 1);
  free(token);

  if (strcmp(op, "ADD") == 0) {
    int n;
    xstr* xs;
    
    token = read_1_token(fp, &eol);
    if (!token)
      goto end;

    xs = cstr_to_xstr(token + 1); /* xstr ɽ S ɤ߼ΤƤ */
    node = do_select_column(rsc, xs, 1, LRU_USED);
    free_xstr(xs);
    free(token);

    if (node->dirty & PROTECT) {
      /* ¸٤ column ʤΤǡʬեɤ߼ΤƤ */
      while (!eol)
	free(read_1_token(fp, &eol));
      goto end;
    }

    n = 0;
    while (!eol) {
      token = read_1_token(fp, &eol);
      if (token) {
	switch(*token) {
	case 'S':
	  {
	    xstr* xs;
	    xs = cstr_to_xstr(token + 1);
	    do_set_nth_xstr(node, n, xs, &rst->xstrs);
	    free_xstr(xs);
	  }
	  break;
	case 'N':
	  do_set_nth_value(node, n, atoi(token + 1));
	  break;
	}
	free(token);
	n++;
      }
    }
    do_truncate_column(node, n);
  } else if (strcmp(op, "DEL") == 0) {
    xstr* xs;

    token = read_1_token(fp, &eol);
    if (!token)
      goto end;

    xs = cstr_to_xstr(token + 1); /* xstr ɽ S ɤФ */
    if ((node = do_select_column(rsc, xs, 0, 0)) != NULL)
      do_remove_column(rsc, node);
    free_xstr(xs);
    free(token);
  }

end:
  free(op);
}

void update_record(struct record_stat* rs)
{
  char* home;
  char* fname;
  FILE* fp;

  home = conf_get_str("HOME");
  fname = (char*) alloca(strlen(home) + strlen(rs->file_name2) + 1);
  sprintf(fname, "%s%s", home, rs->file_name2);
  fp = fopen(fname, "r");
  if (fp == NULL) {
    return;
  }
  fseek(fp, rs->last_update, SEEK_SET);
  /* fseek ˼ԤϺǽ餫ɤ߹ */
  while(!feof(fp)) {
    read_1_column(rs, fp);
  }
  rs->last_update = ftell(fp);
  fclose(fp);
}

void record_dtor(void *p)
{
  int dummy;
  struct record_stat *rst = (struct record_stat*) p;
  free_record(rst);
  free(rst->file_name1);
  free(rst->file_name2);
  trie_remove_all(&rst->xstrs, &dummy, &dummy);
}

void init_record()
{
  record_ator = create_allocator(sizeof(struct record_stat),
				 record_dtor);
}

struct record_stat *create_record(char *id)
{
  struct record_stat *rst;
  if (!id) {
    return NULL;
  }

  check_anthy_dir();

  rst = smalloc(record_ator);
  rst->id = id;
  rst->section.next = 0;
  init_trie_root(&rst->xstrs);
  rst->cur_section = 0;
  rst->cur_column = 0;
  rst->column_dirty = 0;
  rst->file_name1 = (char*) malloc(strlen("/.anthy/last-record1_") +
				   strlen(id) + 1);
  sprintf(rst->file_name1, "/.anthy/last-record1_%s", id);
  rst->file_name2 = (char*) malloc(strlen("/.anthy/last-record2_") +
				   strlen(id) + 1);
  sprintf(rst->file_name2, "/.anthy/last-record2_%s", id);
  rst->fd_lock = -1;
  rst->last_update = 0;

  lock_record(rst);
  read_base_record(rst);
  update_record(rst);
  unlock_record(rst);
  return rst;
}

void release_record(struct record_stat *rs)
{
  sfree(record_ator, rs);
}

void save_record(void)
{
  /* empty */
}
