/*
 * ѤΥեɤ߹ߥ롼
 */
#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <conf.h>
#include <ruleparser.h>

/*ʸˡեΥѡѤ*/
#define MAX_TOKEN_LEN 256
/*Υ󥯥롼ɤο*/
#define MAX_INCLUDE_DEPTH 4

#define PS_INIT 0
#define PS_TOKEN 1
#define PS_EOF 2
#define PS_RET 3

#define NL "NL"

static struct parser_stat{
  FILE *fp_stack[MAX_INCLUDE_DEPTH];
  FILE *fp;
  int cur_fpp;/*åΥǥå*/
  int line_num;
  char **tokens;
  int nr_token;
}g_ps;

struct line_stat{
  int stat;
  char buf[MAX_TOKEN_LEN];
  int buf_index;
}ls;

/*ѡ*/
static int mygetc(int *c);
static int myisblank(int c);/*isblankGNUγĥ*/
static void pushchar(struct line_stat *, int);
static char *get_token_in(struct line_stat *);
static int get_line_in();
static void get_line();
static void proc_include();
static void pop_file();

FILE *open_file_in_confdir(char *fn)
{
  char *dn;
  char *full;
  if (!fn) {
    return stdin;
  }
  if (fn[0] == '/') {
    return fopen(fn, "r");
  }
  dn = conf_get_str("ANTHYDIR");
  if (!dn ){
    return 0;
  }
  full = alloca(strlen(dn)+strlen(fn)+2);
  strcpy(full,dn);
  strcat(full,"/");
  strcat(full,fn);
  return fopen(full,"r");
}

int mygetc(int *cc)
{
  *cc = fgetc(g_ps.fp);
  if (*cc == '\\') {
    int c2 = fgetc(g_ps.fp);
    switch(c2) {
    case '\\':
      *cc = '\\';
      return 1;
    case '\n':
      *cc = ' ';
      return 1;
    }
  }
  return 0;
}

int myisblank(int c)
{
  if (c == ' ' || c == '\t') {
    return 1;
  }
  return 0;
}

void pushchar(struct line_stat *ls, int cc)
{
  ls->buf[ls->buf_index] = cc;
  ls->buf_index ++;
}

char *get_token_in(struct line_stat *ls)
{
  int cc, esc;
  if (ls->stat == PS_EOF) {
    return NULL;
  }
  if (ls->stat == PS_RET) {
    return NL;
  }
  /*ɤФ*/
  do {
    esc = mygetc(&cc);
  } while (cc > 0 && myisblank(cc) && esc == 0);
  if (cc == -1) {
    return NULL;
  }
  if (cc == '\n'){
    return NL;
  }
  /**/
  do {
    pushchar(ls, cc);
    esc = mygetc(&cc);
    if (cc < 0){
      pushchar(ls, 0);
      ls->stat = PS_EOF;
      return ls->buf;
    }
    if (cc == '\n') {
      pushchar(ls, 0);
      ls->stat = PS_RET;
      return ls->buf;
    }
  } while (!myisblank(cc));
  pushchar(ls, 0);
  return ls->buf;
}

int get_line_in()
{
  char *t;
  struct line_stat ls;
  ls.stat = PS_INIT;
  do{
    ls.buf_index = 0;
    t = get_token_in(&ls);
    if (!t) {
      return -1;
    }
    if (t == NL) {
      return 0;
    }
    g_ps.nr_token++;
    g_ps.tokens = realloc(g_ps.tokens, sizeof(char *)*g_ps.nr_token);
    g_ps.tokens[g_ps.nr_token-1] = strdup(t);
  } while(1);
}

void proc_include()
{
  FILE *fp;
  if (g_ps.nr_token != 2) {
    printf("Syntax error in include directive.\n");
    return ;
  }
  if (g_ps.cur_fpp > MAX_INCLUDE_DEPTH - 1) {
    printf("Too deep include.\n");
    return ;
  }
  fp = open_file_in_confdir(g_ps.tokens[1]);
  if (!fp) {
    printf("Failed to open %s.\n", g_ps.tokens[1]);
    return ;
  }
  g_ps.cur_fpp++;
  g_ps.fp_stack[g_ps.cur_fpp] = fp;
  g_ps.fp = fp;
}

/*󥯥롼ɤΥͥȤ򲼤*/
void pop_file()
{
  fclose(g_ps.fp);
  g_ps.cur_fpp --;
  g_ps.fp = g_ps.fp_stack[g_ps.cur_fpp];
}

void get_line()
{
  int r;
  
 again:
  free_line();
  g_ps.line_num ++;

  r = get_line_in();
  if (r == -1){
    /*EOFǤʾɤ*/
    if (g_ps.cur_fpp > 0){
      pop_file();
      goto again;
    }else{
      return ;
    }
  }
  if (!g_ps.nr_token) {
    return ;
  }
  if (!strcmp(g_ps.tokens[0], "\\include")) {
    proc_include();
    goto again;
  }else if (!strcmp(g_ps.tokens[0], "\\eof")) {
    if (g_ps.cur_fpp > 0) {
      pop_file();
      goto again;
    }else{
      free_line();
      return ;
    }
  }else if (g_ps.tokens[0][0] == '#'){
    goto again;
  }
}

void free_line()
{
  int i;
  for (i = 0; i < g_ps.nr_token; i++) {
    free(g_ps.tokens[i]);
  }
  free(g_ps.tokens);
  g_ps.tokens = 0;
  g_ps.nr_token = 0;
}

int open_file(char *fn)
{
  g_ps.fp_stack[0] = open_file_in_confdir(fn);
  if (!g_ps.fp_stack[0]) {
    return -1;
  }
  /*ѡξ֤*/
  g_ps.cur_fpp = 0;
  g_ps.fp = g_ps.fp_stack[0];
  g_ps.line_num = 0;
  return 0;
}

void close_file()
{
  if (g_ps.fp != stdin) {
    fclose(g_ps.fp);
  }
}

int read_line(char ***tokens,int *nr)
{
  get_line();
  *tokens = g_ps.tokens;
  *nr = g_ps.nr_token;
  if (!*nr) {
    return -1;
  }
  return 0;
}

int get_line_number()
{
  return g_ps.line_num;
}
