/*
 * ʻ췿
 * Ȥwtype_tΥ쥤Ȥ˶¸롣
 */
#include <stdio.h>
#include <string.h>

#include <wtype.h>
#include "dic_main.h"

wtype_t wt_none, wt_all;

static struct PTab{
  char *name;
  int pos;
  int ct;
  int cst;
  int cc;
  int cos;
  int scos;
}ptab[]={
#include "ptab.h"
};

static struct wttable{
  char *name;
  int cc;
  int pos;
  int cos;
  int scos;
  int ct;/*Ѥʤ*/
  int flags;
}wttab[]={
#include "wtab.h"
};

static struct PTab *get_pos_by_name(char *name)
{
  struct PTab *p;
  for (p = ptab ; p->name ; p++) {
    if (!strcmp(p->name, name)) {
      return p;
    }
  }
  printf("Anthy: unknown name of POS %s\n", name);
  return 0;
}

static struct wttable *get_table_by_name(char *s)
{
  struct wttable *w;
  for (w = &wttab[0]; w->name; w++) {
    if (!strcmp(w->name, s)) {
      return w;
    }
  }
  return 0;
}

void init_wtypes()
{
  wt_all.type[WT_POS] = POS_NONE;
  wt_all.type[WT_CC] = CC_NONE;
  wt_all.type[WT_CT] = CT_NONE;
  wt_all.type[WT_CST] = CST_NONE;
  wt_all.type[WT_COS] = COS_NONE;
  wt_all.type[WT_SCOS] = SCOS_NONE;
  wt_all.type[WT_FLAGS] = WF_NONE;

  wt_none = wt_all;
  wt_none.type[WT_POS] = POS_INVAL;
}

int type_to_wtype(char *s, wtype_t *t)
{
  struct wttable *w;
  t->type[WT_POS] = POS_INVAL;
  if (s[0] != '#') {
    return -1;
  }
  *t = wt_all;
  w = get_table_by_name(s);
  if (!w) {
    return -1;
  }
  t->type[WT_CC] = w->cc;
  t->type[WT_CT] = w->ct;
  t->type[WT_CST] = CST_NONE;
  t->type[WT_POS] = w->pos;
  t->type[WT_COS] = w->cos;
  t->type[WT_SCOS] = w->scos;
  t->type[WT_FLAGS] = w->flags;
  return 0;
}

int name_to_wtype(char *name, wtype_t *w)
{
  struct PTab *p;
  p = get_pos_by_name(name);
  *w = wt_all;
  if (p) {
    wtype_set_pos(w, p->pos);
    wtype_set_ct(w, p->ct);
    wtype_set_cst(w, p->cst);
    wtype_set_cc(w, p->cc);
    wtype_set_cos(w, p->cos);
    wtype_set_scos(w, p->scos);
    return 0;
  }
  printf("Failed to find wtype(%s).\n", name);
  return -1;
}

void print_wtype(wtype_t w)
{
  printf("(%d,%d,%d,%d,%d,%d)\n",
	 w.type[WT_POS],w.type[WT_CT],w.type[WT_CC],
	 w.type[WT_COS],w.type[WT_SCOS],w.type[WT_CST]);
}

/* n  hs ΰɤ */
int wtypecmp(wtype_t hs, wtype_t n)
{
  //printf("POS %d,%d\n", hs.type[WT_POS], n.type[WT_POS]);
  if (hs.type[WT_POS] != POS_NONE &&
      hs.type[WT_POS] != n.type[WT_POS]) {
    return 0;
  }
  if (hs.type[WT_CC] != CC_NONE &&
      hs.type[WT_CC] != n.type[WT_CC]) {
    return 0;
  }
  if (hs.type[WT_CT] != CT_NONE &&
      hs.type[WT_CT] != n.type[WT_CT]) {
    return 0;
  }
  if (hs.type[WT_CST] != CST_NONE &&
      hs.type[WT_CST] != n.type[WT_CST]) {
    return 0;
  }
  if (hs.type[WT_COS] != COS_NONE &&
      hs.type[WT_COS] != n.type[WT_COS]) {
    return 0;
  }
  if (hs.type[WT_SCOS] != SCOS_NONE &&
      hs.type[WT_SCOS] != n.type[WT_SCOS]) {
    return 0;
  }
  return 1;
}

int wtypesame(wtype_t w1, wtype_t w2)
{
  if (w1.type[WT_POS] != w2.type[WT_POS]) {
    return 0;
  }
  if (w1.type[WT_COS] != w2.type[WT_COS]) {
    return 0;
  }
  if ( w1.type[WT_SCOS] != w2.type[WT_SCOS] ){
    return 0;
  }
  if (w1.type[WT_CC] != w2.type[WT_CC]) {
    return 0;
  }
  if (w1.type[WT_CT] != w2.type[WT_CT]) {
    return 0;
  }
  if (w1.type[WT_CST] != w2.type[WT_CST]) {
    return 0;
  }
  return 1;
}

int wtype_get_cc(wtype_t t)
{
  return t.type[WT_CC];
}

int wtype_get_ct(wtype_t t)
{
  return t.type[WT_CT];
}

int wtype_get_cst(wtype_t t)
{
  return t.type[WT_CST];
}

int wtype_get_pos(wtype_t t)
{
  return t.type[WT_POS];
}

int wtype_get_cos(wtype_t t)
{
  return t.type[WT_COS];
}

int wtype_get_scos(wtype_t t)
{
  return t.type[WT_SCOS];
}

int wtype_get_indep(wtype_t t)
{
  return t.type[WT_FLAGS]&WF_INDEP;
}

int wtype_get_meisi(wtype_t w)
{
  return w.type[WT_FLAGS] & WF_MEISI;
}

int wtype_get_5(wtype_t w)
{
  return w.type[WT_FLAGS] & WF_5;
}

int wtype_get_ajv(wtype_t w)
{
  return w.type[WT_FLAGS] & WF_AJV;
}

void wtype_set_cc(wtype_t *w, int cc)
{
  w->type[WT_CC] = cc;
}

void wtype_set_ct(wtype_t *w, int ct)
{
  w->type[WT_CT] = ct;
}

void wtype_set_cst(wtype_t *w, int cst)
{
  w->type[WT_CST] = cst;
}

void wtype_set_pos(wtype_t *w, int pos)
{
  w->type[WT_POS] = pos;
}

void wtype_set_cos(wtype_t *w, int cs)
{
  w->type[WT_COS] = cs;
}

void wtype_set_scos(wtype_t *w, int sc)
{
  w->type[WT_SCOS] = sc;
}

void wtype_set_dep(wtype_t *w, int isDep)
{
  if (isDep) {
    w->type[WT_FLAGS] &= (~WF_INDEP);
  }else{
    w->type[WT_FLAGS] |= WF_INDEP;
  }
}
