/*
 * AnthyΥƥȤФƤƤФ롣
 * ФѴѥץ饤ɬפʥ⥸塼˸ƤӤ
 *
 * personalityδ⤹롣
 *
 * Funded by IPA̤Ƨեȥ¤ 2001 10/29
 */
#include <stdlib.h>
#include <stdio.h>

#include <alloc.h>
#include <record.h>
#include <ordering.h>
#include "main.h"
#include "context.h"

allocator context_ator;

static void pop_back_seg_ent(struct anthy_context *c);
static int get_nth_segment_index(struct anthy_context *c, int sindex);
static void compose_segment_list(struct anthy_context *c, int, int);
static void context_dtor(void *);

void context_dtor(void *p)
{
  struct anthy_context *ac = p;
  set_personality(ac->personality);
  reset_context(ac);
  unref_personality();
}

struct anthy_context *create_context()
{
  struct anthy_context *ac;
  char *p = get_personality();

  if (!p) {
    return 0;
  }

  ref_personality();

  ac = (struct anthy_context *)smalloc(context_ator);
  ac->str.str = 0;
  ac->str.len = 0;
  ac->seg_list.nr_segments = 0;
  ac->seg_list.list_head.prev = &ac->seg_list.list_head;
  ac->seg_list.list_head.next = &ac->seg_list.list_head;
  ac->word_split_info.word_split_info = 0;
  ac->word_split_info.ce = 0;
  ac->dic_session = 0;
  ac->personality = p;

  return ac;
}

void init_contexts()
{
  context_ator = create_allocator(sizeof(struct anthy_context),
				  context_dtor);
}

void quit_contexts()
{
  free_allocator(context_ator);
}

void reset_context(struct anthy_context *c)
{
  int i, sc;
  dic_set_personality(c->personality);
  release_split_context(&c->word_split_info);
  if (c->str.str) {
    free(c->str.str);
    c->str.str = 0;
  }
  sc = c->seg_list.nr_segments;
  for (i = 0; i < sc; i++) {
    pop_back_seg_ent(c);
  }
  c->seg_list.nr_segments = 0;
  if (c->dic_session) {
    dic_release_session(c->dic_session);
    c->dic_session = 0;
  }
}

void release_context(struct anthy_context *c)
{
  sfree(context_ator, c);
}

int context_set_str(struct anthy_context *c, xstr *s)
{
  int i;

  dic_set_personality(c->personality);
  /**/
  reset_context(c);

  /* 񥻥åγ */
  if (!c->dic_session) {
    c->dic_session = dic_create_session();
    if (!c->dic_session) {
      return -1;
    }
  }
  dic_activate_session(c->dic_session);

  /* ʸ򥳥ԡ */
  c->str.str = (xchar *)malloc(sizeof(xchar)*(s->len+1));
  c->str.len = s->len;
  for (i = 0; i < s->len; i++) {
    c->str.str[i] = s->str[i];
  }
  c->str.str[i] = 0;

  /* splitterν*/
  init_split_context(&c->str, &c->word_split_info);

  /* ʸζ */
  mark_border(&c->word_split_info, 0, 0, s->len);

  compose_segment_list(c, 0, s->len);

  /* ꤷʸᶭФƤ */
  for (i = 0; i < c->seg_list.nr_segments; i++) {
    struct seg_ent *s = get_nth_segment(&c->seg_list, i);
    c->word_split_info.ce[s->from].initial_seg_len = s->len;
  }

  /*  */
  for (i = 0; i < c->seg_list.nr_segments; i++) {
    make_candidates(c, get_nth_segment(&c->seg_list, i));
  }

  /* 򥽡 */
  sort_candidate(&c->seg_list, 0);
  return 0;
}

void context_resize_segment(struct anthy_context *c, int nth, int resize)
{
  int i;
  int index, len, sc;

  dic_set_personality(c->personality);
  /*resizeǽ*/
  if (nth >= c->seg_list.nr_segments) {
    return ;
  }
  index = get_nth_segment_index(c, nth);
  len = get_nth_segment_len(c,nth);
  if (index + len + resize > c->str.len) {
    return ;
  }
  if (len + resize < 1) {
    return ;
  }

  /*nthʹߤseg_ent*/
  sc = c->seg_list.nr_segments;
  for (i = nth; i < sc; i++) {
    pop_back_seg_ent(c);
  }

  /*resizeseg_borderޡ*/
  /*ߤΥޡäƿޡĤ*/
  c->word_split_info.ce[index+len].seg_border = 0;
  c->word_split_info.ce[index+len+resize].seg_border = 1;
  c->word_split_info.ce[c->str.len].seg_border = 1;
  for (i = index+len+resize+1; i < c->str.len; i++) {
    c->word_split_info.ce[i].seg_border = 0;
  }
  
  /*word_split򤹤*/
  c->word_split_info.ce[index+len+resize].seg_border = 1;
  /*index  index +len+resizeδ֤˶뤳Ȥػߤ*/
  mark_border(&c->word_split_info, index, index+len+resize, c->str.len);
  compose_segment_list(c, index, c->str.len);

  /**/
  for (i = nth; i < c->seg_list.nr_segments; i++) {
    make_candidates(c, get_nth_segment(&c->seg_list, i));
  }
  /*򥽡*/
  sort_candidate(&c->seg_list, nth);
}

void push_back_segment(struct anthy_context *c, struct seg_ent *s)
{
  s->next = &c->seg_list.list_head;
  s->prev = c->seg_list.list_head.prev;
  c->seg_list.list_head.prev->next = s;
  c->seg_list.list_head.prev = s;
  c->seg_list.nr_segments ++;
  s->commit = -1;
}

int get_nth_segment_index(struct anthy_context *c, int n)
{
  int i,s;
  for (i = 0, s = 0; i < c->str.len; i++) {
    if (c->word_split_info.ce[i].seg_border) {
      if (s == n) {
	return i;
      }
      s++;
    }
  }
  return -1;
}

int get_nth_segment_len(struct anthy_context *c, int sindex)
{
  int a,i,l;
  a = get_nth_segment_index(c, sindex);
  if ( a == -1){
    return -1;
  }
  l = 1;
  for (i = a+1; !c->word_split_info.ce[i].seg_border; i++) {
    l++;
  }
  return l;
}

struct seg_ent *get_nth_segment(struct segment_list *l, int n)
{
  int i;
  struct seg_ent *se;
  if (n >= l->nr_segments) {
    return 0;
  }
  for (i = 0, se = l->list_head.next; i < n; i++, se = se->next);
  return se;
}

void print_context(struct anthy_context *c)
{
  int i;
  struct char_ent *ce;
  ce = c->word_split_info.ce;
  if (!ce) {
    printf("(invalid)\n");
    return ;
  }
  for (i = 0, ce = c->word_split_info.ce; i < c->str.len; i++, ce++) {
    if (ce->seg_border) {
      printf("|");
    }
    putxchar(*(ce->c));
  }
  printf("\n");
  for (i = 0; i < c->seg_list.nr_segments; i++) {
    print_segment(get_nth_segment(&c->seg_list, i));
  }
  printf("\n");
}

void release_cand_ent(struct cand_ent *c)
{
  if (c->elm) {
    free(c->elm);
  }
  free_xstr_str(&c->str);
  free(c);
}

/* ʸꥹȤκǸǤ */
void pop_back_seg_ent(struct anthy_context *c)
{
  struct seg_ent *s;
  s = c->seg_list.list_head.prev;
  if (s == &c->seg_list.list_head) {
    return ;
  }
  s->prev->next = s->next;
  s->next->prev = s->prev;
  if (s->cands) {
    int i;
    for (i = 0; i < s->cand_count; i++) {
      release_cand_ent(s->cands[i]);
    }
    free(s->cands);
  }
  free(s);
  c->seg_list.nr_segments --;
}

/* 
 * splitterˤäդ줿ʸᶭΥޡ顢
 * ʸΥꥹȤ
 */
void compose_segment_list(struct anthy_context *c, int from, int to)
{
  int i,n;
  struct seg_ent *s;
  /**/
  for (i = 0, n = 0; i < from; i += get_nth_segment_len(c, n), n++);
  for (i = from; i < to; i++) {
    if (c->word_split_info.ce[i].seg_border) {
      s = (struct seg_ent *)malloc(sizeof(struct seg_ent));
      s->str.str = &c->str.str[i];
      s->str.len = get_nth_segment_len(c, n);
      s->from = i;
      s->len = s->str.len;
      s->cand_count = 0;
      s->cands = 0;
      push_back_segment(c, s);
      n++;
    }
  }
}
