/*
 * Comments in this program are written in Japanese,
 * because this program is Japanese input method.
 * (many Japanese gramatical terms will appear.)
 *
 * KanaKanji conversion engine Anthy.
 * ̾Ѵ󥸥Anthy(󥷡)
 *
 * Funded by IPA̤Ƨեȥ¤ 2001 9/22
 * Copyright (C) 2000-2001 TABATA Yusuke, UGAWA Tomoharu
 * Copyright (C) 2001 TAKAI Kosuke, Nobuoka Takahiro
 *
 * The source is covered by the GNU GPL.
 */
/*
 * AnthyѴǽϥ饤֥ȤƹƤꡢ
 * Υեˤϥ饤֥󶡤ؿҤƤ롣
 *
 * Ǥϥ饤֥㴳̩˥顼å
 *
 * doc/LIB򻲾ȤΤ
 */
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include <dic.h>
#include <splitter.h>
#include <conf.h>
#include <ordering.h>
#include <anthy.h>
#include "main.h"
#include "context.h"

static int is_init_ok;/* Anthyνλɤ */

static int commit_all_segment_p(struct anthy_context *);

int anthy_init()
{
  if (is_init_ok) {
    /* 2ٽʤ褦 */
    return 0;
  }
  if (init_anthy_dic()) {
    fprintf(stderr, "Anthy: Failed to open dictionary.\n");
    return -1;
  }

  if (init_seg_struct_tab()) {
    fprintf(stderr, "Failed to init segment table.\n");
    return -1;
  }
  if (init_splitter()) {
    fprintf(stderr, "Failed to init splitter.\n");
    return -1;
  }
  init_contexts();
  init_personality();

  is_init_ok = 1;
  return 0;
}

void anthy_quit()
{
  if (!is_init_ok) {
    return ;
  }
  quit_contexts();
  quit_personality();
  quit_splitter();
  /* ¿Υǡ¤ϤallocatorˤäƲ */
  quit_anthy_dic();
}

void anthy_conf_override(char *var, char *val)
{
  conf_override(var, val);
}

int anthy_set_personality(char *id)
{
  return set_personality(id);
}

struct anthy_context *anthy_create_context()
{
  if (!is_init_ok) {
    return 0;
  }
  return create_context();
}

void anthy_reset_context(struct anthy_context *ac)
{
  reset_context(ac);
}

void anthy_release_context(struct anthy_context *ac)
{
  release_context(ac);
}

int anthy_set_string(struct anthy_context *ac, char *s)
{
  xstr *x;
  int retval;
  x = cstr_to_xstr(s);
  retval = context_set_str(ac, x);
  free_xstr(x);
  return retval;
}

void anthy_resize_segment(struct anthy_context *ac, int nth, int resize)
{
  context_resize_segment(ac, nth, resize);
}

int anthy_get_stat(struct anthy_context *ac, struct anthy_conv_stat *s)
{
  s->nr_segment = ac->seg_list.nr_segments;
  return 0;
}

int anthy_get_segment_stat(struct anthy_context *c ,int n ,struct anthy_segment_stat *s)
{
  struct seg_ent *se;
  se = get_nth_segment(&c->seg_list, n);
  if (se) {
    s->nr_candidate = se->cand_count;
    s->seg_len = se->str.len;
    return 0;
  }
  return -1;
}

int anthy_get_segment(struct anthy_context *ac, int nth_seg, int nth_cand, char *buf, int buflen)
{
  struct seg_ent *seg;
  char *p;
  int len;
  if (nth_seg < 0 || nth_seg >= ac->seg_list.nr_segments) {
    return -1;
  }
  seg = get_nth_segment(&ac->seg_list, nth_seg);
  if ((nth_cand < 0 || nth_cand >= seg->cand_count) &&
      nth_cand != NTH_UNCONVERTED_CANDIDATE) {
    return -1;
  }
  if (nth_cand == NTH_UNCONVERTED_CANDIDATE) {
    p = xstr_to_cstr(&seg->str);
  } else {
    p = xstr_to_cstr(&seg->cands[nth_cand]->str);
  }
  len = strlen(p);
  if (!buf) {
    return len;
  }
  if (len + 1 <= buflen) {
    strcpy(buf, p);
    free(p);
    return len;
  }
  free(p);
  return -1;
}

int anthy_commit_segment(struct anthy_context *ac, int s, int c)
{
  struct seg_ent *seg;
  if (!ac->str.str) {
    return -1;
  }
  if (s < 0 || s >= ac->seg_list.nr_segments) {
    return -1;
  }
  if (commit_all_segment_p(ac)) {
    /* ǤƤΥȤߥåȤƤ */
    return -1;
  }
  seg = get_nth_segment(&ac->seg_list, s);
  if (c == NTH_UNCONVERTED_CANDIDATE) {
    int i;
    for (i = 0; i < seg->cand_count; i++) {
      if (!xstrcmp(&seg->str, &seg->cands[i]->str)) {
	c = i;
      }
    }
  }
  if (c < 0 || c >= seg->cand_count) {
    return -1;
  }
  seg->commit = c;
  if (commit_all_segment_p(ac)) {
    /* ٤ƤΥȤߥåȤ줿 */
    proc_commit(&ac->seg_list, &ac->word_split_info);
  }
  return 0;
}

void anthy_print_context(struct anthy_context *ac)
{
  print_context(ac);
}

/* ٤Ƥʸ᤬ߥåȤ줿check */
int commit_all_segment_p(struct anthy_context *ac)
{
  int i;
  struct seg_ent *se;
  for (i = 0; i < ac->seg_list.nr_segments; i++) {
    se = get_nth_segment(&ac->seg_list, i);
    if (se->commit < 0) {
      return 0;
    }
  }
  return 1;
}
