/*
 * personalityȤϡؽʤɤΰʬΥåȤǤ롣
 *
 * personalityδ򤹤롢Υ⥸塼γǤ
 * personalityϥݥ󥿤Ǽ̤Ǥ褦ˤ롣
 *
 * ѡʥƥμ̿Ϥǻȥ󥿤ѤƴΤ
 * 饤֥κȺθƽФϤ餫Ԥ
 *
 * personality̾'/'ޤޤʤʸǡ̾̾ä
 * personalityΤۤ˶ʸΥǥեȥѡʥƥ¸ߤ롣
 */

#include <stdlib.h>
#include <string.h>

#include <alloc.h>
#include <dic.h>
#include "main.h"

static struct personality{
  char *name;
  int ref_count;
  struct personality *next;
}personality_list;

static allocator personality_ator;
static struct personality *current_personality;

static struct personality *find_personality(char *);
static void reap_personality();
static void personality_dtor(void *);

int set_personality(char *id)
{
  if (!id || strchr(id, '/')) {
    id = "";
  }
  current_personality = find_personality(id);
  return 0;
}

char *get_personality()
{
  if (!current_personality) {
    set_personality("");
  }
  return current_personality->name;
}

void personality_dtor(void *a)
{
  struct personality *p = a;
  dic_release_personality(p->name);
  free(p->name);
}

struct personality *find_personality(char *id)
{
  struct personality *p;
  for (p = personality_list.next; p; p = p->next) {
    if (!strcmp(p->name, id)){
      return p;
    }
  }
  p = smalloc(personality_ator);
  p->name = strdup(id);
  p->ref_count = 0;
  p->next = personality_list.next;
  personality_list.next = p;
  return p;
}

void reap_personality()
{
  struct personality *p;
  for (p = &personality_list; p && p->next; ) {
    if (p->next->ref_count == 0
	/* ǥեȥѡʥƥϾäʤ */
	&& strlen(p->next->name)) {
      struct personality *tmp;
      tmp = p->next;
      p->next = p->next->next;
      sfree(personality_ator, tmp);
    }else{
      p = p->next;
    }
  }
}

void ref_personality()
{
  if (!current_personality) {
    set_personality("");
  }
  current_personality->ref_count++;
  /*
   * ʤѡʥƥ
   * unref()ǤƱѡʥƥ
   * ä줿줿η֤ȯΤǤǤ롣
   */
  reap_personality();
}

void unref_personality()
{
  current_personality->ref_count--;
  current_personality = 0;
}

void init_personality()
{
  personality_ator = create_allocator(sizeof(struct personality),
				      personality_dtor);
}

void quit_personality()
{
  free_allocator(personality_ator);
}
