/*
 * ʸι¤ɽˤäƤ롣
 * ɽ鹽줿ȥޥȥѤơ
 * Ȥʬ䤵줿ʸι¤Ϥ
 * ƥȤʻդ롣
 * ȥޥȥsegdef.cǺ롣
 *
 * : segdef.c ǹ줿ȥޥȥ
 * register_segstruct()ˤäϿ롣
 *
 * ư: assign_word_type()ƽФʻγƤ
 * Ԥäcommit_split_ent()ƽФ
 *
 * Copyright (C) 2000-2001 TABATA Yusuke, UGAWA Tomoharu
 */
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include <dic.h>
#include <wtype.h>
#include "main.h"
#include "segstruct.h"
#include "segexpand.h"

/* ƥ٥Ѥν */
static State *gInitialState[MAX_RULE_LEVEL];

/* ХʴĶ */
static struct split_ent *gS;
static int gNrCandidates;

/* ޥåѤδؿ */
static void traverse_stat(State *s, struct word_ent *we, int nr);
static int arrow_match(Arrow *a, struct word_ent *we);
static void set_opt_to_word_ent(int opt, struct word_ent *we);
/**/
static void do_assign_word_type(struct word_ent *we, int nr, int l);

void register_segstruct(State *s, int level)
{
  if (0 <= level && level < MAX_RULE_LEVEL) {
    gInitialState[level] = s;
  }
}

/* ܤΥդ򤿤ɤ */
void traverse_stat(State *st, struct word_ent *we, int nr)
{
  Arrow *a;
  if (nr == 0) {
    /* ϤԤ */
    Final *f;
    /* ٤Ƥκǽ֤Ф */
    for (f = st->final.next; f; f = f->next) {
	/*  롼ֹʸιsegcomposeΤ餻 */
	gS->rule = f->id;
	gNrCandidates += commit_split_ent(gS);
    }
    return ;
  }
  /* ξ֤Τ٤ƤλޤФ */
  for (a = st->arrows.next; a; a = a->next) {
    int m;
    m = arrow_match(a, we);
    /* ܲǽʻޤõơܤƤߤ */
    if (m != NOT_MATCH) {
      traverse_stat(a->to_state, &we[m], nr-m);
    }
  }
}

/* ޤդ줿Хꤹ */
void set_opt_to_word_ent(int opt, struct word_ent *we)
{
  we->bias = 10;
  if (opt & OPT_SUFFIX) {
    we->bias = 1;
  }
}

/* 
 * ArrowȤseq_ent_tӤܲǽɤå롣
 * ܲǽʤСñ񤷤֤Ǥʤ
 * NOT_MATCH(ο)֤
 */
int arrow_match(Arrow *a, struct word_ent *we)
{
  /* ޤΥפФ */
  switch (a->type) {
  case AT_SEQ:
    if (!seq_ent_cmp(a->seq, we->se)) {
      we->wt = a->wt;
      set_opt_to_word_ent(a->opt, we);
      return 1;
    }
    break;
  case AT_WTYPE:
  {
    int m;
    m = get_seq_ent_wtype_freq(we->se, a->wt);
    if (m) {
      we->wt = a->wt;
      set_opt_to_word_ent(a->opt, we);
      return 1;
    }
    we->wt = wt_none;
    return NOT_MATCH;
  }
  }
  return NOT_MATCH;
}

/* ƥ٥Υ롼ŬѤƤ */
void do_assign_word_type(struct word_ent *we, int nr, int l)
{
  if (nr == 0) {
    return ;
  }
  if (get_seq_ent_type(we[nr-1].se) & ST_UNKSEQ) {
    do_assign_word_type(we, nr-1, l);
    return ;
  }
  if (0 <= l && l < MAX_RULE_LEVEL && gInitialState[l] != 0) {
    traverse_stat(gInitialState[l], gS->we, nr);
  }
}

/* ʸΤʬγǤФʻꤢƤ */
int assign_word_type(struct split_ent *e, int l)
{
  int i;
  gS = e;
  gNrCandidates = 0;

  for (i = 0; i < gS->nr_words; i++) {
    gS->we[i].wt = wt_none;
  }

  do_assign_word_type(gS->we, gS->nr_words, l);
  return gNrCandidates;
}
