/*
 * ʸФ򥽡Ȥ롣
 * Ūˤ϶ܤʸ⸫ơñηˤɾ򤹤롣
 * ֤äκ⤹롣
 *
 * Funded by IPA̤Ƨեȥ¤ 2001 9/22
 * Copyright (C) 2000-2001 TABATA Yusuke
 * Copyright (C) 2001 UGAWA Tomoharu
 */
/*
 * Υ饹
 *  seginfo
 *  ñ
 *  ̵Ѵ
 */
#include <stdlib.h>
#include <segment.h>
#include "sorter.h"

#define OCHAIRE_BASE 1000000
#define NORMAL_BASE 100
#define SINGLEWORD_BASE 10
#define NOCONV_BASE 1

static void eval_segment(struct seg_ent *);
static void eval_candidate(struct cand_ent *);
static void sort_segment(struct seg_ent *);
static int candidate_compare_func(const void *, const void *);
static void check_dupl_candidate(struct seg_ent *);
static void release_redundant_candidate(struct seg_ent *);

void release_redundant_candidate(struct seg_ent *e)
{
  int i, j;
  for (i = 0; i < e->cand_count && e->cands[i]->score; i++);
  if (i < e->cand_count) {
    for (j = i; j < e->cand_count; j++) {
      release_cand_ent(e->cands[j]);
    }
    e->cand_count = i;
  }
}

int candidate_compare_func(const void *p1, const void *p2)
{
  const struct cand_ent **c1= p1, **c2=p2;
  return (*c2)->score - (*c1)->score;
}

void sort_segment(struct seg_ent *s)
{
  qsort(s->cands,s->cand_count,
	sizeof(struct cand_ent *),
	candidate_compare_func);
}

void check_dupl_candidate(struct seg_ent *s)
{
  int i,j;
  for (i = 0; i < s->cand_count - 1; i++) {
    for (j = i + 1; j < s->cand_count; j++) {
      if (!xstrcmp(&s->cands[i]->str, &s->cands[j]->str)) {
	/* 롼ɤޥåΤ֤Ȥ٤ */
	s->cands[j]->score = 0;
	s->cands[i]->flag |= s->cands[j]->flag;
      }
    }
  }
}

void eval_candidate(struct cand_ent *c)
{
  int i;

  if ((c->flag & (CEF_OCHAIRE | CEF_SINGLEWORD | CEF_NOCONV)) == 0) {
    /* ʻƤˤä줿 */
    c->score = NORMAL_BASE;
    /* ޤñ٤ˤscoreû */
    for (i = 0; i < c->nr_words && i < 1; i++) {
      struct cand_elm *elm = &c->elm[i];
      if (elm->nth >= 0) {
	c->score += 
	  get_nth_dic_ent_freq(elm->s, elm->nth) * elm->bias *
	  elm->str.len * elm->str.len;
      }
    }
  } else if (c->flag & CEF_OCHAIRE) {
    c->score = OCHAIRE_BASE;
  } else if (c->flag & CEF_SINGLEWORD) {
    c->score = SINGLEWORD_BASE;
  } else if (c->flag & CEF_NOCONV) {
    c->score = NOCONV_BASE;
  }
  c->score += 1;
}

void eval_segment(struct seg_ent *s)
{
  int i;
  for (i = 0; i < s->cand_count; i++) {
    eval_candidate(s->cands[i]);
  }
}

/* ƤФ륨ȥݥ */
void sort_candidate(struct segment_list *seg, int nth)
{
    int i;
    /* ޤɾ */
    for (i = nth; i < seg->nr_segments; i++) {
        eval_segment(get_nth_segment(seg, i));
    }
    /* Ĥ¤Ӥ */
    for (i = nth; i < seg->nr_segments; i++) {
        sort_segment(get_nth_segment(seg, i));
    }
    /* ֤äȥ㤤0դ */
    for (i = nth; i < seg->nr_segments; i++) {
      check_dupl_candidate(get_nth_segment(seg, i));
    }
    /* ⤦¤Ӥ */
    for ( i = nth ; i < seg->nr_segments ; i++){
        sort_segment(get_nth_segment(seg, i));
    }
    /* ɾ0θ */
    for (i = nth ;i < seg->nr_segments ; i++) {
      release_redundant_candidate(get_nth_segment(seg, i));
    }
    /* θ */
    for (i = nth; i < seg->nr_segments; i++){
      proc_swap_candidate(get_nth_segment(seg, i));
    }
}
