/*
 * ʸκǽ餫˥⤯ʤ褦metawordǤ
 * metawordˤA*Ѥ롣
 *
 * eval_border() ǻꤵ줿ΰʸʬ䤹
 * Funded by IPA̤Ƨեȥ¤ 2001 10/29
 * Copyright (C) 2000-2001 TABATA Yusuke, UGAWA Tomoharu
 */
#include <stdio.h>
#include <stdlib.h>

#include <alloc.h>
#include <splitter.h>
#include "wordborder.h"

/**/
#define ASTAR_DEPTH 4
#define ASTAR_HEAP_DEPTH 2048
#define ASTAR_EXPAND_LIMIT 4096

struct Astar_node{
  struct meta_word *mw[ASTAR_DEPTH];
  int nr_mw;
  int score;
  int from;
  int len;
};

/*
 * ǤҡפȤΤϸϤΤĤǤϤʤơ
 * 2ʬڤޤǡֹnλҤ2n2n+1ˤʤäƤơ
 * ƤϻҥΡɤ礭ȤȤinvariant
 * Ȥ뤳Ȥˤ롼ȥΡɤˤϺǤ¸ߤ롣
 */
static struct Astar_heap{
  struct Astar_node **heap;
  int nr_nodes;
}astar_heap;

static struct{
  struct Astar_node best;
  int best_score;
}search_stat;

allocator node_ator;

/* A*Ϣ */
static void mark_by_metaword(struct splitter_context *, struct meta_word *);
static struct Astar_node *alloc_astar_node();
static void init_astar_heap();
static void free_astar_heap();
static void rebalance_astar_heap_from_root(int );
static void push_astar_node(struct splitter_context *, struct Astar_node *);
static struct Astar_node *pop_astar_node();
static void expand_astar_node(struct splitter_context *, struct Astar_node *,int);
static void print_astar_node(struct splitter_context *, struct Astar_node *);
static void shrink_redundant_branch(struct splitter_context *);
static int do_split(struct splitter_context *, int, int);
/**/
static void metaword_constraint_check(struct splitter_context *c, struct meta_word *);
static void metaword_constraint_check_all(struct splitter_context *, int, int );
void seg_constraint_check_all(struct splitter_context *, int, int );

void print_astar_node(struct splitter_context *c, struct Astar_node *n)
{
  int i;
  printf("A* node %d\n", n->score);
  for (i = 0; i < n->nr_mw; i++) {
    print_metaword(c, n->mw[i]);
  }
  printf("\n");
}

struct Astar_node *alloc_astar_node()
{
  struct Astar_node *a = smalloc(node_ator);
  a->nr_mw = 0;
  a->len = 0;
  return a;
}

/*
 * ˤäƷꤵ줿metawordˤä
 * ʸᶭޡ
 */
void mark_by_metaword(struct splitter_context * c, struct meta_word *mw)
{
  struct word_split_info_cache *info = c->word_split_info;
  if (!mw) {
    return ;
  }
//  print_metaword(mw);
  switch(mw->type){
  case MW_NAMEPAIR:
    mark_by_metaword(c, mw->mw1);
    mark_by_metaword(c, mw->mw2);
    break;
  case MW_OCHAIRE:
    mark_by_metaword(c, mw->mw1);
    break;
  case MW_OCHAIRE_LEAF:
    info->seg_border[mw->from] = 1;
    if (mw->mw1) {
      mark_by_metaword(c, mw->mw1);
    }
    break;
  case MW_WRAP:
    mark_by_metaword(c, mw->mw1);
    break;
  case MW_DUMMY:
  case MW_SINGLE:
  case MW_V_RENYOU_A:
  case MW_V_RENYOU_T:
    if (mw->wl) {
      info->seg_border[mw->wl->from] = 1;
    }
    break;
  default:
    printf("Unknown type of metaword (%d).\n", mw->type);
  }
}

/*
 * ҡפΥ롼ȤΤǥ롼Ȥ
 * ƥΡɤ򤺤餹
 */
void rebalance_astar_heap_from_root(int n)
{
  int l, r;
  int ls, rs, ns;
  struct Astar_node *nn, *ln, *rn;
  l = 2 * (n + 1) - 1;
  r = 2 * (n + 1);
  ls = -2000000000;
  rs = -2000000000;
  ln = 0;
  rn = 0;
  ns = astar_heap.heap[n]->score;
  nn = astar_heap.heap[n];
  if (l < ASTAR_HEAP_DEPTH) {
    ln = astar_heap.heap[l];
  }
  if (r < ASTAR_HEAP_DEPTH) {
    rn = astar_heap.heap[r];
  }
  if (ln) {
    ls = ln->score;
  }
  if (rn) {
    rs = rn->score;
  }
  if (ns > ls && ns > rs) {
    return ;
  }
  if (ls > rs) {
    astar_heap.heap[n] = ln;
    astar_heap.heap[l] = nn;
    rebalance_astar_heap_from_root(l);
  }else{
    astar_heap.heap[n] = rn;
    astar_heap.heap[r] = nn;
    rebalance_astar_heap_from_root(r);
  }
}

void push_astar_node(struct splitter_context *c, struct Astar_node *a)
{
  int n,p;

  if (astar_heap.nr_nodes >= ASTAR_HEAP_DEPTH-1) {
    sfree(node_ator, a);
    return ;
  }
  a->score = 0;
  for (n = 0; n < a->nr_mw; n++) {
    a->score += a->mw[n]->score;
  }

  if (a->nr_mw){
    a->score /= a->nr_mw;
  }

  //print_astar_node(a);
  astar_heap.heap[astar_heap.nr_nodes] = a;
  astar_heap.nr_nodes ++;
  /* leaf¦rebalance */
  n = astar_heap.nr_nodes - 1;
  while (n) {
    p = (n - 1) / 2;
    if (astar_heap.heap[p]->score < astar_heap.heap[n]->score) {
      struct Astar_node *tmp;
      tmp = astar_heap.heap[p];
      astar_heap.heap[p] = astar_heap.heap[n];
      astar_heap.heap[n] = tmp;
    }
    n = p;
  }
}

struct Astar_node *pop_astar_node()
{
  struct Astar_node *n;
  n = astar_heap.heap[0];
  if (!n) {
    return 0;
  }

  astar_heap.nr_nodes--;
  astar_heap.heap[0] = astar_heap.heap[astar_heap.nr_nodes];
  astar_heap.heap[astar_heap.nr_nodes] = 0;
  if (astar_heap.nr_nodes){
    /* root¦rebalance */
    rebalance_astar_heap_from_root(0);
  }
  return n;
}

/* ΡɤŸ */
void expand_astar_node(struct splitter_context *c, struct Astar_node *a, int to)
{
  int t = a->from + a->len;
  int nr_expand = 0;
  struct word_split_info_cache *info = c->word_split_info;

  if (a->nr_mw < ASTAR_DEPTH -1 && t <= to) {
    struct meta_word *mw;
    for (mw = info->metawords[t].next; mw; mw = mw->next) {
      if (mw->can_use == ok) {
	struct Astar_node *n = alloc_astar_node();
	*n = *a;
	n->mw[n->nr_mw] = mw;
	n->nr_mw++;
	n->len += mw->len;
	push_astar_node(c, n);
	nr_expand ++;
      }
    }
  }
  if (nr_expand ==0 && a->score > search_stat.best_score) {
    search_stat.best_score = a->score;
    search_stat.best = *a;
  }
  sfree(node_ator, a);
}

void init_astar_heap()
{
  int i;
  if (!astar_heap.heap) {
    astar_heap.heap =
      malloc(sizeof(struct Astar_node *) * ASTAR_HEAP_DEPTH);
  }
  for (i = 0; i < ASTAR_HEAP_DEPTH; i++) {
    astar_heap.heap[i] = 0;
  }
  astar_heap.nr_nodes = 0;
}

void free_astar_heap()
{
  int i;
  for (i = 0; i < ASTAR_HEAP_DEPTH; i++) {
    if (astar_heap.heap[i]){
      sfree(node_ator, astar_heap.heap[i]);
    }
  }
  astar_heap.nr_nodes = 0;
}

/*
 * ʸζդ
 * ֤ͤϤθդʸαüΥǥå
 */
int do_split(struct splitter_context *c, int from, int to)
{
  struct Astar_node *a;
  int l, result;
  init_astar_heap();
  search_stat.best_score = 0;

  a = alloc_astar_node();
  a->from = from;
  push_astar_node(c, a);
  for (l = ASTAR_EXPAND_LIMIT; l >0; l--) {
    a = pop_astar_node();
    if (!a) {
      goto out;
    }
    expand_astar_node(c, a, to);
  }
 out:

  if (search_stat.best_score > 0) {
    mark_by_metaword(c, search_stat.best.mw[0]);
    result = search_stat.best.mw[0]->len + from;
  }else{
    result = to;
  }

  free_astar_heap();

  return result;
}

/* Ʊΰ򥫥СmetawordΤ㤤Ȥʤ */
void shrink_redundant_branch(struct splitter_context *c)
{
  int i, j;
  struct word_split_info_cache *info = c->word_split_info;
  for (i = 0; i < c->char_count; i++) {
    for (j = 1; j <= c->char_count - i; j++) {
      struct meta_word *mw, *max = NULL;
      for (mw = info->metawords[i].next; mw; mw = mw->next) {
	if (mw->len == j && mw->can_use == ok) {
	  if (!max || (max->score < mw->score)) {
	    max = mw;
	  }
	}
      }
      for (mw = info->metawords[i].next; mw; mw = mw->next) {
	if (mw->len == j && max && max != mw) {
	  mw->can_use = ng;
	}
      }
    }
  }
}

/* ʸᶭ­ʤʸ */
void seg_constraint_check_all(struct splitter_context *c, int from, int to)
{
  int i, j;
  for (i = from; i < to; i++) {
    struct word_list *wl;
    for (wl = c->word_split_info->lists[i].next; wl; wl = wl->next) {
      wl->can_use = ok;
      for (j = 1; j < wl->len; j++) {
	if (c->ce[i + j].seg_border) {
	  wl->can_use = ng;
	}
      }
    }
  }
}

/*
 * ƵŪmetawordѲǽå
 */
void metaword_constraint_check(struct splitter_context *c, struct meta_word *mw)
{
  struct word_split_info_cache *info = c->word_split_info;
  if (mw->can_use != unchecked) {
    return ;
  }
  switch (mw->type) {
  case MW_DUMMY:
    if (!mw->wl) {
      int i;
      mw->can_use = ok;
      for (i = 1; i < mw->len; i++) {
	if (c->ce[i + mw->from].seg_border) {
	  mw->can_use = ng;
	}
      }
    }
    /* break̵ */
  case MW_SINGLE:
    if (!mw->wl || mw->wl->can_use == ok) {
      mw->can_use = ok;
    } else {
      mw->can_use = ng;
    }
    break;
  case MW_WRAP:
    metaword_constraint_check(c, mw->mw1);
    mw->can_use = mw->mw1->can_use;
    break;
  case MW_V_RENYOU_A:
  case MW_V_RENYOU_T:
    if (info->seg_border[mw->mw1->from + mw->mw1->len]) {
      /* 礦ɶܤ˥ޡäƤ */
      mw->can_use = ng;
      break;
    }
    /* break̵ */
  case MW_NAMEPAIR:
    metaword_constraint_check(c, mw->mw1);
    metaword_constraint_check(c, mw->mw2);
    if (mw->mw1->can_use == ok && mw->mw2->can_use == ok) {
      mw->can_use = ok;
    }
    break;
  case MW_OCHAIRE:
    {
      int i;
      struct meta_word* mw1;
      for (mw1 = mw; mw1; mw1 = mw1->mw1) {
	mw1->can_use = ok;
      }
      for (i = mw->from + 1; i < mw->from + mw->len; i++) {
	if (c->ce[i].seg_border) {
	  for (mw1 = mw; mw1; mw1 = mw1->mw1) {
	    mw1->can_use = ng;
	  }
	  break;
	}
      }
    }
    break;
  case MW_OCHAIRE_LEAF:
    break;
  default:;
  }
}

/*
 * word_listξmetawordѤǤ뤫å
 */
void metaword_constraint_check_all(struct splitter_context *c, int from, int to)
{
  int i;
  struct word_split_info_cache *info;
  info = c->word_split_info;

  /* ޤuncheckedˤ */
  for (i = from; i < to; i ++) {
    struct meta_word *mw;
    for (mw = info->metawords[i].next; mw; mw = mw->next) {
      mw->can_use = unchecked;
    }
  }

  /* ˹줿metawordˤĤƥå */
  for (i = from; i < to; i ++) {
    struct meta_word *mw;
    for (mw = info->metawords[i].next; mw; mw = mw->next) {
      metaword_constraint_check(c, mw);
    }
  }
}

/*
 * ʸᶭޡ
 */
void eval_border(struct splitter_context *c, int from, int to)
{
  node_ator = create_allocator(sizeof(struct Astar_node), 0);
  /* ʸΤȤΤΤ */
  seg_constraint_check_all(c, from, to);
  metaword_constraint_check_all(c, from, to);

  /* Ʊΰ򥫥Сƥ㤤metawordä*/
  shrink_redundant_branch(c);

  do{
    from = do_split(c, from, to);
  } while (from < to);
  free_allocator(node_ator);
}
